/*
 * Decompiled with CFR 0.152.
 */
package com.netfinworks.mq.jms.impl;

import com.netfinworks.mq.jms.DestinationResolver;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;

public class DestinationResolverImpl
implements DestinationResolver {
    private Map<String, Destination> cachedDestination = new HashMap<String, Destination>();
    private static DestinationResolver destinationResolver = new DestinationResolverImpl();

    private DestinationResolverImpl() {
    }

    public static DestinationResolver getInstance() {
        return destinationResolver;
    }

    @Override
    public Destination getDestination(Session session, String destinationName, int destinationType) throws JMSException {
        Destination destination = this.cachedDestination.get(destinationName);
        if (destination == null) {
            if (destinationType == 0) {
                destination = session.createQueue(destinationName);
            } else if (destinationType == 3) {
                destination = session.createTopic(destinationName);
            }
            this.cachedDestination.put(destinationName, destination);
        }
        return destination;
    }

    public Destination resolveDestinationName(Session session, String destinationName, boolean pubSubDomain) throws JMSException {
        Object destination = this.cachedDestination.get(destinationName);
        if (destination == null) {
            destination = pubSubDomain ? session.createTopic(destinationName) : session.createQueue(destinationName);
            this.cachedDestination.put(destinationName, (Destination)destination);
        }
        return destination;
    }
}

