/*
 * Decompiled with CFR 0.152.
 */
package com.netfinworks.mq.jms.impl;

import com.netfinworks.mq.core.MQException;
import com.netfinworks.mq.core.MQService;
import com.netfinworks.mq.jms.JmsAccessor;
import com.netfinworks.mq.request.MQRequest;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JmsService
implements MQService {
    private static Log log = LogFactory.getLog(JmsService.class);
    private JmsAccessor mqAccessor;

    public void sendMessage(MQRequest request) throws MQException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Executing to send message: " + request));
        }
        if (request.getDestination() != null) {
            int destinationType = request.getDestinationType();
            if (destinationType != 0 && destinationType != 3) {
                throw new IllegalArgumentException("Invalid destination type:" + destinationType);
            }
            try {
                this.mqAccessor.sendMessage(request.getDestination(), destinationType, request);
            }
            catch (JMSException e) {
                throw new MQException((Throwable)e);
            }
        } else {
            int actionId = request.getActionId();
            if (actionId >= 0) {
                this.mqAccessor.sendMessage(request);
            } else {
                throw new IllegalArgumentException("ActionId and destination cannot be null at same time.");
            }
        }
    }

    public Object receiveMessage(String queueName) throws MQException {
        return this.mqAccessor.receiveMessage(queueName);
    }

    public Object receiveMessage(int actionId) throws MQException {
        return this.receiveMessage(actionId, null);
    }

    public Object receiveMessage(int actionId, String selector) throws MQException {
        return this.receiveMessage(actionId, false, 1, null);
    }

    public Object receiveMessage(int actionId, boolean transacted, int acknowledgeMode, String selector) throws MQException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Executing to receive message: " + actionId));
        }
        if (actionId <= 0) {
            throw new IllegalArgumentException("Action id must be greater than zero.");
        }
        return this.mqAccessor.receiveMessage(actionId, transacted, acknowledgeMode, selector);
    }

    public void setMqAccessor(JmsAccessor mqAccessor) {
        this.mqAccessor = mqAccessor;
    }
}

