/*
 * Decompiled with CFR 0.152.
 */
package com.netfinworks.rest.audit;

import com.netfinworks.rest.enums.HttpStatus;
import com.netfinworks.rest.filter.ImmutableResponse;
import com.netfinworks.rest.filter.Response;
import java.io.InputStream;

public class AuditResult {
    private boolean compliant;
    private Response response;

    private AuditResult() {
    }

    public static AuditResult compliantAuditResult() {
        AuditResult result = new AuditResult();
        result.compliant = true;
        result.response = null;
        return result;
    }

    public static AuditResult incompliantAuditResult() {
        AuditResult result = new AuditResult();
        result.compliant = false;
        result.response = new Response();
        result.response.setStatus(HttpStatus.FORBIDDEN);
        return result;
    }

    public void setResponseInputStream(InputStream input) {
        if (this.response != null) {
            this.response.setInputStream(input);
        }
    }

    public void addResponseHeader(String name, String value) {
        if (this.response != null) {
            this.response.addHeader(name, value);
        }
    }

    public void setResponseStatus(HttpStatus status) {
        if (this.response != null) {
            this.response.setStatus(status);
        }
    }

    public Response getImmutableResponse() {
        return new ImmutableResponse(this.response);
    }

    public boolean isCompliant() {
        return this.compliant;
    }
}

