/*
 * Decompiled with CFR 0.152.
 */
package com.netfinworks.rest.auth;

import com.netfinworks.rest.enums.HttpStatus;
import com.netfinworks.rest.filter.ImmutableResponse;
import com.netfinworks.rest.filter.Response;
import java.io.InputStream;

public class AuthCheckResult {
    private boolean passed;
    private Response response;

    private AuthCheckResult() {
    }

    public static AuthCheckResult authorizedInstance() {
        AuthCheckResult result = new AuthCheckResult();
        result.passed = true;
        result.response = null;
        return result;
    }

    public static AuthCheckResult unauthorizedInstance() {
        AuthCheckResult result = new AuthCheckResult();
        result.passed = false;
        result.response = new Response();
        result.response.setStatus(HttpStatus.UNAUTHORIZED);
        return result;
    }

    public boolean isPassed() {
        return this.passed;
    }

    public void setResponseInputStream(InputStream in) {
        this.response.setInputStream(in);
    }

    public void addResponseHeader(String name, String value) {
        if (this.response != null) {
            this.response.addHeader(name, value);
        }
    }

    public Response getImmutableResponse() {
        return new ImmutableResponse(this.response);
    }
}

