/*
 * Decompiled with CFR 0.152.
 */
package com.netfinworks.rest.auth;

import com.netfinworks.rest.auth.AuthCheckResult;
import com.netfinworks.rest.auth.IAuthCheck;
import com.netfinworks.rest.auth.SimpleUserPasswordCheck;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthCheck
implements IAuthCheck {
    private IUserPasswordCheck userPasswordCheck = new SimpleUserPasswordCheck();
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void setUserPasswordCheck(IUserPasswordCheck userPasswordCheck) {
        this.logger.info("set user password check:" + userPasswordCheck);
        this.userPasswordCheck = userPasswordCheck;
    }

    @Override
    public AuthCheckResult checkAuth(Map<String, String> headers) {
        String authorization = headers.get("authorization");
        if (authorization != null) {
            String[] authInfos = authorization.split(" ");
            if (authInfos.length != 2) {
                return this.refused();
            }
            if (!"Basic".equals(authInfos[0])) {
                return this.refused();
            }
            String userPwdBase64 = authInfos[1].trim();
            if (userPwdBase64.length() == 0) {
                return this.refused();
            }
            String userPwd = new String(Base64.decodeBase64((String)userPwdBase64));
            String[] userAndPassword = userPwd.split(":");
            if (this.checkUserPassword(userAndPassword[0], userAndPassword[1])) {
                return AuthCheckResult.authorizedInstance();
            }
        }
        return this.refused();
    }

    private AuthCheckResult refused() {
        AuthCheckResult result = AuthCheckResult.unauthorizedInstance();
        result.addResponseHeader("www-authenticate", "Basic realm=\"netfinworks Authenticated\"");
        return result;
    }

    private boolean checkUserPassword(String user, String password) {
        return this.userPasswordCheck.checkUserPassword(user, password);
    }

    public static interface IUserPasswordCheck {
        public boolean checkUserPassword(String var1, String var2);
    }
}

