/*
 * Decompiled with CFR 0.152.
 */
package com.netfinworks.rest.convert;

import com.netfinworks.rest.convert.IParamConvert;
import com.netfinworks.rest.convert.PrimitiveParamConvert;
import com.netfinworks.rest.util.ConvertUtil;
import com.netfinworks.rest.util.FormDecoder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Form2PojoParamConvert
implements IParamConvert {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static PrimitiveParamConvert primitiveConvert = new PrimitiveParamConvert();
    protected static final Class<?>[] emptyClazzArray = new Class[0];
    protected String encoding = "UTF-8";
    private BeanUtilsBean beanUtilsBean = new BeanUtilsBean();
    protected Map<String, IParamConvert> classParamConvertRegistry = new HashMap<String, IParamConvert>();

    @Override
    public <T> T convert(String raw, Class<T> distClass) {
        Map<String, String[]> decoded = FormDecoder.decode(raw);
        try {
            T pojo = distClass.newInstance();
            Set<Map.Entry<String, String[]>> entries = decoded.entrySet();
            for (Map.Entry<String, String[]> entry : entries) {
                IParamConvert paramConvert;
                Object convertedValue;
                Class<?> cls;
                String[] values = entry.getValue();
                String name = entry.getKey();
                if (name == null || "".equals(name) || (cls = this.getPropertyClass(distClass, name)) == null || (convertedValue = ConvertUtil.convertUrlEncodedStringAsArray(values, this.encoding, cls, (paramConvert = this.classParamConvertRegistry.get(cls.getName())) == null ? primitiveConvert : paramConvert)) == null) continue;
                this.beanUtilsBean.setProperty(pojo, name, convertedValue);
            }
            return pojo;
        }
        catch (InstantiationException e) {
            this.logger.error("can't instantiate a pojo of {}, please check the Pojo", distClass);
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            this.logger.error("can't invoke none-args constructor of a pojo of {}, please check the Pojo", distClass);
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            this.logger.error("set pojo property error!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setDateFormat(String dateFormat) {
        primitiveConvert.setDateFormat(dateFormat);
    }

    public void setClassParamConvertRegistry(Map<String, IParamConvert> classParamConvertRegistry) {
        this.classParamConvertRegistry = classParamConvertRegistry;
    }

    protected Class<?> getPropertyClass(Class<?> clazz, String propertyName) {
        Class<?> cls = this.getPropertyClass(clazz, propertyName, "get");
        if (cls == null) {
            cls = this.getPropertyClass(clazz, propertyName, "is");
        }
        return cls;
    }

    private Class<?> getPropertyClass(Class<?> clazz, String propertyName, String prefix) {
        StringBuffer buf;
        int char0 = (buf = new StringBuffer(propertyName)).charAt(0);
        buf.setCharAt(0, (char)(char0 >= 97 ? char0 - 32 : char0));
        buf.insert(0, prefix);
        try {
            Method m = clazz.getMethod(buf.toString(), emptyClazzArray);
            return m.getReturnType();
        }
        catch (SecurityException e) {
            this.logger.debug("property can't be access! ");
            return null;
        }
        catch (NoSuchMethodException e) {
            this.logger.debug("property '{}' doesn't exist! ", (Object)buf.toString());
            return null;
        }
    }
}

