/*
 * Decompiled with CFR 0.152.
 */
package com.netfinworks.rest.convert;

import com.netfinworks.rest.convert.Form2PojoParamConvert;
import com.netfinworks.rest.convert.IParamConvert;
import com.netfinworks.rest.filter.Request;
import com.netfinworks.rest.util.ConvertUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileCleaningTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class MultiPartFormDataParamConvert
extends Form2PojoParamConvert
implements DisposableBean {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static FileCleaningTracker tracker = new FileCleaningTracker();
    private static DiskFileItemFactory factory = new DiskFileItemFactory();

    static {
        factory.setSizeThreshold(524288);
        factory.setFileCleaningTracker(tracker);
    }

    public void destroy() throws Exception {
        this.logger.info("MultiPartFormDataParamConvert destroy.");
        tracker.exitWhenFinished();
    }

    @Override
    public <T> T convert(String paramString, Class<T> paramClass) {
        throw new IllegalAccessError("multipart form can't convert by string.");
    }

    public <T> T convert(Request restRequest, Class<T> paramClass) {
        try {
            T pojo = paramClass.newInstance();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            upload.setFileSizeMax(0x500000L);
            List items = upload.parseRequest(restRequest.getRawRequest());
            for (FileItem item : items) {
                this.logger.debug(item.toString());
                if (item.isFormField()) {
                    this.processFormField(item, pojo);
                    continue;
                }
                this.processUploadedFile(item, pojo);
            }
            return pojo;
        }
        catch (InstantiationException e) {
            this.logger.error("can't instantiate a pojo of {}, please check the Pojo", paramClass);
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            this.logger.error("can't invoke none-args constructor of a pojo of {}, please check the Pojo", paramClass);
            throw new RuntimeException(e);
        }
        catch (FileUploadException e) {
            this.logger.error("fileupload error.", paramClass);
            throw new RuntimeException(e);
        }
    }

    public <T> void processUploadedFile(FileItem item, T pojo) {
        try {
            String name = item.getFieldName();
            if (name == null || "".equals(name)) {
                return;
            }
            Class<?> cls = this.getPropertyClass(pojo.getClass(), name);
            if (cls == null) {
                return;
            }
            if (cls.equals(String.class)) {
                String value = item.getString(this.encoding);
                IParamConvert paramConvert = (IParamConvert)this.classParamConvertRegistry.get(cls.getName());
                Object oldValue = this.getPropertyValue(pojo, pojo.getClass(), name);
                Object convertedValue = ConvertUtil.addUrlEncodedStringIfArray(oldValue, value, this.encoding, cls, paramConvert == null ? primitiveConvert : paramConvert);
                if (convertedValue != null) {
                    BeanUtils.setProperty(pojo, (String)name, (Object)convertedValue);
                }
            } else if (cls.equals(InputStream.class)) {
                InputStream convertedValue = item.getInputStream();
                if (convertedValue != null) {
                    BeanUtils.setProperty(pojo, (String)name, (Object)convertedValue);
                }
            } else if (cls.equals(FileItem.class)) {
                BeanUtils.setProperty(pojo, (String)name, (Object)item);
            } else {
                this.logger.warn("Not support field[{}] type:{}.", (Object)name, cls);
            }
        }
        catch (IllegalAccessException e) {
            this.logger.error("can't invoke none-args constructor of a pojo of {}, please check the Pojo", pojo.getClass());
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            this.logger.error("set pojo property error!", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("can't convert stream to " + this.encoding, (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            this.logger.error("getInputStream from item error!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public <T> void processFormField(FileItem item, T pojo) {
        try {
            String value = item.getString(this.encoding);
            String name = item.getFieldName();
            if (name == null || "".equals(name)) {
                return;
            }
            Class<?> cls = this.getPropertyClass(pojo.getClass(), name);
            if (cls == null) {
                return;
            }
            IParamConvert paramConvert = (IParamConvert)this.classParamConvertRegistry.get(cls.getName());
            Object oldValue = this.getPropertyValue(pojo, pojo.getClass(), name);
            Object convertedValue = ConvertUtil.addUrlEncodedStringIfArray(oldValue, value, this.encoding, cls, paramConvert == null ? primitiveConvert : paramConvert);
            if (convertedValue != null) {
                BeanUtils.setProperty(pojo, (String)name, (Object)convertedValue);
            }
        }
        catch (IllegalAccessException e) {
            this.logger.error("can't invoke none-args constructor of a pojo of {}, please check the Pojo", pojo.getClass());
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            this.logger.error("set pojo property error!", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("can't convert stream to " + this.encoding, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected <T> Object getPropertyValue(T pojo, Class<?> clazz, String propertyName) {
        Object v = null;
        try {
            v = this.getPropertyValue(pojo, clazz, propertyName, "get");
        }
        catch (NoSuchMethodException e) {
            try {
                v = this.getPropertyValue(pojo, clazz, propertyName, "is");
            }
            catch (NoSuchMethodException e1) {
                this.logger.debug("property '{}' doesn't exist! ", (Object)propertyName);
            }
        }
        return v;
    }

    private <T> Object getPropertyValue(T pojo, Class<?> clazz, String propertyName, String prefix) throws NoSuchMethodException {
        StringBuffer buf;
        int char0 = (buf = new StringBuffer(propertyName)).charAt(0);
        buf.setCharAt(0, (char)(char0 >= 97 ? char0 - 32 : char0));
        buf.insert(0, prefix);
        Method m = null;
        try {
            m = clazz.getMethod(buf.toString(), emptyClazzArray);
            return m.invoke(pojo, new Object[0]);
        }
        catch (SecurityException e) {
            this.logger.debug("property can't be access! ");
            return null;
        }
        catch (NoSuchMethodException e) {
            this.logger.debug("property '{}' doesn't exist! ", (Object)buf.toString());
            throw e;
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("method can't be invoke! wrong argument. " + e.toString());
            return null;
        }
        catch (IllegalAccessException e) {
            this.logger.debug("method can't be invoke! access exception. " + e.toString());
            return null;
        }
        catch (InvocationTargetException e) {
            this.logger.debug("method can't be invoke! invocation target. " + e.toString());
            return null;
        }
    }
}

