/*
 * Decompiled with CFR 0.152.
 */
package com.netfinworks.rest.convert;

import com.netfinworks.rest.convert.IParamConvert;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class PrimitiveParamConvert
implements IParamConvert {
    private Map<Class<?>, IParamConvert> convertMaps = new HashMap();
    private String defaultDateFormat = "yyyy-MM-dd HH:mm:ss";

    public PrimitiveParamConvert() {
        IntegerConvert ic = new IntegerConvert();
        this.convertMaps.put(Integer.class, ic);
        this.convertMaps.put(Integer.TYPE, ic);
        FloatConvert fc = new FloatConvert();
        this.convertMaps.put(Float.class, fc);
        this.convertMaps.put(Float.TYPE, fc);
        DoubleConvert dc = new DoubleConvert();
        this.convertMaps.put(Double.class, dc);
        this.convertMaps.put(Double.TYPE, dc);
        LongConvert lc = new LongConvert();
        this.convertMaps.put(Long.class, lc);
        this.convertMaps.put(Long.TYPE, lc);
        ShortConvert sc = new ShortConvert();
        this.convertMaps.put(Short.class, sc);
        this.convertMaps.put(Short.TYPE, sc);
        CharConvert cc = new CharConvert();
        this.convertMaps.put(Character.class, cc);
        this.convertMaps.put(Character.TYPE, cc);
        ByteConvert bc = new ByteConvert();
        this.convertMaps.put(Byte.class, bc);
        this.convertMaps.put(Byte.TYPE, bc);
        BooleanConvert boc = new BooleanConvert();
        this.convertMaps.put(Boolean.class, boc);
        this.convertMaps.put(Boolean.TYPE, boc);
        DateConvert dateConvert = new DateConvert();
        dateConvert.setDateFormat(this.defaultDateFormat);
        this.convertMaps.put(Date.class, dateConvert);
        EnumConvert enumConvert = new EnumConvert();
        this.convertMaps.put(Enum.class, enumConvert);
    }

    public void setDateFormat(String dateFormat) {
        ((DateConvert)this.convertMaps.get(Date.class)).setDateFormat(dateFormat);
    }

    public void register(Class<?> type, IParamConvert convert) {
        if (type != null && convert != null) {
            this.convertMaps.put(type, convert);
        }
    }

    @Override
    public <T> T convert(String raw, Class<T> distClass) {
        if (distClass.equals(String.class)) {
            return (T)raw;
        }
        if (raw != null) {
            IParamConvert convert = this.lookup(distClass);
            if (convert != null) {
                return convert.convert(raw, distClass);
            }
            convert = this.lookup(Enum.class);
            T distValue = convert.convert(raw, distClass);
            if (distValue != null) {
                return distValue;
            }
            throw new RuntimeException("no convert set to " + distClass);
        }
        return null;
    }

    private IParamConvert lookup(Class<?> clazz) {
        IParamConvert convert = this.convertMaps.get(clazz);
        return convert;
    }

    static class BooleanConvert
    implements IParamConvert {
        BooleanConvert() {
        }

        @Override
        public <T> T convert(String raw, Class<T> distClass) {
            return (T)Boolean.valueOf(raw);
        }
    }

    static class ByteConvert
    implements IParamConvert {
        ByteConvert() {
        }

        @Override
        public <T> T convert(String raw, Class<T> distClass) {
            return (T)Byte.valueOf(Byte.parseByte(raw));
        }
    }

    static class CharConvert
    implements IParamConvert {
        CharConvert() {
        }

        @Override
        public <T> T convert(String raw, Class<T> distClass) {
            return (T)Character.valueOf(raw.charAt(0));
        }
    }

    static final class DateConvert
    implements IParamConvert {
        private String dateFormat;

        DateConvert() {
        }

        @Override
        public <T> T convert(String paramString, Class<T> paramClass) {
            block3: {
                try {
                    if (paramString.trim().length() != 0) break block3;
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("date convert args illegal", e);
                }
                return null;
            }
            Date date = new SimpleDateFormat(this.dateFormat).parse(paramString);
            return paramClass.cast(date);
        }

        public void setDateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
        }
    }

    static class DoubleConvert
    implements IParamConvert {
        DoubleConvert() {
        }

        @Override
        public <T> T convert(String raw, Class<T> distClass) {
            if ("".equals(raw)) {
                return (T)Double.valueOf(0.0);
            }
            return (T)Double.valueOf(Double.parseDouble(raw));
        }
    }

    static final class EnumConvert
    implements IParamConvert {
        EnumConvert() {
        }

        @Override
        public <T> T convert(String paramString, Class<T> paramClass) {
            try {
                T distInst = Enum.valueOf(paramClass, paramString);
                return distInst;
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    static class FloatConvert
    implements IParamConvert {
        FloatConvert() {
        }

        @Override
        public <T> T convert(String raw, Class<T> distClass) {
            if ("".equals(raw)) {
                return (T)Float.valueOf(0.0f);
            }
            return (T)Float.valueOf(Float.parseFloat(raw));
        }
    }

    static class IntegerConvert
    implements IParamConvert {
        IntegerConvert() {
        }

        @Override
        public <T> T convert(String raw, Class<T> distClass) {
            if ("".equals(raw)) {
                return (T)Integer.valueOf(0);
            }
            return (T)Integer.valueOf(Integer.parseInt(raw));
        }
    }

    static class LongConvert
    implements IParamConvert {
        LongConvert() {
        }

        @Override
        public <T> T convert(String raw, Class<T> distClass) {
            if ("".equals(raw)) {
                return (T)Long.valueOf(0L);
            }
            return (T)Long.valueOf(Long.parseLong(raw));
        }
    }

    static class ShortConvert
    implements IParamConvert {
        ShortConvert() {
        }

        @Override
        public <T> T convert(String raw, Class<T> distClass) {
            if ("".equals(raw)) {
                return (T)Short.valueOf((short)0);
            }
            return (T)Short.valueOf(Short.parseShort(raw));
        }
    }

    static class StringConvert
    implements IParamConvert {
        StringConvert() {
        }

        @Override
        public <T> T convert(String raw, Class<T> distClass) {
            return distClass.cast(raw);
        }
    }
}

