/*
 * Decompiled with CFR 0.152.
 */
package com.netfinworks.rest.filter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public final class AppContextHolder {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ConfigurableApplicationContext applicationContext;
    private static AppContextHolder instance = new AppContextHolder();

    private AppContextHolder() {
    }

    public static AppContextHolder getInstanse() {
        return instance;
    }

    public void init(String[] contextResources) {
        this.logger.info("Application context initialize by:{}", (Object[])contextResources);
        this.applicationContext = new ClassPathXmlApplicationContext(contextResources);
    }

    public ConfigurableApplicationContext getAppContext() {
        if (this.applicationContext == null) {
            this.logger.error("Application context not initialized yet!");
            throw new RuntimeException("Application context not initialized yet!");
        }
        return this.applicationContext;
    }

    public void close() {
        if (this.applicationContext != null) {
            this.logger.info("Application context closed!");
            this.applicationContext.close();
        }
    }
}

