/*
 * Decompiled with CFR 0.152.
 */
package com.netfinworks.rest.filter;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RawHttpHolder {
    private static ThreadLocal<HttpServletRequest> requestTl = new ThreadLocal();
    private static ThreadLocal<HttpServletResponse> responseTl = new ThreadLocal();

    static void setHttpServletRequest(HttpServletRequest req) {
        requestTl.set(req);
    }

    static void setHttpServletResponse(HttpServletResponse resp) {
        responseTl.set(resp);
    }

    static void clear() {
        requestTl.remove();
        responseTl.remove();
    }

    public static void setCookie(Cookie cookie) {
        HttpServletResponse response = responseTl.get();
        if (response != null) {
            response.addCookie(cookie);
        }
    }

    public static Cookie[] getCookies() {
        HttpServletRequest request = requestTl.get();
        if (request != null) {
            return request.getCookies();
        }
        return null;
    }

    public static Cookie getCookie(String key) {
        Cookie[] cookies = RawHttpHolder.getCookies();
        Cookie ret = null;
        if (cookies != null && cookies.length > 0) {
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if (key.equals(cookie.getName())) {
                    ret = cookie;
                    break;
                }
                ++n2;
            }
        }
        return ret;
    }

    public static HttpServletRequest getServletRequest() {
        return requestTl.get();
    }
}

