/*
 * Decompiled with CFR 0.152.
 */
package com.netfinworks.rest.filter;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import com.netfinworks.rest.annotation.WebResource;
import com.netfinworks.rest.annotation.WebResourceAnnotationData;
import com.netfinworks.rest.filter.AppContextHolder;
import com.netfinworks.rest.filter.RawHttpHolder;
import com.netfinworks.rest.filter.Request;
import com.netfinworks.rest.filter.Response;
import com.netfinworks.rest.server.DefaultRestServer;
import com.netfinworks.rest.server.IRestServer;
import com.netfinworks.rest.util.AnnotationUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.StringUtils;

public class RestFilter
implements Filter {
    private Logger logger = null;
    private static final String defaultConfigLocation = "classpath*:META-INF/rest/restApplicationContext.xml";
    private static final String configLocationSplitter = "[,]";
    private static final String logbackConfiguration = "logbackConfiguration";
    private static final String serverInfoParamName = "serverInfo";
    private static final String startDelayParamName = "startDelay";
    private IRestServer restServer;
    private static String serverInfo;

    public void init(FilterConfig filterConfig) throws ServletException {
        String logbackConf = filterConfig.getInitParameter(logbackConfiguration);
        long startDelay = 0L;
        try {
            String startDelayParam = filterConfig.getInitParameter(startDelayParamName);
            if (startDelayParam != null) {
                startDelay = Long.parseLong(filterConfig.getInitParameter(startDelayParamName));
            }
            System.out.println("start delay" + startDelay + " \u6beb\u79d2");
            Thread.sleep(startDelay);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (logbackConf != null) {
            try {
                this.initLogback(logbackConf);
            }
            catch (JoranException e) {
                throw new ServletException((Throwable)e);
            }
        } else {
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.logger.warn("\u8bf7\u6307\u5b9alogback\u914d\u7f6e\u6587\u4ef6\u8def\u5f84\uff0c\u5426\u5219\u91c7\u7528logback\u9ed8\u8ba4\u7684\u914d\u7f6e\u52a0\u8f7d\u65b9\u5f0f\u3002");
        }
        serverInfo = filterConfig.getInitParameter(serverInfoParamName);
        serverInfo = serverInfo == null || serverInfo.trim().length() == 0 ? "netfinworks-Rest-Server" : serverInfo;
        this.logger.info("Starting {} ...", (Object)serverInfo);
        this.initApplicationContext(filterConfig.getInitParameter("configLocations"));
        this.restServer = this.createRestServer(filterConfig);
        if (this.restServer instanceof ApplicationContextAware) {
            ((ApplicationContextAware)this.restServer).setApplicationContext((ApplicationContext)AppContextHolder.getInstanse().getAppContext());
        }
        this.registerWebResource();
        this.restServer.init();
        this.logger.info("{} started.", (Object)serverInfo);
    }

    private void initLogback(String logbackConfigFile) throws JoranException {
        File file = new File(logbackConfigFile);
        if (!file.exists() || file.isDirectory()) {
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.logger.error("logback\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728:" + logbackConfigFile);
        } else {
            JoranConfigurator configurator = new JoranConfigurator();
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            loggerContext.reset();
            configurator.setContext((Context)loggerContext);
            configurator.doConfigure(file);
            StatusPrinter.print((Context)loggerContext);
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.logger.info("logback\u914d\u7f6e\u6587\u4ef6\u6307\u5b9a\u4e3a\uff1a{}", (Object[])new String[]{logbackConfigFile});
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            RawHttpHolder.setHttpServletRequest((HttpServletRequest)request);
            RawHttpHolder.setHttpServletResponse((HttpServletResponse)response);
            Request restRequest = this.buildRestRequest((HttpServletRequest)request);
            Response restResponse = this.restServer.serve(restRequest);
            restResponse.addHeader("server", serverInfo);
            this.sendResponse((HttpServletResponse)response, restResponse);
        }
        finally {
            RawHttpHolder.clear();
        }
    }

    private void sendResponse(HttpServletResponse response, Response restResponse) throws IOException {
        if (restResponse != null) {
            response.setStatus(restResponse.getStatus().value());
            String[] stringArray = restResponse.getHeaderNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                response.addHeader(name, restResponse.getHeader(name));
                ++n2;
            }
            InputStream in = restResponse.getInputStream();
            try {
                if (in != null) {
                    IOUtils.copy((InputStream)in, (OutputStream)response.getOutputStream());
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly((OutputStream)response.getOutputStream());
            }
        }
    }

    private Request buildRestRequest(HttpServletRequest request) {
        Request restRequest = new Request();
        restRequest.setUrl(request.getRequestURI().substring(request.getContextPath().length()));
        restRequest.setQueryString(request.getQueryString());
        Enumeration headers = request.getHeaderNames();
        while (headers.hasMoreElements()) {
            String name = (String)headers.nextElement();
            String value = request.getHeader(name);
            this.logger.debug("add header: name={},value={}", (Object[])new String[]{name, value});
            restRequest.addHeader(name, value);
        }
        restRequest.setRawRequest(request);
        return restRequest;
    }

    public void destroy() {
        AppContextHolder.getInstanse().close();
        if (this.restServer != null) {
            this.restServer.destroy();
        }
    }

    private void initApplicationContext(String beansDef) throws ServletException {
        String[] contextResources = new String[]{defaultConfigLocation};
        if (beansDef != null && beansDef.trim().length() > 0) {
            String[] locations;
            ArrayList<String> confLocationList = new ArrayList<String>();
            String[] stringArray = locations = beansDef.split(configLocationSplitter);
            int n = locations.length;
            int n2 = 0;
            while (n2 < n) {
                String location = stringArray[n2];
                confLocationList.add(location.trim());
                ++n2;
            }
            contextResources = StringUtils.toStringArray(confLocationList);
        }
        AppContextHolder.getInstanse().init(contextResources);
    }

    private void registerWebResource() {
        Map allWebResBeans = AppContextHolder.getInstanse().getAppContext().getBeansWithAnnotation(WebResource.class);
        for (Object bean : allWebResBeans.values()) {
            WebResourceAnnotationData wrad = AnnotationUtil.getWebResourceAnnotationData(bean);
            if (wrad == null) continue;
            String url = wrad.getUrl();
            this.restServer.registerWebResource(url, wrad.getUrlMatchKind(), bean);
            this.logger.debug("register web resource,url={},bean={}", new Object[]{url, bean});
        }
    }

    private IRestServer createRestServer(FilterConfig filterConfig) {
        return new DefaultRestServer();
    }
}

