/*
 * Decompiled with CFR 0.152.
 */
package com.netfinworks.rest.render;

import com.netfinworks.rest.exception.ResourceException;
import com.netfinworks.rest.filter.Request;
import com.netfinworks.rest.filter.Response;
import com.netfinworks.rest.render.BaseRender;
import com.netfinworks.rest.render.FrameDataProvider;
import com.netfinworks.rest.util.Encoding;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathVelocityFragmentRender
extends BaseRender {
    private static final Logger logger = LoggerFactory.getLogger(ClassPathVelocityFragmentRender.class);
    private Properties velocityProp;
    private static final String indexFile = "/index";
    private FrameDataProvider frameDataProvider;
    private String frameTemplate;
    private String suffix = ".vm";
    private String frameTemplatePrefix = "/META-INF/velocity/frame";
    private String fragmentTemplatePrefix = "/META-INF/velocity/fragment";
    private String fragmentVariableName = "SCREEN_CONTENT";
    private String fragmentDataName = "data";
    private String frameDataName = "frameData";
    private boolean onlyRenderFrame = false;

    public void setOnlyRenderFrame(boolean onlyRenderFrame) {
        this.onlyRenderFrame = onlyRenderFrame;
    }

    public void setVelocityProp(Properties velocityProp) {
        this.velocityProp = velocityProp;
    }

    public void setFrameTemplatePrefix(String frameTemplatePrefix) {
        this.frameTemplatePrefix = frameTemplatePrefix;
    }

    public void setFragmentTemplatePrefix(String fragmentTemplatePrefix) {
        this.fragmentTemplatePrefix = fragmentTemplatePrefix;
    }

    public void setFrameDataProvider(FrameDataProvider frameDataProvider) {
        this.frameDataProvider = frameDataProvider;
    }

    public void setFrameTemplate(String frameTemplate) {
        this.frameTemplate = frameTemplate;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setFragmentVariableName(String fragmentVariableName) {
        this.fragmentVariableName = fragmentVariableName;
    }

    public void setFragmentDataName(String fragmentDataName) {
        this.fragmentDataName = fragmentDataName;
    }

    public void setFrameDataName(String frameDataName) {
        this.frameDataName = frameDataName;
    }

    private VelocityEngine newVelocityEngine() {
        try {
            VelocityEngine ve = new VelocityEngine(this.velocityProp);
            Velocity.init();
            return ve;
        }
        catch (Exception e) {
            logger.error("Velocity \u521d\u59cb\u5316\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public Response render(Object resultObject, Request request) {
        VelocityContext globalCtx = new VelocityContext();
        String frgmntHtml = this.onlyRenderFrame ? null : this.generateFragmentHtml(globalCtx, resultObject, request);
        String frmHtml = this.generateFrameHtml(globalCtx, frgmntHtml, request);
        Response resp = new Response();
        byte[] bytes = Encoding.decode(frmHtml);
        resp.setInputStream(new ByteArrayInputStream(bytes));
        resp.addHeader("content-type", "text/html;charset=utf-8");
        return resp;
    }

    private String generateFrameTempaltePath(Request request) {
        if (this.onlyRenderFrame) {
            return this.generateFragmentTemplatePath(request);
        }
        String frmTemplateName = this.frameTemplate.endsWith(this.suffix) ? this.frameTemplate : String.valueOf(this.frameTemplate) + this.suffix;
        frmTemplateName = String.valueOf(this.frameTemplatePrefix) + frmTemplateName;
        return frmTemplateName;
    }

    private String generateFrameHtml(VelocityContext ctxFrame, String fragmentHtml, Request request) {
        String string;
        Object frmObj;
        if (fragmentHtml != null) {
            ctxFrame.put(this.fragmentVariableName, (Object)fragmentHtml);
        }
        if (this.frameDataProvider != null && (frmObj = this.frameDataProvider.provide()) != null) {
            ctxFrame.put(this.frameDataName, frmObj);
        }
        String frmTemplateName = this.generateFrameTempaltePath(request);
        logger.debug("\u5f85\u6e32\u67d3\u6846\u67b6\u6a21\u677f\u4e3a\uff1a{}", (Object)frmTemplateName);
        StringWriter frmWriter = null;
        try {
            Template template = this.newVelocityEngine().getTemplate(frmTemplateName);
            frmWriter = new StringWriter();
            template.merge((Context)ctxFrame, (Writer)frmWriter);
            String html = frmWriter.getBuffer().toString();
            if (logger.isDebugEnabled()) {
                logger.debug("\u751f\u6210\u6846\u67b6{} HTML: \r\n {}", new Object[]{frmTemplateName, html});
            }
            string = html;
        }
        catch (Exception e) {
            try {
                logger.error("render frame error", (Throwable)e);
                throw new ResourceException("render frame error");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(frmWriter);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)frmWriter);
        return string;
    }

    private String generateFragmentTemplatePath(Request request) {
        String urlTemplate = request.getUrlTemplate();
        String frgmntTemplateName = "/".equals(urlTemplate) ? indexFile : (urlTemplate.endsWith(this.suffix) ? urlTemplate.substring(0, urlTemplate.indexOf(this.suffix)) : urlTemplate);
        frgmntTemplateName = String.valueOf(frgmntTemplateName) + this.suffix;
        frgmntTemplateName = String.valueOf(this.onlyRenderFrame ? this.frameTemplatePrefix : this.fragmentTemplatePrefix) + frgmntTemplateName;
        return frgmntTemplateName;
    }

    private String generateFragmentHtml(VelocityContext ctxFrgmnt, Object resultObject, Request request) {
        String string;
        Object frmObj;
        if (resultObject != null) {
            ctxFrgmnt.put(this.fragmentDataName, resultObject);
        }
        if (this.frameDataProvider != null && (frmObj = this.frameDataProvider.provide()) != null) {
            ctxFrgmnt.put(this.frameDataName, frmObj);
        }
        String frgmntTemplateName = this.generateFragmentTemplatePath(request);
        logger.debug("\u5f85\u6e32\u67d3\u788e\u7247\u6a21\u677f\u4e3a\uff1a{}", (Object)frgmntTemplateName);
        StringWriter frgmntWriter = null;
        try {
            Template template = this.newVelocityEngine().getTemplate(frgmntTemplateName);
            frgmntWriter = new StringWriter();
            template.merge((Context)ctxFrgmnt, (Writer)frgmntWriter);
            Object data = template.getData();
            logger.debug("{}", data);
            String html = frgmntWriter.getBuffer().toString();
            if (logger.isDebugEnabled()) {
                logger.debug("\u751f\u6210\u788e\u7247{} HTML: \r\n {}", new Object[]{frgmntTemplateName, html});
            }
            string = html;
        }
        catch (Exception e) {
            try {
                logger.error("\u6e32\u67d3\u788e\u7247\u51fa\u9519", (Throwable)e);
                throw new ResourceException("render fragment error");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(frgmntWriter);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)frgmntWriter);
        return string;
    }
}

