/*
 * Decompiled with CFR 0.152.
 */
package com.netfinworks.rest.render;

import com.netfinworks.rest.filter.Request;
import com.netfinworks.rest.filter.Response;
import com.netfinworks.rest.render.IRender;
import com.netfinworks.rest.util.Encoding;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class FtlRender
implements IRender {
    private static Logger logger = LoggerFactory.getLogger(FtlRender.class);
    private static Configuration conf = new Configuration();
    private String suffix = ".html";
    private String indexFile = "index";

    static {
        conf.setOutputEncoding("UTF-8");
        conf.setDefaultEncoding("UTF-8");
        conf.setClassForTemplateLoading(FtlRender.class, "/META-INF/html/");
        try {
            ClassPathResource res = new ClassPathResource("/META-INF/prop/freemarker.properties");
            conf.setSettings(res.getInputStream());
        }
        catch (Exception ex) {
            logger.warn("freemarker setting file error!  please check /META-INF/prop/freemarker.properties!");
        }
    }

    public void setIndexFile(String indexFile) {
        this.indexFile = indexFile;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Response render(Object resultObject, Request request) {
        Response response;
        String urlTemplate = request.getUrlTemplate();
        StringWriter writer = null;
        try {
            Template t = conf.getTemplate(urlTemplate.endsWith(this.suffix) ? urlTemplate : String.valueOf("/".equals(urlTemplate) ? this.indexFile : urlTemplate) + this.suffix);
            writer = new StringWriter();
            t.process(resultObject, (Writer)writer);
            String html = writer.getBuffer().toString();
            byte[] bytes = Encoding.decode(html);
            Response resp = new Response();
            resp.setInputStream(new ByteArrayInputStream(bytes));
            resp.addHeader("content-type", "text/html;charset=utf-8");
            response = resp;
        }
        catch (IOException e) {
            try {
                logger.error("can't find template of {}", (Object)urlTemplate);
                throw new RuntimeException(e);
                catch (TemplateException e2) {
                    logger.error("freemarker template parsing error!");
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
        return response;
    }

    @Override
    public Response renderException(Throwable exception, Request request) {
        throw new IllegalAccessError("un implemented method!");
    }
}

