/*
 * Decompiled with CFR 0.152.
 */
package com.netfinworks.rest.render;

import com.netfinworks.rest.filter.Request;
import com.netfinworks.rest.filter.Response;
import com.netfinworks.rest.render.IRender;
import com.netfinworks.rest.util.Encoding;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.ClassPathResource;

public class VelocityRender
implements IRender,
InitializingBean {
    public static final String CONTEXT_KEY = "resultObject";
    private Logger logger = LoggerFactory.getLogger(VelocityRender.class);
    private static final String suffix = ".html";
    private static final String prefix = ".html";
    private static final String indexFile = "index";
    private String propFile = "META-INF/velocity/velocity.properties";
    private Properties properties = null;

    public void afterPropertiesSet() throws Exception {
        this.init();
    }

    private void init() {
        try {
            this.logger.info("VelocityRender init begin.");
            if (this.properties == null) {
                ClassPathResource resource = new ClassPathResource(this.propFile);
                Velocity.init((String)resource.getFile().getAbsolutePath());
            } else {
                String filePath = this.properties.getProperty("file.resource.loader.path");
                if (filePath != null) {
                    ClassPathResource resource = new ClassPathResource(filePath);
                    String filePathToUse = resource.getFile().getAbsolutePath();
                    this.properties.put("file.resource.loader.path", filePathToUse);
                }
                Velocity.init((Properties)this.properties);
            }
            this.logger.info("VelocityRender init end.");
        }
        catch (Exception e) {
            this.logger.error("velocityEngine init error ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public Response render(Object resultObject, Request request) {
        Response response;
        String urlTemplate = request.getUrlTemplate();
        String templateName = "/".equals(urlTemplate) ? indexFile : (urlTemplate.endsWith(".html") ? urlTemplate.substring(0, urlTemplate.indexOf(".html")) : urlTemplate);
        templateName = String.valueOf(templateName) + ".html";
        this.logger.info("render begin.templateName is {}", (Object)templateName);
        StringWriter writer = null;
        try {
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put(CONTEXT_KEY, resultObject);
            Template template = Velocity.getTemplate((String)templateName);
            writer = new StringWriter();
            template.merge((Context)velocityContext, (Writer)writer);
            String html = writer.getBuffer().toString();
            byte[] bytes = Encoding.decode(html);
            Response resp = new Response();
            resp.setInputStream(new ByteArrayInputStream(bytes));
            resp.addHeader("content-type", "text/html;charset=utf-8");
            response = resp;
        }
        catch (Exception e) {
            try {
                this.logger.error("velocityEngine process error ", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
        return response;
    }

    @Override
    public Response renderException(Throwable exception, Request request) {
        throw new IllegalAccessError("un implemented method!");
    }

    public void setPropFile(String propFile) {
        this.propFile = propFile;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

