/*
 * Decompiled with CFR 0.152.
 */
package com.netfinworks.rest.render;

import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class VelocityResourceLoader
extends ResourceLoader {
    private boolean debug = true;
    private static Logger logger = LoggerFactory.getLogger(VelocityResourceLoader.class);

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public long getLastModified(Resource res) {
        return 0L;
    }

    public InputStream getResourceStream(String name) throws ResourceNotFoundException {
        logger.debug("ready to find resource:{}", (Object)name);
        if (name == null || name.length() == 0) {
            throw new ResourceNotFoundException("Need to specify a template name!");
        }
        try {
            ClassPathResource res = new ClassPathResource(name);
            if (this.debug) {
                logger.debug("use file input get resource.");
                return new FileInputStream(res.getFile());
            }
            return res.getInputStream();
        }
        catch (Exception e) {
            logger.error("load resource error", (Throwable)e);
            throw new ResourceNotFoundException(String.valueOf(name) + "not found!");
        }
    }

    public void init(ExtendedProperties prop) {
        this.debug = prop.getBoolean("debug");
        logger.debug("is debug ? {}", (Object)this.debug);
    }

    public boolean isSourceModified(Resource res) {
        return true;
    }
}

