/*
 * Decompiled with CFR 0.152.
 */
package com.netfinworks.rest.render;

import com.netfinworks.rest.filter.Request;
import com.netfinworks.rest.filter.Response;
import com.netfinworks.rest.render.IRender;
import com.thoughtworks.xstream.XStream;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;

public class XmlRender
implements IRender {
    private String encoding = "UTF-8";
    private XStream xstream = new XStream();

    @Override
    public Response render(Object resultObject, Request request) {
        String obj = this.xstream.toXML(resultObject);
        Response resp = new Response();
        try {
            resp.setInputStream(new ByteArrayInputStream(obj.getBytes(this.encoding)));
            resp.addHeader("content-type", "text/xml;charset=utf-8");
            return resp;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public Response renderException(Throwable exception, Request request) {
        throw new IllegalAccessError("un implemented method!");
    }
}

