/*
 * Decompiled with CFR 0.152.
 */
package com.netfinworks.rest.server;

import com.netfinworks.rest.annotation.AcceptAnnotationData;
import com.netfinworks.rest.annotation.BodyAnnotationData;
import com.netfinworks.rest.annotation.CookieParamAnnotationData;
import com.netfinworks.rest.annotation.HeaderParamAnnotationData;
import com.netfinworks.rest.annotation.QueryParamAnnotationData;
import com.netfinworks.rest.annotation.QueryStringAnnotationData;
import com.netfinworks.rest.annotation.UrlParamAnnotationData;
import com.netfinworks.rest.convert.IParamConvert;
import com.netfinworks.rest.convert.MultiPartFormDataParamConvert;
import com.netfinworks.rest.convert.NeverUsedParamConvert;
import com.netfinworks.rest.enums.BodyAs;
import com.netfinworks.rest.filter.Request;
import com.netfinworks.rest.server.DefaultRestServer;
import com.netfinworks.rest.server.ResourceMethodMeta;
import com.netfinworks.rest.util.AnnotationUtil;
import com.netfinworks.rest.util.ConvertUtil;
import com.netfinworks.rest.util.Encoding;
import com.netfinworks.rest.util.UriTemplate;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DefaultHttpVerbInvoker
implements DefaultRestServer.IHttpVerbInvoker,
ApplicationContextAware,
DefaultRestServer.UriTemplateMapAware {
    private ApplicationContext applicationContext;
    private Map<String, UriTemplate> urlTemplateMap;

    @Override
    public Object invoke(Request restRequest, ResourceMethodMeta rmm) throws Throwable {
        Method m = rmm.getMethod();
        Class<?>[] parameterTypes = rmm.getMethod().getParameterTypes();
        return parameterTypes == null || parameterTypes.length == 0 ? m.invoke(rmm.getResource(), new Object[0]) : this.invokeWithParams(restRequest, rmm);
    }

    private Object invokeWithParams(Request restRequest, ResourceMethodMeta rmm) throws Throwable {
        Class<?>[] parameterTypes = rmm.getMethod().getParameterTypes();
        Object[] args = new Object[parameterTypes.length];
        Method m = rmm.getMethod();
        int i = 0;
        while (i < parameterTypes.length) {
            UrlParamAnnotationData urlParamData = AnnotationUtil.getUrlParamAnnotationData(m, i);
            if (urlParamData != null) {
                UriTemplate uriTemplate = this.urlTemplateMap.get(restRequest.getUrlTemplate());
                Map<String, String> uriParams = uriTemplate.match(restRequest.getUrl());
                String rawValue = uriParams.get(urlParamData.getName());
                args[i] = rawValue == null ? null : this.convertUrlParam(rawValue, urlParamData, parameterTypes[i]);
            } else {
                QueryParamAnnotationData queryParamData = AnnotationUtil.getQueryParamAnnotationData(m, i);
                Map<String, String[]> queryParameters = restRequest.getQueryParameters();
                if (queryParamData != null && queryParameters != null) {
                    String[] rawValues = queryParameters.get(queryParamData.getName());
                    args[i] = rawValues == null ? null : this.convertQueryParam(rawValues, queryParamData, parameterTypes[i]);
                } else {
                    QueryStringAnnotationData queryStringData = AnnotationUtil.getQueryStringAnnotationData(m, i);
                    if (queryStringData != null) {
                        String queryString = restRequest.getQueryString();
                        if (queryString == null || queryString.trim().length() == 0) {
                            args[i] = null;
                        } else {
                            queryString = Encoding.decodeUrlEncodedString(queryString, queryStringData.getEncoding());
                            IParamConvert convert = DefaultHttpVerbInvoker.createParamConvertForQueryStringAndBody(rmm, queryStringData.getConverter());
                            args[i] = convert.convert(queryString, parameterTypes[i]);
                        }
                    } else {
                        IParamConvert convert;
                        String convertRef;
                        HeaderParamAnnotationData headerParamAnnotationData = AnnotationUtil.getHeaderParamAnnotationData(m, i);
                        if (headerParamAnnotationData != null) {
                            String headerName = headerParamAnnotationData.getName();
                            Map<String, String> headers = restRequest.getHeaders();
                            String rawValue = headers == null ? null : headers.get(headerName);
                            convertRef = headerParamAnnotationData.getConverterRef();
                            convert = "".equals(convertRef) ? headerParamAnnotationData.getConverter().newInstance() : (IParamConvert)this.applicationContext.getBean(convertRef, IParamConvert.class);
                            args[i] = convert.convert(rawValue, parameterTypes[i]);
                        } else {
                            CookieParamAnnotationData cookieParamAnnotationData = AnnotationUtil.getCookieParamAnnotationData(m, i);
                            if (cookieParamAnnotationData != null) {
                                String cookieName = cookieParamAnnotationData.getName();
                                String rawValue = restRequest.getCookie(cookieName);
                                convertRef = cookieParamAnnotationData.getConverterRef();
                                convert = "".equals(convertRef) ? cookieParamAnnotationData.getConverter().newInstance() : (IParamConvert)this.applicationContext.getBean(convertRef, IParamConvert.class);
                                args[i] = convert.convert(rawValue, parameterTypes[i]);
                            } else {
                                BodyAnnotationData bodyData = AnnotationUtil.getBodyAnnotationData(m, i);
                                if (bodyData != null) {
                                    IParamConvert convert2;
                                    if (BodyAs.String.equals((Object)bodyData.getAs())) {
                                        String bodyString = DefaultHttpVerbInvoker.streamAsString(restRequest.getInputStream(), bodyData.getEncoding());
                                        convert2 = "".equals(bodyData.getConverterRef()) ? null : (IParamConvert)this.applicationContext.getBean(bodyData.getConverterRef(), IParamConvert.class);
                                        convert2 = convert2 == null ? DefaultHttpVerbInvoker.createParamConvertForQueryStringAndBody(rmm, bodyData.getConverter()) : convert2;
                                        args[i] = convert2.convert(bodyString, parameterTypes[i]);
                                    } else if (BodyAs.MultiPartFormData.equals((Object)bodyData.getAs())) {
                                        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)restRequest.getRawRequest());
                                        if (isMultipart) {
                                            convert2 = "".equals(bodyData.getConverterRef()) ? null : (IParamConvert)this.applicationContext.getBean(bodyData.getConverterRef(), IParamConvert.class);
                                            IParamConvert iParamConvert = convert2 = convert2 == null ? DefaultHttpVerbInvoker.createParamConvertForQueryStringAndBody(rmm, bodyData.getConverter()) : convert2;
                                            args[i] = convert2 instanceof MultiPartFormDataParamConvert ? ((MultiPartFormDataParamConvert)convert2).convert(restRequest, parameterTypes[i]) : restRequest.getInputStream();
                                        }
                                    } else {
                                        args[i] = restRequest.getInputStream();
                                    }
                                } else {
                                    args[i] = null;
                                }
                            }
                        }
                    }
                }
            }
            ++i;
        }
        return m.invoke(rmm.getResource(), args);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void setUrlTemplateMap(Map<String, UriTemplate> urlTemplateMap) {
        this.urlTemplateMap = urlTemplateMap;
    }

    private static String streamAsString(InputStream in, String encoding) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)in, (OutputStream)baos);
        return new String(baos.toByteArray(), encoding);
    }

    private Object convertUrlParam(String rawValue, UrlParamAnnotationData urlParamData, Class<?> type) throws Throwable {
        String _rawValue = Encoding.decodeUrlEncodedString(rawValue, urlParamData.getEncoding());
        String converterRef = urlParamData.getConverterRef();
        Class<IParamConvert> converter = urlParamData.getConverter();
        IParamConvert convertInstance = "".equals(converterRef) ? converter.newInstance() : (IParamConvert)this.applicationContext.getBean(converterRef);
        return convertInstance.convert(_rawValue, type);
    }

    private Object convertQueryParam(String[] rawValues, QueryParamAnnotationData queryParamData, Class<?> type) throws Throwable {
        String converterRef = queryParamData.getConverterRef();
        Class<IParamConvert> converter = queryParamData.getConverter();
        IParamConvert convertInstance = "".equals(converterRef) ? converter.newInstance() : (IParamConvert)this.applicationContext.getBean(converterRef);
        return ConvertUtil.convertUrlEncodedStringAsArray(rawValues, queryParamData.getEncoding(), type, convertInstance);
    }

    private static IParamConvert createParamConvertForQueryStringAndBody(ResourceMethodMeta rmm, Class<? extends IParamConvert> secondSelection) throws InstantiationException, IllegalAccessException {
        AcceptAnnotationData aad = rmm.getAcceptAnnotationData();
        Class<? extends IParamConvert> firstSelection = aad == null ? null : aad.getParamConvert();
        return firstSelection == null || firstSelection.equals(NeverUsedParamConvert.class) ? secondSelection.newInstance() : firstSelection.newInstance();
    }
}

