/*
 * Decompiled with CFR 0.152.
 */
package com.netfinworks.rest.server;

import com.netfinworks.rest.annotation.AuditAnnotationData;
import com.netfinworks.rest.annotation.AuthorizeAnnotationData;
import com.netfinworks.rest.annotation.RenderAnnotationData;
import com.netfinworks.rest.audit.AuditResult;
import com.netfinworks.rest.audit.IResourceAudit;
import com.netfinworks.rest.auth.AuthCheckResult;
import com.netfinworks.rest.auth.IAuthCheck;
import com.netfinworks.rest.enums.HttpStatus;
import com.netfinworks.rest.enums.HttpVerb;
import com.netfinworks.rest.exception.ResourceException;
import com.netfinworks.rest.filter.Request;
import com.netfinworks.rest.filter.Response;
import com.netfinworks.rest.render.IRender;
import com.netfinworks.rest.server.DefaultHttpVerbInvoker;
import com.netfinworks.rest.server.IRestServer;
import com.netfinworks.rest.server.ResourceMethodMeta;
import com.netfinworks.rest.util.AnnotationUtil;
import com.netfinworks.rest.util.Encoding;
import com.netfinworks.rest.util.UriTemplate;
import com.netfinworks.rest.util.UrlMatchKind;
import java.io.ByteArrayInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DefaultRestServer
implements IRestServer,
ApplicationContextAware {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ApplicationContext applicationContext;
    private IHttpVerbInvoker httpVerbInvoker;
    private Map<String, Object> noVariableResourceMap = new ConcurrentHashMap<String, Object>();
    private Map<String, Object> withVariableResourceMap = new ConcurrentHashMap<String, Object>();
    private Map<String, UriTemplate> uriTemplateMap = new ConcurrentHashMap<String, UriTemplate>();
    private Map<String, ResourceMethodMeta> resOperateMap = new ConcurrentHashMap<String, ResourceMethodMeta>();

    @Override
    public void registerWebResource(String url, UrlMatchKind matchKind, Object bean) {
        UriTemplate uriTemplate = new UriTemplate(url, matchKind);
        if (uriTemplate.getVariableNames().isEmpty()) {
            this.noVariableResourceMap.put(url, bean);
            this.logger.debug("found no variable resource: {}", (Object)url);
        } else {
            this.withVariableResourceMap.put(url, bean);
            this.uriTemplateMap.put(url, new UriTemplate(url, matchKind));
            this.logger.debug("found with variable resource: {}", (Object)url);
        }
        this.cacheResourceOperation(url, bean);
    }

    @Override
    public void init() {
        this.initHttpVerbInvoker();
    }

    private void initHttpVerbInvoker() {
        this.httpVerbInvoker = new DefaultHttpVerbInvoker();
        if (this.httpVerbInvoker instanceof ApplicationContextAware) {
            ((ApplicationContextAware)this.httpVerbInvoker).setApplicationContext(this.applicationContext);
        }
        if (this.httpVerbInvoker instanceof UriTemplateMapAware) {
            ((UriTemplateMapAware)((Object)this.httpVerbInvoker)).setUrlTemplateMap(this.uriTemplateMap);
        }
    }

    @Override
    public void destroy() {
        this.noVariableResourceMap.clear();
        this.withVariableResourceMap.clear();
        this.uriTemplateMap.clear();
        this.resOperateMap.clear();
    }

    @Override
    public Response serve(Request restRequest) {
        Object resourceObj = this.findResourceAndSetUrlTemplate(restRequest);
        if (resourceObj != null) {
            ResourceMethodMeta rmm = this.resOperateMap.get(this.getCacheKey(restRequest.getUrlTemplate(), restRequest.getHttpVerb()));
            if (rmm == null) {
                this.logger.warn("resource method not found,url = {}, method = {}", new Object[]{restRequest.getUrl(), restRequest.getHttpVerb()});
                return this.buildNotFoundResponse();
            }
            try {
                AuditResult auditResult;
                AuthCheckResult authCheckResult;
                AuthorizeAnnotationData aad = AnnotationUtil.getAuthorizedAnnotationData(rmm);
                if (aad != null && !(authCheckResult = this.checkResourceAuth(restRequest.getHeaders(), aad)).isPassed()) {
                    return authCheckResult.getImmutableResponse();
                }
                AuditAnnotationData auditData = AnnotationUtil.getAuditAnnotationData(rmm);
                if (auditData != null && !(auditResult = this.audit(restRequest, auditData)).isCompliant()) {
                    return auditResult.getImmutableResponse();
                }
                this.logger.debug("call resource {} to deal.", (Object)rmm);
                Object result = this.httpVerbInvoker.invoke(restRequest, rmm);
                this.logger.debug("resource operation result : {}", result);
                IRender render = this.findRender(rmm);
                if (render != null) {
                    return render.render(result, restRequest);
                }
                this.logger.error("no render found for resource operation:{} {}", new Object[]{rmm.getResource(), rmm.getMethod()});
            }
            catch (Throwable e) {
                this.logger.error("resource handling exception!", e);
                IRender exceptionRender = this.findExceptionRender(rmm);
                return this.buildErrorResponse(exceptionRender, restRequest, e);
            }
            return null;
        }
        this.logger.warn("resource not found,url = {}, method = {}", new Object[]{restRequest.getUrl(), restRequest.getHttpVerb()});
        return this.buildNotFoundResponse();
    }

    private AuditResult audit(Request restRequest, AuditAnnotationData aad) throws BeansException, InstantiationException, IllegalAccessException {
        String beanName = aad.getAuditRef();
        Class<? extends IResourceAudit> clz = aad.getAudit();
        IResourceAudit audit = "".equals(beanName) ? clz.newInstance() : (IResourceAudit)this.applicationContext.getBean(beanName);
        return audit.audit(restRequest.getUrl(), restRequest.getUrlTemplate(), restRequest.getHttpVerb(), restRequest.getHeaders());
    }

    private AuthCheckResult checkResourceAuth(Map<String, String> headers, AuthorizeAnnotationData aad) throws Exception {
        String checkRef = aad.getCheckRef();
        if (!"".equals(checkRef) && this.applicationContext.containsBean(checkRef)) {
            IAuthCheck check = (IAuthCheck)this.applicationContext.getBean(checkRef);
            return check.checkAuth(headers);
        }
        Class<? extends IAuthCheck> checkClass = aad.getCheck();
        IAuthCheck check = checkClass.newInstance();
        return check.checkAuth(headers);
    }

    private Response buildErrorResponse(IRender render, Request restRequest, Throwable t) {
        if (render != null) {
            return render.renderException(t instanceof InvocationTargetException ? ((InvocationTargetException)t).getTargetException() : t, restRequest);
        }
        if (t instanceof InvocationTargetException) {
            InvocationTargetException ite = (InvocationTargetException)t;
            this.logger.error("resource exception!", ite.getTargetException());
            Throwable e = ite.getTargetException();
            if (e instanceof ResourceException) {
                return ((ResourceException)e).getExceptionResponse();
            }
        }
        Response response = new Response();
        response.setStatus(HttpStatus.SERVICE_UNAVAILABLE);
        byte[] msgArray = Encoding.decode((t instanceof InvocationTargetException ? ((InvocationTargetException)t).getTargetException() : t).getMessage());
        if (msgArray != null) {
            response.setInputStream(new ByteArrayInputStream(msgArray));
        }
        response.addHeader("content-type", "text/plain;charset=utf-8");
        return response;
    }

    private IRender findRender(ResourceMethodMeta rmm) throws BeansException, InstantiationException, IllegalAccessException {
        RenderAnnotationData rad = AnnotationUtil.getWebResourceRenderAnnotationData(rmm);
        return (IRender)(rad == null ? null : ("".equals(rad.getRenderRef()) ? rad.getRender().newInstance() : this.applicationContext.getBean(rad.getRenderRef())));
    }

    private IRender findExceptionRender(ResourceMethodMeta rmm) {
        RenderAnnotationData rad = AnnotationUtil.getWebResourceRenderAnnotationData(rmm);
        try {
            return (IRender)(rad == null ? null : ("".equals(rad.getExceptionRenderRef()) ? rad.getExceptionRender().newInstance() : this.applicationContext.getBean(rad.getExceptionRenderRef())));
        }
        catch (Exception e) {
            this.logger.error("find exception render error", (Throwable)e);
            return null;
        }
    }

    private Response buildNotFoundResponse() {
        Response noResource = new Response();
        noResource.setStatus(HttpStatus.NOT_FOUND);
        noResource.addHeader("content-type", "text/plain;charset=utf-8");
        return noResource;
    }

    private Object findResourceAndSetUrlTemplate(Request request) {
        String url = request.getUrl();
        if (this.noVariableResourceMap.containsKey(url)) {
            request.setUrlTemplate(url);
            this.logger.debug("found \"{}\" in no variable resources.", (Object)url);
            return this.noVariableResourceMap.get(url);
        }
        Set<String> urls = this.withVariableResourceMap.keySet();
        for (String _url : urls) {
            UriTemplate uriTemplate = this.uriTemplateMap.get(_url);
            if (!uriTemplate.matches(url)) continue;
            request.setUrlTemplate(_url);
            this.logger.debug("found templete \"{}\" by url \"{}\"", (Object)_url, (Object)url);
            return this.withVariableResourceMap.get(_url);
        }
        return null;
    }

    private void cacheResourceOperation(String url, Object resource) {
        HttpVerb[] httpVerbArray = HttpVerb.values();
        int n = httpVerbArray.length;
        int n2 = 0;
        while (n2 < n) {
            HttpVerb verb = httpVerbArray[n2];
            Method m = AnnotationUtil.getHttpVerbMethod(resource.getClass(), verb);
            if (m != null) {
                ResourceMethodMeta methodMeta = this.buildResourceMethodMeta(m, resource);
                if (m != null) {
                    String key = this.getCacheKey(url, verb);
                    this.resOperateMap.put(key, methodMeta);
                    this.logger.debug("cache resource operation method : {} - {}", new Object[]{key, m});
                }
            }
            ++n2;
        }
    }

    private ResourceMethodMeta buildResourceMethodMeta(Method m, Object resource) {
        ResourceMethodMeta methodMeta = new ResourceMethodMeta();
        methodMeta.setResource(resource);
        methodMeta.setMethod(m);
        methodMeta.setAcceptAnnotationData(AnnotationUtil.getMethodAcceptAnnotationData(m));
        return methodMeta;
    }

    private String getCacheKey(String url, HttpVerb verb) {
        return (Object)((Object)verb) + " " + url;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.logger.debug("I'm aware of applicationContext:{}", (Object)applicationContext);
    }

    public static interface IHttpVerbInvoker {
        public Object invoke(Request var1, ResourceMethodMeta var2) throws Throwable;
    }

    public static interface UriTemplateMapAware {
        public void setUrlTemplateMap(Map<String, UriTemplate> var1);
    }
}

