/*
 * Decompiled with CFR 0.152.
 */
package com.netfinworks.rest.util;

import com.netfinworks.rest.annotation.Accept;
import com.netfinworks.rest.annotation.AcceptAnnotationData;
import com.netfinworks.rest.annotation.Audit;
import com.netfinworks.rest.annotation.AuditAnnotationData;
import com.netfinworks.rest.annotation.AuthorizeAnnotationData;
import com.netfinworks.rest.annotation.Authorized;
import com.netfinworks.rest.annotation.Body;
import com.netfinworks.rest.annotation.BodyAnnotationData;
import com.netfinworks.rest.annotation.CookieParam;
import com.netfinworks.rest.annotation.CookieParamAnnotationData;
import com.netfinworks.rest.annotation.HeaderParam;
import com.netfinworks.rest.annotation.HeaderParamAnnotationData;
import com.netfinworks.rest.annotation.QueryParam;
import com.netfinworks.rest.annotation.QueryParamAnnotationData;
import com.netfinworks.rest.annotation.QueryString;
import com.netfinworks.rest.annotation.QueryStringAnnotationData;
import com.netfinworks.rest.annotation.Render;
import com.netfinworks.rest.annotation.RenderAnnotationData;
import com.netfinworks.rest.annotation.UrlParam;
import com.netfinworks.rest.annotation.UrlParamAnnotationData;
import com.netfinworks.rest.annotation.Verb;
import com.netfinworks.rest.annotation.WebResource;
import com.netfinworks.rest.annotation.WebResourceAnnotationData;
import com.netfinworks.rest.enums.BodyAs;
import com.netfinworks.rest.enums.HttpVerb;
import com.netfinworks.rest.server.ResourceMethodMeta;
import com.netfinworks.rest.util.UrlMatchKind;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.annotation.AnnotationUtils;

public final class AnnotationUtil {
    private static Map<String, UrlParamAnnotationData> urlParamAnnotationData = new HashMap<String, UrlParamAnnotationData>();
    private static Map<String, QueryParamAnnotationData> cacheQueryParamAnnotationData = new HashMap<String, QueryParamAnnotationData>();
    private static Map<String, QueryStringAnnotationData> cacheQueryStringAnnotationData = new HashMap<String, QueryStringAnnotationData>();
    private static Map<String, BodyAnnotationData> cacheBodyAnnotationData = new HashMap<String, BodyAnnotationData>();
    private static Map<String, RenderAnnotationData> renderAnnotationDataMap = new HashMap<String, RenderAnnotationData>();
    private static Map<String, AuthorizeAnnotationData> authorizeAnnotationDataCache = new HashMap<String, AuthorizeAnnotationData>();
    private static Map<String, AuditAnnotationData> auditAnnotationDataCache = new HashMap<String, AuditAnnotationData>();
    private static Map<String, HeaderParamAnnotationData> cacheHeaderParamAnnotationData = new HashMap<String, HeaderParamAnnotationData>();
    private static Map<String, CookieParamAnnotationData> cacheCookiewParamAnnotationData = new HashMap<String, CookieParamAnnotationData>();

    public static WebResourceAnnotationData getWebResourceAnnotationData(Object bean) {
        Annotation anno;
        if (bean != null && (anno = AnnotationUtils.getAnnotation(bean.getClass(), WebResource.class)) != null) {
            WebResourceAnnotationData wrad = new WebResourceAnnotationData();
            wrad.setUrl((String)AnnotationUtils.getValue((Annotation)anno, (String)"url"));
            wrad.setUrlMatchKind((UrlMatchKind)((Object)AnnotationUtils.getValue((Annotation)anno, (String)"matchKind")));
            return wrad;
        }
        return null;
    }

    public static Method getHttpVerbMethod(Class<?> cls, HttpVerb verb) {
        Method ret = null;
        if (cls != null) {
            Method[] declaredMethods;
            Method[] methodArray = declaredMethods = cls.getDeclaredMethods();
            int n = declaredMethods.length;
            int n2 = 0;
            while (n2 < n) {
                HttpVerb theVerb;
                Method method = methodArray[n2];
                Annotation anno = AnnotationUtils.findAnnotation((Method)method, Verb.class);
                if (anno != null && (theVerb = (HttpVerb)((Object)AnnotationUtils.getValue((Annotation)anno))).equals((Object)verb)) {
                    ret = method;
                    break;
                }
                ++n2;
            }
            if (ret == null) {
                ret = AnnotationUtil.getHttpVerbMethod(cls.getSuperclass(), verb);
            }
        }
        return ret;
    }

    public static UrlParamAnnotationData getUrlParamAnnotationData(Method m, int i) {
        String key = String.valueOf(m.toGenericString()) + i;
        UrlParamAnnotationData data = urlParamAnnotationData.get(key);
        if (data == null) {
            Annotation[] annotations;
            Annotation[] annotationArray = annotations = m.getParameterAnnotations()[i];
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation anno = annotationArray[n2];
                if (anno instanceof UrlParam) {
                    data = new UrlParamAnnotationData();
                    data.setName((String)AnnotationUtils.getValue((Annotation)anno, (String)"name"));
                    data.setConverter((Class)AnnotationUtils.getValue((Annotation)anno, (String)"converter"));
                    data.setConverterRef((String)AnnotationUtils.getValue((Annotation)anno, (String)"converterRef"));
                    data.setEncoding((String)AnnotationUtils.getValue((Annotation)anno, (String)"encoding"));
                    urlParamAnnotationData.put(key, data);
                }
                ++n2;
            }
        }
        return data;
    }

    public static QueryParamAnnotationData getQueryParamAnnotationData(Method m, int i) {
        String key = String.valueOf(m.toGenericString()) + i;
        QueryParamAnnotationData data = cacheQueryParamAnnotationData.get(key);
        if (data == null) {
            Annotation[] annotations;
            Annotation[] annotationArray = annotations = m.getParameterAnnotations()[i];
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation anno = annotationArray[n2];
                if (anno instanceof QueryParam) {
                    data = new QueryParamAnnotationData();
                    data.setName((String)AnnotationUtils.getValue((Annotation)anno, (String)"name"));
                    data.setConverter((Class)AnnotationUtils.getValue((Annotation)anno, (String)"converter"));
                    data.setConverterRef((String)AnnotationUtils.getValue((Annotation)anno, (String)"converterRef"));
                    data.setEncoding((String)AnnotationUtils.getValue((Annotation)anno, (String)"encoding"));
                    cacheQueryParamAnnotationData.put(key, data);
                }
                ++n2;
            }
        }
        return data;
    }

    public static QueryStringAnnotationData getQueryStringAnnotationData(Method m, int i) {
        String key = String.valueOf(m.toGenericString()) + i;
        QueryStringAnnotationData data = cacheQueryStringAnnotationData.get(key);
        if (data == null) {
            Annotation[] annotations;
            Annotation[] annotationArray = annotations = m.getParameterAnnotations()[i];
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation anno = annotationArray[n2];
                if (anno instanceof QueryString) {
                    data = new QueryStringAnnotationData();
                    data.setEncoding((String)AnnotationUtils.getValue((Annotation)anno, (String)"encoding"));
                    data.setConverter((Class)AnnotationUtils.getValue((Annotation)anno, (String)"converter"));
                    data.setConverterRef((String)AnnotationUtils.getValue((Annotation)anno, (String)"converterRef"));
                    cacheQueryStringAnnotationData.put(key, data);
                }
                ++n2;
            }
        }
        return data;
    }

    public static AcceptAnnotationData getMethodAcceptAnnotationData(Method m) {
        Annotation[] annotations;
        Annotation[] annotationArray = annotations = m.getDeclaredAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation anno = annotationArray[n2];
            if (anno instanceof Accept) {
                AcceptAnnotationData aad = new AcceptAnnotationData();
                aad.setContentType((String)AnnotationUtils.getValue((Annotation)anno, (String)"contentType"));
                aad.setParamConvert((Class)AnnotationUtils.getValue((Annotation)anno, (String)"converter"));
                return aad;
            }
            ++n2;
        }
        return null;
    }

    public static BodyAnnotationData getBodyAnnotationData(Method m, int i) {
        String key = String.valueOf(m.toGenericString()) + i;
        BodyAnnotationData bad = cacheBodyAnnotationData.get(key);
        if (bad == null) {
            Annotation[] annotations;
            Annotation[] annotationArray = annotations = m.getParameterAnnotations()[i];
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation anno = annotationArray[n2];
                if (anno instanceof Body) {
                    bad = new BodyAnnotationData();
                    bad.setAs((BodyAs)((Object)AnnotationUtils.getValue((Annotation)anno, (String)"as")));
                    bad.setEncoding((String)AnnotationUtils.getValue((Annotation)anno, (String)"encoding"));
                    bad.setConverter((Class)AnnotationUtils.getValue((Annotation)anno, (String)"converter"));
                    bad.setConverterRef((String)AnnotationUtils.getValue((Annotation)anno, (String)"converterRef"));
                    cacheBodyAnnotationData.put(key, bad);
                }
                ++n2;
            }
        }
        return bad;
    }

    public static RenderAnnotationData getWebResourceRenderAnnotationData(ResourceMethodMeta rmm) {
        String key = String.valueOf(rmm.getMethod().toGenericString()) + rmm.getResource().getClass() + rmm.getResource().hashCode();
        RenderAnnotationData rad = renderAnnotationDataMap.get(key);
        if (rad == null) {
            Annotation annoMethod = AnnotationUtils.getAnnotation((Method)rmm.getMethod(), Render.class);
            if (annoMethod != null) {
                rad = AnnotationUtil.buildRenderAnnotationData(annoMethod);
                renderAnnotationDataMap.put(key, rad);
                return rad;
            }
            Annotation annoObj = AnnotationUtils.getAnnotation(rmm.getResource().getClass(), Render.class);
            if (annoObj != null) {
                rad = AnnotationUtil.buildRenderAnnotationData(annoObj);
                renderAnnotationDataMap.put(key, rad);
                return rad;
            }
        }
        return rad;
    }

    public static AuthorizeAnnotationData getAuthorizedAnnotationData(ResourceMethodMeta rmm) {
        String key = String.valueOf(rmm.getMethod().toGenericString()) + rmm.getResource().getClass() + rmm.getResource().hashCode();
        AuthorizeAnnotationData aad = authorizeAnnotationDataCache.get(key);
        if (aad == null) {
            Annotation annoMethod = AnnotationUtils.getAnnotation((Method)rmm.getMethod(), Authorized.class);
            if (annoMethod != null) {
                aad = AnnotationUtil.buildAuthorizeAnnotationData(annoMethod);
            } else {
                Annotation annoObj = AnnotationUtils.getAnnotation(rmm.getResource().getClass(), Authorized.class);
                if (annoObj != null) {
                    aad = AnnotationUtil.buildAuthorizeAnnotationData(annoObj);
                }
            }
            authorizeAnnotationDataCache.put(key, aad);
        }
        return aad;
    }

    public static AuditAnnotationData getAuditAnnotationData(ResourceMethodMeta rmm) {
        String key = String.valueOf(rmm.getMethod().toGenericString()) + rmm.getResource().getClass() + rmm.getResource().hashCode();
        AuditAnnotationData aad = auditAnnotationDataCache.get(key);
        if (aad == null) {
            Annotation annoMethod = AnnotationUtils.getAnnotation((Method)rmm.getMethod(), Audit.class);
            if (annoMethod != null) {
                aad = AnnotationUtil.buildAuditAnnotationData(annoMethod);
            } else {
                Annotation annoObj = AnnotationUtils.getAnnotation(rmm.getResource().getClass(), Audit.class);
                if (annoObj != null) {
                    aad = AnnotationUtil.buildAuditAnnotationData(annoObj);
                }
            }
            auditAnnotationDataCache.put(key, aad);
        }
        return aad;
    }

    public static HeaderParamAnnotationData getHeaderParamAnnotationData(Method m, int i) {
        String key = String.valueOf(m.toGenericString()) + i;
        HeaderParamAnnotationData data = cacheHeaderParamAnnotationData.get(key);
        if (data == null) {
            Annotation[] annotations;
            Annotation[] annotationArray = annotations = m.getParameterAnnotations()[i];
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation anno = annotationArray[n2];
                if (anno instanceof HeaderParam) {
                    data = new HeaderParamAnnotationData();
                    data.setName((String)AnnotationUtils.getValue((Annotation)anno, (String)"name"));
                    data.setConverter((Class)AnnotationUtils.getValue((Annotation)anno, (String)"converter"));
                    data.setConverterRef((String)AnnotationUtils.getValue((Annotation)anno, (String)"converterRef"));
                    data.setEncoding((String)AnnotationUtils.getValue((Annotation)anno, (String)"encoding"));
                    cacheHeaderParamAnnotationData.put(key, data);
                }
                ++n2;
            }
        }
        return data;
    }

    public static CookieParamAnnotationData getCookieParamAnnotationData(Method m, int i) {
        String key = String.valueOf(m.toGenericString()) + i;
        CookieParamAnnotationData data = cacheCookiewParamAnnotationData.get(key);
        if (data == null) {
            Annotation[] annotations;
            Annotation[] annotationArray = annotations = m.getParameterAnnotations()[i];
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation anno = annotationArray[n2];
                if (anno instanceof CookieParam) {
                    data = new CookieParamAnnotationData();
                    data.setName((String)AnnotationUtils.getValue((Annotation)anno, (String)"name"));
                    data.setConverter((Class)AnnotationUtils.getValue((Annotation)anno, (String)"converter"));
                    data.setConverterRef((String)AnnotationUtils.getValue((Annotation)anno, (String)"converterRef"));
                    data.setEncoding((String)AnnotationUtils.getValue((Annotation)anno, (String)"encoding"));
                    cacheCookiewParamAnnotationData.put(key, data);
                }
                ++n2;
            }
        }
        return data;
    }

    private static AuditAnnotationData buildAuditAnnotationData(Annotation anno) {
        AuditAnnotationData aad = new AuditAnnotationData();
        aad.setAuditRef((String)AnnotationUtils.getValue((Annotation)anno, (String)"auditRef"));
        aad.setAudit((Class)AnnotationUtils.getValue((Annotation)anno, (String)"audit"));
        return aad;
    }

    private static AuthorizeAnnotationData buildAuthorizeAnnotationData(Annotation anno) {
        AuthorizeAnnotationData aad = new AuthorizeAnnotationData();
        aad.setCheck((Class)AnnotationUtils.getValue((Annotation)anno, (String)"check"));
        aad.setCheckRef((String)AnnotationUtils.getValue((Annotation)anno, (String)"checkRef"));
        return aad;
    }

    private static RenderAnnotationData buildRenderAnnotationData(Annotation anno) {
        RenderAnnotationData rad = new RenderAnnotationData();
        rad.setRender((Class)AnnotationUtils.getValue((Annotation)anno, (String)"render"));
        rad.setRenderRef((String)AnnotationUtils.getValue((Annotation)anno, (String)"renderRef"));
        rad.setExceptionRender((Class)AnnotationUtils.getValue((Annotation)anno, (String)"exceptionRender"));
        rad.setExceptionRenderRef((String)AnnotationUtils.getValue((Annotation)anno, (String)"exceptionRenderRef"));
        return rad;
    }
}

