/*
 * Decompiled with CFR 0.152.
 */
package com.netfinworks.rest.util;

import com.netfinworks.rest.convert.IParamConvert;
import com.netfinworks.rest.util.Encoding;
import java.lang.reflect.Array;

public abstract class ConvertUtil {
    public static Object convertUrlEncodedStringAsArray(String[] rawValues, String encoding, Class<?> type, IParamConvert convert) {
        if (type.isArray()) {
            Object array = Array.newInstance(type.getComponentType(), rawValues.length);
            int i = 0;
            while (i < rawValues.length) {
                String rawValue = rawValues[i];
                rawValue = Encoding.decodeUrlEncodedString(rawValue, encoding);
                Array.set(array, i, convert.convert(rawValue, type.getComponentType()));
                ++i;
            }
            return array;
        }
        return convert.convert(rawValues.length == 0 ? "" : Encoding.decodeUrlEncodedString(rawValues[0], encoding), type);
    }

    public static <T> Object addUrlEncodedStringIfArray(Object oldValues, String rawValue, String encoding, Class<?> type, IParamConvert convert) {
        if (type.isArray()) {
            int length = 0;
            if (oldValues != null) {
                length = Array.getLength(oldValues);
            }
            Object array = Array.newInstance(type.getComponentType(), length + 1);
            if (oldValues != null) {
                System.arraycopy(oldValues, 0, array, 0, length);
            }
            rawValue = Encoding.decodeUrlEncodedString(rawValue, encoding);
            Array.set(array, length, convert.convert(rawValue, type.getComponentType()));
            return array;
        }
        return convert.convert(Encoding.decodeUrlEncodedString(rawValue, encoding), type);
    }
}

