/*
 * Decompiled with CFR 0.152.
 */
package com.netfinworks.rest.util;

import com.netfinworks.rest.util.UrlMatchKind;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;

public class UriTemplate {
    private static final Pattern NAMES_PATTERN = Pattern.compile("\\{([^/]+?)\\}");
    private static final String VALUE_GREEDY_REGEX = "(.*)";
    private static final String VALUE_CAUTIOUS_REGEX = "([^/]*)";
    private final List<String> variableNames;
    private final Pattern matchPattern;
    private final String uriTemplate;

    public UriTemplate(String uriTemplate, UrlMatchKind matchKind) {
        Parser parser = new Parser(uriTemplate, matchKind);
        this.uriTemplate = uriTemplate;
        this.variableNames = parser.getVariableNames();
        this.matchPattern = parser.getMatchPattern();
    }

    public List<String> getVariableNames() {
        return this.variableNames;
    }

    public Pattern getMatchPattern() {
        return this.matchPattern;
    }

    public boolean matches(String uri) {
        if (uri == null) {
            return false;
        }
        Matcher matcher = this.matchPattern.matcher(uri);
        return matcher.matches();
    }

    public Map<String, String> match(String uri) {
        Assert.notNull((Object)uri, (String)"'uri' must not be null");
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(this.variableNames.size());
        Matcher matcher = this.matchPattern.matcher(uri);
        if (matcher.find()) {
            int i = 1;
            while (i <= matcher.groupCount()) {
                String name = this.variableNames.get(i - 1);
                String value = matcher.group(i);
                result.put(name, value);
                ++i;
            }
        }
        return result;
    }

    public String toString() {
        return this.uriTemplate;
    }

    private static class Parser {
        private final List<String> variableNames = new LinkedList<String>();
        private final StringBuilder patternBuilder = new StringBuilder();

        private Parser(String uriTemplate, UrlMatchKind matchKind) {
            Assert.hasText((String)uriTemplate, (String)"'uriTemplate' must not be null");
            Matcher m = NAMES_PATTERN.matcher(uriTemplate);
            int end = 0;
            while (m.find()) {
                this.patternBuilder.append(this.quote(uriTemplate, end, m.start()));
                this.patternBuilder.append(this.getValueRegex(matchKind));
                this.variableNames.add(m.group(1));
                end = m.end();
            }
            this.patternBuilder.append(this.quote(uriTemplate, end, uriTemplate.length()));
            int lastIdx = this.patternBuilder.length() - 1;
            if (lastIdx >= 0 && this.patternBuilder.charAt(lastIdx) == '/') {
                this.patternBuilder.deleteCharAt(lastIdx);
            }
        }

        private Object getValueRegex(UrlMatchKind matchKind) {
            switch (matchKind) {
                case Cautious: {
                    return UriTemplate.VALUE_CAUTIOUS_REGEX;
                }
            }
            return UriTemplate.VALUE_GREEDY_REGEX;
        }

        private String quote(String fullPath, int start, int end) {
            if (start == end) {
                return "";
            }
            return Pattern.quote(fullPath.substring(start, end));
        }

        private List<String> getVariableNames() {
            return Collections.unmodifiableList(this.variableNames);
        }

        private Pattern getMatchPattern() {
            return Pattern.compile(this.patternBuilder.toString());
        }
    }
}

