/*
 * Decompiled with CFR 0.152.
 */
package com.netfinworks.restx.render;

import com.netfinworks.rest.filter.Request;
import com.netfinworks.rest.filter.Response;
import com.netfinworks.rest.render.IRender;
import com.netfinworks.rest.util.HttpHeaderName;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class FileDownloadRender
implements IRender {
    @Override
    public Response render(Object resultObject, Request request) {
        Response resp = new Response();
        if (resultObject == null) {
            return resp;
        }
        try {
            String userAgent;
            FileWrapper fileWrapper = (FileWrapper)resultObject;
            if (fileWrapper.getFileSize() > 0L) {
                resp.addHeader((String)HttpHeaderName.ContentLength, String.valueOf(fileWrapper.getFileSize()));
            }
            boolean isIe = (userAgent = request.getHeaders().get("user-agent")) == null ? false : userAgent.indexOf("MSIE") >= 0;
            String fileName = fileWrapper.getFileName();
            if (fileName != null) {
                fileName = new String(fileName.getBytes(isIe ? "GBK" : "UTF-8"), "iso8859_1");
                resp.addHeader("content-disposition", "attachment;filename=" + fileName);
            }
            String contentType = fileWrapper.getContentType() == null ? "application/octet-stream" : fileWrapper.getContentType();
            resp.addHeader("content-type", contentType);
            resp.setInputStream(fileWrapper.getFileContent());
            return resp;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Response renderException(Throwable exception, Request request) {
        throw new RuntimeException(exception);
    }

    public static class FileWrapper {
        private String fileName;
        private InputStream fileContent;
        private long fileSize;
        private String contentType;

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public void setFileSize(long fileSize) {
            this.fileSize = fileSize;
        }

        public InputStream getFileContent() {
            return this.fileContent;
        }

        public void setFileContent(InputStream fileContent) {
            this.fileContent = fileContent;
        }
    }
}

