/*
 * Decompiled with CFR 0.152.
 */
package com.netfinworks.restx.render;

import com.netfinworks.rest.filter.Request;
import com.netfinworks.rest.filter.Response;
import com.netfinworks.rest.render.FrameDataProvider;
import com.netfinworks.rest.render.IRender;
import com.netfinworks.rest.util.Encoding;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class FtlFragmentRender
implements IRender {
    private static Logger logger = LoggerFactory.getLogger(FtlFragmentRender.class);
    private static Configuration conf = new Configuration();
    private String suffix = ".html";
    private String indexFile = "index";
    private String frame;
    private String frameDataName = "frameData";
    private String fragmentVarName = "fragment";
    private String fragmentDataName = "fragmentData";
    private FrameDataProvider frameDataProvider;

    static {
        conf.setOutputEncoding("UTF-8");
        conf.setDefaultEncoding("UTF-8");
        conf.setClassForTemplateLoading(FtlFragmentRender.class, "/META-INF/html/");
        try {
            ClassPathResource res = new ClassPathResource("/META-INF/prop/freemarker.properties");
            conf.setSettings(res.getInputStream());
        }
        catch (Exception ex) {
            logger.warn("freemarker setting file error!  please check /META-INF/prop/freemarker.properties!");
        }
    }

    public String getFrame() {
        return this.frame;
    }

    public String getFragmentVarName() {
        return this.fragmentVarName;
    }

    public String getFrameDataName() {
        return this.frameDataName;
    }

    public String getFragmentDataName() {
        return this.fragmentDataName;
    }

    public FrameDataProvider getFrameDataProvider() {
        return this.frameDataProvider;
    }

    public void setFrameDataProvider(FrameDataProvider frameDataProvider) {
        this.frameDataProvider = frameDataProvider;
    }

    public void setFragmentDataName(String fragmentDataName) {
        this.fragmentDataName = fragmentDataName;
    }

    public void setFrameDataName(String frameDataName) {
        this.frameDataName = frameDataName;
    }

    public void setFragmentVarName(String fragmentVarName) {
        this.fragmentVarName = fragmentVarName;
    }

    public void setIndexFile(String indexFile) {
        this.indexFile = indexFile;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setFrame(String frame) {
        this.frame = frame;
    }

    @Override
    public Response render(Object resultObject, Request request) {
        HashMap<String, Object> rootObj = new HashMap<String, Object>(3);
        rootObj.put("enums", BeansWrapper.getDefaultInstance().getEnumModels());
        rootObj.put("static", BeansWrapper.getDefaultInstance().getStaticModels());
        Object frameDataObj = this.frameDataProvider.provide();
        rootObj.put(this.frameDataName, frameDataObj);
        rootObj.put(this.fragmentDataName, this.generateResultObject(resultObject, request));
        String fragmentHtml = this.renderFragment(rootObj, this.generateTemplate(resultObject, request));
        rootObj.put(this.fragmentVarName, fragmentHtml);
        String html = this.renderFrame(rootObj, this.frame);
        rootObj.clear();
        byte[] bytes = Encoding.decode(html);
        Response resp = new Response();
        resp.setInputStream(new ByteArrayInputStream(bytes));
        resp.addHeader("content-type", "text/html;charset=utf-8");
        return resp;
    }

    protected Object generateResultObject(Object resultObject, Request request) {
        return resultObject;
    }

    protected String generateTemplate(Object resultObject, Request request) {
        String urlTemplate = request.getUrlTemplate();
        String fragmentTemplate = urlTemplate.endsWith(this.suffix) ? urlTemplate : String.valueOf("/".equals(urlTemplate) ? this.indexFile : urlTemplate) + this.suffix;
        return fragmentTemplate;
    }

    protected String renderFrame(Map<String, Object> data, String frameTemplate) {
        StringWriter writer = new StringWriter();
        try {
            String html;
            Template t = conf.getTemplate(this.frame, "UTF-8");
            t.process(data, (Writer)writer);
            String string = html = writer.getBuffer().toString();
            return string;
        }
        catch (IOException e) {
            logger.error("can't find template of {}", (Object)this.frame);
            throw new RuntimeException(e);
        }
        catch (TemplateException e) {
            logger.error("freemarker template parsing error!");
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    protected String renderFragment(Object resultObject, String fragmentTemplate) {
        StringWriter writer = new StringWriter();
        try {
            String html;
            Template t = conf.getTemplate(fragmentTemplate, "UTF-8");
            t.process(resultObject, (Writer)writer);
            String string = html = writer.getBuffer().toString();
            return string;
        }
        catch (TemplateException e) {
            logger.error("template[{}] parse exception : {}", new Object[]{fragmentTemplate, e.getMessage()});
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            logger.error("freemarker template parsing error!");
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    @Override
    public Response renderException(Throwable exception, Request request) {
        throw new IllegalAccessError("un implemented method!");
    }
}

