/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.google.gson.GsonBuilder;
import com.paypal.api.payments.Address;
import com.paypal.api.payments.CreditCardHistory;
import com.paypal.api.payments.Links;
import com.paypal.api.payments.Patch;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.HttpMethod;
import com.paypal.base.rest.PayPalRESTException;
import com.paypal.base.rest.PayPalResource;
import com.paypal.base.rest.RESTUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreditCard
extends PayPalResource {
    private String id;
    private String number;
    private String type;
    private int expireMonth;
    private int expireYear;
    private String cvv2;
    private String firstName;
    private String lastName;
    private Address billingAddress;
    private String externalCustomerId;
    private String state;
    private String validUntil;
    private List<Links> links;
    private String payerId;

    public CreditCard() {
    }

    public int getCvv2() {
        if (this.cvv2 == null) {
            return -1;
        }
        return Integer.valueOf(this.cvv2);
    }

    public CreditCard setCvv2(Integer cvv2) {
        this.cvv2 = cvv2.toString();
        return this;
    }

    public CreditCard setCvv2(String cvv2) {
        this.cvv2 = cvv2;
        return this;
    }

    public String getCvv2String() {
        return this.cvv2;
    }

    public CreditCard(String number, String type, int expireMonth, int expireYear) {
        this.number = number;
        this.type = type;
        this.expireMonth = expireMonth;
        this.expireYear = expireYear;
    }

    public CreditCard create(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.create(apiContext);
    }

    public CreditCard create(APIContext apiContext) throws PayPalRESTException {
        String resourcePath = "v1/vault/credit-cards";
        String payLoad = this.toJSON();
        return CreditCard.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, CreditCard.class);
    }

    public static CreditCard get(String accessToken, String creditCardId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return CreditCard.get(apiContext, creditCardId);
    }

    public static CreditCard get(APIContext apiContext, String creditCardId) throws PayPalRESTException {
        if (creditCardId == null) {
            throw new IllegalArgumentException("creditCardId cannot be null");
        }
        Object[] parameters = new Object[]{creditCardId};
        String pattern = "v1/vault/credit-cards/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return CreditCard.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, CreditCard.class);
    }

    public void delete(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        this.delete(apiContext);
    }

    public void delete(APIContext apiContext) throws PayPalRESTException {
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        apiContext.setRequestId(null);
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/vault/credit-cards/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        CreditCard.configureAndExecute(apiContext, HttpMethod.DELETE, resourcePath, payLoad, null);
        apiContext.setRequestId(null);
    }

    public CreditCard update(String accessToken, List<Patch> patchRequest) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.update(apiContext, patchRequest);
    }

    public CreditCard update(APIContext apiContext, List<Patch> patchRequest) throws PayPalRESTException {
        if (patchRequest == null) {
            throw new IllegalArgumentException("patchRequest cannot be null");
        }
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/vault/credit-cards/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = new GsonBuilder().create().toJson(patchRequest);
        return CreditCard.configureAndExecute(apiContext, HttpMethod.PATCH, resourcePath, payLoad, CreditCard.class);
    }

    public static CreditCardHistory list(String accessToken, Map<String, String> containerMap) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return CreditCard.list(apiContext, containerMap);
    }

    public static CreditCardHistory list(APIContext apiContext, Map<String, String> containerMap) throws PayPalRESTException {
        if (containerMap == null) {
            throw new IllegalArgumentException("containerMap cannot be null");
        }
        apiContext.setRequestId(null);
        Object[] parameters = new Object[]{containerMap};
        String pattern = "v1/vault/credit-cards?merchant_id={0}&external_card_id={1}&external_customer_id={2}&start_time={3}&end_time={4}&page={5}&page_size={6}&sort_order={7}&sort_by={8}&total_required={9}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        CreditCardHistory creditCardHistory = CreditCard.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, CreditCardHistory.class);
        apiContext.setRequestId(null);
        return creditCardHistory;
    }

    public static CreditCardHistory list(APIContext apiContext) throws PayPalRESTException {
        HashMap<String, String> containerMap = new HashMap<String, String>();
        CreditCardHistory creditCardHistory = CreditCard.list(apiContext, containerMap);
        return creditCardHistory;
    }

    public static CreditCardHistory list(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("merchant_id", "");
        parameters.put("external_card_id", "");
        parameters.put("external_customer_id", "");
        parameters.put("start_time", "");
        parameters.put("end_time", "");
        parameters.put("page", "1");
        parameters.put("page_size", "10");
        parameters.put("sort_order", "asc");
        parameters.put("sort_by", "create_time");
        parameters.put("total_required", "true");
        return CreditCard.list(apiContext, parameters);
    }

    public String getId() {
        return this.id;
    }

    public String getNumber() {
        return this.number;
    }

    public String getType() {
        return this.type;
    }

    public int getExpireMonth() {
        return this.expireMonth;
    }

    public int getExpireYear() {
        return this.expireYear;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public Address getBillingAddress() {
        return this.billingAddress;
    }

    public String getExternalCustomerId() {
        return this.externalCustomerId;
    }

    public String getState() {
        return this.state;
    }

    public String getValidUntil() {
        return this.validUntil;
    }

    public List<Links> getLinks() {
        return this.links;
    }

    public String getPayerId() {
        return this.payerId;
    }

    public CreditCard setId(String id) {
        this.id = id;
        return this;
    }

    public CreditCard setNumber(String number) {
        this.number = number;
        return this;
    }

    public CreditCard setType(String type) {
        this.type = type;
        return this;
    }

    public CreditCard setExpireMonth(int expireMonth) {
        this.expireMonth = expireMonth;
        return this;
    }

    public CreditCard setExpireYear(int expireYear) {
        this.expireYear = expireYear;
        return this;
    }

    public CreditCard setFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public CreditCard setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public CreditCard setBillingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
        return this;
    }

    public CreditCard setExternalCustomerId(String externalCustomerId) {
        this.externalCustomerId = externalCustomerId;
        return this;
    }

    public CreditCard setState(String state) {
        this.state = state;
        return this;
    }

    public CreditCard setValidUntil(String validUntil) {
        this.validUntil = validUntil;
        return this;
    }

    public CreditCard setLinks(List<Links> links) {
        this.links = links;
        return this;
    }

    public CreditCard setPayerId(String payerId) {
        this.payerId = payerId;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreditCard)) {
            return false;
        }
        CreditCard other = (CreditCard)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$number = this.getNumber();
        String other$number = other.getNumber();
        if (this$number == null ? other$number != null : !this$number.equals(other$number)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        if (this.getExpireMonth() != other.getExpireMonth()) {
            return false;
        }
        if (this.getExpireYear() != other.getExpireYear()) {
            return false;
        }
        if (this.getCvv2() != other.getCvv2()) {
            return false;
        }
        String this$firstName = this.getFirstName();
        String other$firstName = other.getFirstName();
        if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
            return false;
        }
        String this$lastName = this.getLastName();
        String other$lastName = other.getLastName();
        if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
            return false;
        }
        Address this$billingAddress = this.getBillingAddress();
        Address other$billingAddress = other.getBillingAddress();
        if (this$billingAddress == null ? other$billingAddress != null : !((Object)this$billingAddress).equals(other$billingAddress)) {
            return false;
        }
        String this$externalCustomerId = this.getExternalCustomerId();
        String other$externalCustomerId = other.getExternalCustomerId();
        if (this$externalCustomerId == null ? other$externalCustomerId != null : !this$externalCustomerId.equals(other$externalCustomerId)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        String this$validUntil = this.getValidUntil();
        String other$validUntil = other.getValidUntil();
        if (this$validUntil == null ? other$validUntil != null : !this$validUntil.equals(other$validUntil)) {
            return false;
        }
        List<Links> this$links = this.getLinks();
        List<Links> other$links = other.getLinks();
        if (this$links == null ? other$links != null : !((Object)this$links).equals(other$links)) {
            return false;
        }
        String this$payerId = this.getPayerId();
        String other$payerId = other.getPayerId();
        return !(this$payerId == null ? other$payerId != null : !this$payerId.equals(other$payerId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CreditCard;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $number = this.getNumber();
        result = result * 59 + ($number == null ? 43 : $number.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        result = result * 59 + this.getExpireMonth();
        result = result * 59 + this.getExpireYear();
        result = result * 59 + this.getCvv2();
        String $firstName = this.getFirstName();
        result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
        String $lastName = this.getLastName();
        result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
        Address $billingAddress = this.getBillingAddress();
        result = result * 59 + ($billingAddress == null ? 43 : ((Object)$billingAddress).hashCode());
        String $externalCustomerId = this.getExternalCustomerId();
        result = result * 59 + ($externalCustomerId == null ? 43 : $externalCustomerId.hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        String $validUntil = this.getValidUntil();
        result = result * 59 + ($validUntil == null ? 43 : $validUntil.hashCode());
        List<Links> $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        String $payerId = this.getPayerId();
        result = result * 59 + ($payerId == null ? 43 : $payerId.hashCode());
        return result;
    }
}

