/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.reactorgrpc;

import java.time.Duration;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class GrpcRetry {
    private GrpcRetry() {
    }

    public static final class ManyToOne {
        private ManyToOne() {
        }

        public static <I, O> Function<? super Flux<I>, Mono<O>> retryWhen(Function<Flux<I>, Mono<O>> operation, Function<Flux<Throwable>, ? extends Publisher<?>> whenFactory) {
            return request -> Mono.defer(() -> (Mono)operation.apply((Flux)request)).retryWhen(whenFactory);
        }

        public static <I, O> Function<? super Flux<I>, Mono<O>> retryAfter(Function<Flux<I>, Mono<O>> operation, Duration delay) {
            return ManyToOne.retryWhen(operation, errors -> errors.delayElements(delay));
        }

        public static <I, O> Function<? super Flux<I>, Mono<O>> retryImmediately(Function<Flux<I>, Mono<O>> operation) {
            return ManyToOne.retryWhen(operation, errors -> errors);
        }
    }

    public static final class ManyToMany {
        private ManyToMany() {
        }

        public static <I, O> Function<? super Flux<I>, ? extends Publisher<O>> retryWhen(Function<Flux<I>, Flux<O>> operation, Function<Flux<Throwable>, ? extends Publisher<?>> whenFactory) {
            return request -> Flux.defer(() -> (Flux)operation.apply((Flux)request)).retryWhen(whenFactory);
        }

        public static <I, O> Function<? super Flux<I>, ? extends Publisher<O>> retryAfter(Function<Flux<I>, Flux<O>> operation, Duration delay) {
            return ManyToMany.retryWhen(operation, errors -> errors.delayElements(delay));
        }

        public static <I, O> Function<? super Flux<I>, ? extends Publisher<O>> retryImmediately(Function<Flux<I>, Flux<O>> operation) {
            return ManyToMany.retryWhen(operation, errors -> errors);
        }
    }

    public static final class OneToMany {
        private OneToMany() {
        }

        public static <I, O> Function<? super Mono<I>, Flux<O>> retryWhen(Function<Mono<I>, Flux<O>> operation, Function<Flux<Throwable>, ? extends Publisher<?>> whenFactory) {
            return request -> Flux.defer(() -> (Flux)operation.apply((Mono)request)).retryWhen(whenFactory);
        }

        public static <I, O> Function<? super Mono<I>, Flux<O>> retryAfter(Function<Mono<I>, Flux<O>> operation, Duration delay) {
            return OneToMany.retryWhen(operation, errors -> errors.delayElements(delay));
        }

        public static <I, O> Function<? super Mono<I>, Flux<O>> retryImmediately(Function<Mono<I>, Flux<O>> operation) {
            return OneToMany.retryWhen(operation, errors -> errors);
        }
    }
}

