/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.google.common.base.MoreObjects;

public class ImageRef {
    private static final String DEFAULT_REGISTRY = "docker.io";
    private final String registry;
    private final String image;
    private final String tag;

    public ImageRef(String image) {
        int lastAt = image.lastIndexOf(64);
        int lastColon = image.lastIndexOf(58);
        if (lastAt >= 0) {
            this.image = image;
            this.tag = null;
        } else if (lastColon < 0) {
            this.image = image;
            this.tag = null;
        } else {
            String tag = image.substring(lastColon + 1);
            if (tag.indexOf(47) < 0) {
                this.image = image.substring(0, lastColon);
                this.tag = tag;
            } else {
                this.image = image;
                this.tag = null;
            }
        }
        String[] parts = image.split("/", 2);
        this.registry = parts.length > 1 && ImageRef.isRegistry(parts[0]) ? parts[0] : DEFAULT_REGISTRY;
    }

    private static boolean isRegistry(String part) {
        return part.contains(".");
    }

    public String getImage() {
        return this.image;
    }

    public String getTag() {
        return this.tag;
    }

    public String getRegistryName() {
        return this.registry;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("registry", (Object)this.registry).add("image", (Object)this.image).add("tag", (Object)this.tag).toString();
    }
}

