/*
 * Decompiled with CFR 0.152.
 */
package com.unionpay.mpi;

import com.unionpay.mpi.CertUtil;
import com.unionpay.mpi.HttpClient;
import com.unionpay.mpi.LogUtil;
import com.unionpay.mpi.MpiConfig;
import com.unionpay.mpi.SecureUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;

public class MpiUtil {
    protected static SimpleDateFormat dateTime14Fmt = new SimpleDateFormat("yyyyMMddHHmmss");
    protected static char[] letter = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    protected static Random random = new Random();

    public static String send(String url, Map<String, String> data, String encoding, int connectionTimeout, int readTimeout) {
        HttpClient hc = new HttpClient(url, connectionTimeout, readTimeout);
        String res = "";
        try {
            int status = hc.send(data, encoding);
            if (200 == status) {
                res = hc.getResult();
            }
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("\u901a\u4fe1\u5f02\u5e38", e);
        }
        return res;
    }

    public static boolean sign(Map<String, String> data, String encoding) {
        LogUtil.writeLog("\u7b7e\u540d\u5904\u7406\u5f00\u59cb.");
        if (MpiUtil.isEmpty(encoding)) {
            encoding = "UTF-8";
        }
        data.put("certId", CertUtil.getSignCertId());
        String stringData = MpiUtil.coverMap2String(data);
        LogUtil.writeLog("\u62a5\u6587\u7b7e\u540d\u4e4b\u524d\u7684\u5b57\u7b26\u4e32(\u4e0d\u542bsignature\u57df)=[" + stringData + "]");
        byte[] byteSign = null;
        String stringSign = null;
        try {
            byte[] signDigest = SecureUtil.sha1X16(stringData, encoding);
            LogUtil.writeLog("SHA1->16\u8fdb\u5236\u8f6c\u6362\u540e\u7684\u6458\u8981=[" + new String(signDigest) + "]");
            byteSign = SecureUtil.base64Encode(SecureUtil.signBySoft(CertUtil.getSignCertPrivateKey(), signDigest));
            stringSign = new String(byteSign);
            LogUtil.writeLog("\u62a5\u6587\u7b7e\u540d\u4e4b\u540e\u7684\u5b57\u7b26\u4e32=[" + stringSign + "]");
            data.put("signature", stringSign);
            LogUtil.writeLog("\u7b7e\u540d\u5904\u7406\u7ed3\u675f.");
            return true;
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("\u7b7e\u540d\u5f02\u5e38", e);
            return false;
        }
    }

    public static String signByCertInfo(Map<String, String> data, String encoding, String certPath, String certPwd) {
        LogUtil.writeLog("\u7b7e\u540d\u5904\u7406\u5f00\u59cb.");
        if (MpiUtil.isEmpty(encoding)) {
            encoding = "UTF-8";
        }
        if (MpiUtil.isEmpty(certPath) || MpiUtil.isEmpty(certPwd)) {
            LogUtil.writeLog("\u4f20\u5165\u53c2\u6570\u4e0d\u5408\u6cd5,\u7b7e\u540d\u5931\u8d25");
            return null;
        }
        String stringData = MpiUtil.coverMap2String(data);
        LogUtil.writeLog("\u62a5\u6587\u7b7e\u540d\u4e4b\u524d\u7684\u5b57\u7b26\u4e32(\u4e0d\u542bsignature\u57df)=[" + stringData + "]");
        byte[] byteSign = null;
        try {
            byte[] signDigest = SecureUtil.sha1X16(stringData, encoding);
            LogUtil.writeLog("SHA1->16\u8fdb\u5236\u8f6c\u6362\u540e\u7684\u6458\u8981=[" + new String(signDigest) + "]");
            byteSign = SecureUtil.base64Encode(SecureUtil.signBySoft(CertUtil.getSignCertPrivateKey(certPath, certPwd), signDigest));
            LogUtil.writeLog("\u62a5\u6587\u7b7e\u540d\u4e4b\u540e\u7684\u5b57\u7b26\u4e32=[" + new String(byteSign) + "]");
            LogUtil.writeLog("\u7b7e\u540d\u5904\u7406\u7ed3\u675f.");
            return new String(byteSign);
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("\u7b7e\u540d\u5f02\u5e38", e);
            return null;
        }
    }

    public static boolean validate(Map<String, String> resData, String encoding) {
        LogUtil.writeLog("\u9a8c\u7b7e\u5904\u7406\u5f00\u59cb.");
        if (MpiUtil.isEmpty(encoding)) {
            encoding = "UTF-8";
        }
        String stringSign = resData.get("signature");
        LogUtil.writeLog("\u8fd4\u56de\u62a5\u6587\u4e2dsignature=[" + stringSign + "]");
        String certId = resData.get("certId");
        LogUtil.writeLog("\u8fd4\u56de\u62a5\u6587\u4e2dcertId=[" + certId + "]");
        String stringData = MpiUtil.coverMap2String(resData);
        LogUtil.writeLog("\u8fd4\u56de\u62a5\u6587\u4e2d(\u4e0d\u542bsignature\u57df)\u7684stringData=[" + stringData + "]");
        try {
            return SecureUtil.validateSignBySoft(CertUtil.getValidateKey(certId), SecureUtil.base64Decode(stringSign.getBytes(encoding)), SecureUtil.sha1X16(stringData, encoding));
        }
        catch (UnsupportedEncodingException e) {
            LogUtil.writeErrorLog(e.getMessage(), e);
        }
        catch (Exception e) {
            LogUtil.writeErrorLog(e.getMessage(), e);
        }
        return false;
    }

    public static String coverMap2String(Map<String, String> data) {
        TreeMap<String, String> tree = new TreeMap<String, String>();
        for (Map.Entry<String, String> en : data.entrySet()) {
            if ("signature".equals(en.getKey().trim())) continue;
            tree.put(en.getKey(), en.getValue());
        }
        Iterator<Map.Entry<String, String>> it = tree.entrySet().iterator();
        StringBuffer sf = new StringBuffer();
        while (it.hasNext()) {
            Map.Entry<String, String> en = it.next();
            sf.append(en.getKey() + "=" + en.getValue() + "&");
        }
        return sf.substring(0, sf.length() - 1);
    }

    private static Map<String, String> convertResultString2Map(String res) {
        String[] resArray;
        HashMap<String, String> map = null;
        if (null != res && !"".equals(res.trim()) && 0 != (resArray = res.split("&")).length) {
            map = new HashMap<String, String>(resArray.length);
            for (String arrayStr : resArray) {
                int index;
                if (null == arrayStr || "".equals(arrayStr.trim()) || -1 == (index = arrayStr.indexOf("="))) continue;
                map.put(arrayStr.substring(0, index), arrayStr.substring(index + 1));
            }
        }
        return map;
    }

    private static void convertResultStringJoinMap(String res, Map<String, String> map) {
        String[] resArray;
        if (null != res && !"".equals(res.trim()) && 0 != (resArray = res.split("&")).length) {
            for (String arrayStr : resArray) {
                int index;
                if (null == arrayStr || "".equals(arrayStr.trim()) || -1 == (index = arrayStr.indexOf("="))) continue;
                map.put(arrayStr.substring(0, index), arrayStr.substring(index + 1));
            }
        }
    }

    public static Map<String, String> coverResultString2Map(String result) {
        return MpiUtil.convertResultStringToMap(result);
    }

    public static Map<String, String> convertResultStringToMap(String result) {
        if (result.contains("{")) {
            String separator = "\\{";
            String[] res = result.split(separator);
            HashMap<String, String> map = new HashMap<String, String>();
            MpiUtil.convertResultStringJoinMap(res[0], map);
            for (int i = 1; i < res.length; ++i) {
                int index = res[i].indexOf("}");
                String specialValue = "{" + res[i].substring(0, index) + "}";
                int indexKey = res[i - 1].lastIndexOf("&");
                String specialKey = res[i - 1].substring(indexKey + 1, res[i - 1].length() - 1);
                map.put(specialKey, specialValue);
                String normalResult = res[i].substring(index + 2, res[i].length());
                MpiUtil.convertResultStringJoinMap(normalResult, map);
            }
            return map;
        }
        return MpiUtil.convertResultString2Map(result);
    }

    public static String encryptPin(String card, String pwd, String encoding) {
        return SecureUtil.EncryptPin(pwd, card, encoding, CertUtil.getEncryptCertPublicKey());
    }

    public static String encryptCvn2(String cvn2, String encoding) {
        return SecureUtil.EncryptData(cvn2, encoding, CertUtil.getEncryptCertPublicKey());
    }

    public static String decryptCvn2(String base64cvn2, String encoding) {
        return SecureUtil.DecryptedData(base64cvn2, encoding, CertUtil.getSignCertPrivateKey());
    }

    public static String encryptAvailable(String date, String encoding) {
        return SecureUtil.EncryptData(date, encoding, CertUtil.getEncryptCertPublicKey());
    }

    public static String decryptAvailable(String base64Date, String encoding) {
        return SecureUtil.DecryptedData(base64Date, encoding, CertUtil.getSignCertPrivateKey());
    }

    public static String encryptPan(String pan, String encoding) {
        return SecureUtil.EncryptData(pan, encoding, CertUtil.getEncryptCertPublicKey());
    }

    public static String decryptPan(String base64Pan, String encoding) {
        return SecureUtil.DecryptedData(base64Pan, encoding, CertUtil.getSignCertPrivateKey());
    }

    public static String generateCustomerInfo(String customerInfo01, String customerInfo02, String customerInfo03, String customerInfo04, String customerInfo05, String customerInfo06, String customerInfo07, String customerInfo08, String pan, String encoding, boolean isEncrypt) {
        if (MpiUtil.isEmpty(encoding)) {
            encoding = "UTF-8";
        }
        StringBuffer sf = new StringBuffer("{");
        sf.append((MpiUtil.isEmpty(customerInfo01) ? "" : customerInfo01) + "|");
        sf.append((MpiUtil.isEmpty(customerInfo02) ? "" : customerInfo02) + "|");
        sf.append((MpiUtil.isEmpty(customerInfo03) ? "" : customerInfo03) + "|");
        sf.append((MpiUtil.isEmpty(customerInfo04) ? "" : customerInfo04) + "|");
        sf.append((MpiUtil.isEmpty(customerInfo05) ? "" : customerInfo05) + "|");
        if (!MpiUtil.isEmpty(customerInfo06)) {
            if (!MpiUtil.isEmpty(pan)) {
                sf.append(MpiUtil.encryptPin(pan.trim(), customerInfo06, encoding) + "|");
            } else {
                sf.append(customerInfo06 + "|");
            }
        } else {
            sf.append((MpiUtil.isEmpty(customerInfo06) ? "" : customerInfo06) + "|");
        }
        if (!MpiUtil.isEmpty(customerInfo07)) {
            if (isEncrypt) {
                sf.append(MpiUtil.encryptCvn2(customerInfo07, encoding) + "|");
            } else {
                sf.append(customerInfo07 + "|");
            }
        } else {
            sf.append((MpiUtil.isEmpty(customerInfo07) ? "" : customerInfo07) + "|");
        }
        if (!MpiUtil.isEmpty(customerInfo08)) {
            if (isEncrypt) {
                sf.append(MpiUtil.encryptAvailable(customerInfo08, encoding));
            } else {
                sf.append(customerInfo08);
            }
        }
        sf.append("}");
        try {
            return new String(SecureUtil.base64Encode(sf.toString().getBytes(encoding)));
        }
        catch (UnsupportedEncodingException e) {
            LogUtil.writeErrorLog(e.getMessage(), e);
            return "";
        }
        catch (IOException e) {
            LogUtil.writeErrorLog(e.getMessage(), e);
            return "";
        }
    }

    public static boolean isEmpty(String s) {
        return null == s || "".equals(s.trim());
    }

    public static String generateTxnTime() {
        return dateTime14Fmt.format(new Date());
    }

    public static String generateOrderId() {
        StringBuilder sb = new StringBuilder();
        int len = random.nextInt(18);
        for (int i = 0; i < len; ++i) {
            sb.append(letter[i]);
        }
        return MpiUtil.generateTxnTime() + sb.toString();
    }

    public static String createAutoSubmitForm(String url, Map<String, String> data) {
        StringBuffer sf = new StringBuffer();
        sf.append("<form id = \"sform\" action=\"" + url + "\" method=\"post\">");
        if (null != data && 0 != data.size()) {
            Set<Map.Entry<String, String>> set = data.entrySet();
            for (Map.Entry<String, String> ey : set) {
                String key = ey.getKey();
                String value = ey.getValue();
                sf.append("<input type=\"hidden\" name=\"" + key + "\" id=\"" + key + "\" value=\"" + value + "\"/>");
            }
        }
        sf.append("</form>");
        sf.append("</body>");
        sf.append("<script type=\"text/javascript\">");
        sf.append("document.getElementById(\"sform\").submit();\n");
        sf.append("</script>");
        return sf.toString();
    }

    public static void main(String[] args) {
        MpiConfig.getConfig().loadPropertiesFromSrc();
        String result = "accNo=9003002811111111&accessType=0&activateStatus=2&bizType=000302&certId=3474813271258769001041842579301293446&encoding=UTF-8&merId=105550149170027&orderId=&payCardType=01&reqReserved=&respCode=66&respMsg=\u94f6\u884c\u5361\u9a8c\u8bc1\u4fe1\u606f\u53ca\u8eab\u4efd\u4fe1\u606f\u6216\u624b\u673a\u53f7\u8f93\u5165\u4e0d\u6b63\u786e\uff0c\u9a8c\u8bc1\u5931\u8d25&signature=Uc8hUbMOc+UID9x7DjJ+qJd6TOwrqCSj4LEyAw2gBoKRDZZWcTJxXs/OkbDnEtV1meolXMDMmfw623IibakijnN6jDm3+obu1GIm1Bq/CBX50Ve1EMY9Do9WXHKmUMmrNFDyNod/UzMSSLFUnPXRlAP/or7dDKJwLU8i23fkmbROj6aIzZt017FcaBgknn5X778OJecKp7/omYSUo28mav6B0CKJzVhv8kk3OFNnqzt4PqZDFtcw0HW8KJ8fd+U7FbMHscY36Q84Ekw/jMAvbKdOIch6lSJWMg3VeVLMdSYkXRbIBcvte0XVe0BPZsM3kdOc3vnmwM8qIuAeiV7Ivw==&temporaryPayInfo={transLimit=30000&expiry=20130710&sumLimit=100000}&txnAmt=&txnSubType=01&txnTime=20130412172116&txnType=79&version=3.0.0";
        Map<String, String> map = MpiUtil.convertResultStringToMap(result);
        if (MpiUtil.validate(map, "UTF-8")) {
            System.out.println("true");
        } else {
            System.out.println("false");
        }
    }
}

