/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.bug.controller;

import com.yqbsoft.laser.html.bug.bean.BugBean;
import com.yqbsoft.laser.html.common.send.PostParamMap;
import com.yqbsoft.laser.html.core.auth.UserSession;
import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.core.util.HtmlUtil;
import com.yqbsoft.laser.html.facade.bm.domian.QaBugDomainBean;
import com.yqbsoft.laser.html.facade.bm.repository.BugRepository;
import com.yqbsoft.laser.html.facade.fm.domian.FileDomain;
import com.yqbsoft.laser.html.facade.fm.repository.FileRepository;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"/web/qa/bug"})
public class BugCon
extends SpringmvcController {
    private static String CODE = "qa.bug.con";
    @Resource
    private BugRepository bugRepository;
    @Resource
    private FileRepository fileRepository;

    protected String getContext() {
        return "bug";
    }

    @RequestMapping(value={"add"})
    public String add(HttpServletRequest request) {
        return String.valueOf(this.getFtlTempPath(request)) + "add";
    }

    @RequestMapping(value={"addSave.json"})
    @ResponseBody
    public HtmlJsonReBean addSave(HttpServletRequest request, QaBugDomainBean qaBugDomainBean) {
        UserSession user = this.getUserSession(request);
        if (qaBugDomainBean == null) {
            this.logger.error(String.valueOf(CODE) + ".addSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bf7\u8f93\u5165\u53c2\u6570");
        }
        String userCode = user.getUserCode();
        String tenantCode = user.getTenantCode();
        qaBugDomainBean.setBugTitle("\u53cd\u9988\u5efa\u8bae");
        qaBugDomainBean.setTenantCode(tenantCode);
        qaBugDomainBean.setUserCode(userCode);
        qaBugDomainBean.setUserName(user.getUserRelname());
        String bugId = this.bugRepository.saveBugRet(qaBugDomainBean);
        if (StringUtils.isBlank((String)bugId)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u63d0\u4ea4\u5931\u8d25");
        }
        String fileSort = "BUG_IMG";
        Integer flexSize = 10;
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        Integer returnInfo = 0;
        if (isMultipart) {
            ArrayList<String> urls = new ArrayList<String>();
            ArrayList<String> fileCodes = new ArrayList<String>();
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            Map multipartFileMap = multipartRequest.getFileMap();
            for (Map.Entry entryFile : multipartFileMap.entrySet()) {
                MultipartFile file = (MultipartFile)entryFile.getValue();
                if (file == null) continue;
                long fileSize = file.getSize() / 1024L / 1024L;
                if (fileSize > (long)flexSize.intValue()) {
                    returnInfo = 2;
                    break;
                }
                FileDomain fileDomain = this.saveFile(file, tenantCode, fileSort, bugId, null);
                if (fileDomain != null) {
                    fileCodes.add(fileDomain.getFileCode());
                    urls.add(fileDomain.getRootPath());
                    continue;
                }
                returnInfo = 3;
            }
        }
        return new HtmlJsonReBean();
    }

    private FileDomain saveFile(MultipartFile file, String tenantCode, String fileSort, String relationCode, String fileRemark) {
        FileDomain fileDomain = this.fileRepository.saveFile(file, tenantCode, fileSort, relationCode, fileRemark);
        if (fileDomain != null) {
            fileDomain.setRootPath(String.valueOf(fileDomain.getFileUrl()) + "/" + fileDomain.getFileCode() + "." + fileDomain.getFileCtype());
            return fileDomain;
        }
        return null;
    }

    @RequestMapping(value={"edit"})
    public String edit(HttpServletRequest request, String bugId, ModelMap modelMap) {
        modelMap.put((Object)"bugReBean", (Object)this.getBug(bugId));
        return String.valueOf(this.getFtlTempPath(request)) + "edit";
    }

    @RequestMapping(value={"editSave.json"})
    @ResponseBody
    public HtmlJsonReBean editSave(HttpServletRequest request, BugBean bugBean) {
        if (bugBean == null) {
            this.logger.error(String.valueOf(CODE) + ".editSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PostParamMap pmap = new PostParamMap("qa.bug.updateBug");
        pmap.putParamToJson("qaBugDomainBean", (Object)bugBean);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    @RequestMapping(value={"delSave.json"})
    @ResponseBody
    public HtmlJsonReBean delSave(HttpServletRequest request, String bugId) {
        if (StringUtils.isBlank((String)bugId)) {
            this.logger.error(String.valueOf(CODE) + ".delSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PostParamMap pmap = new PostParamMap("qa.bug.deleteBug");
        pmap.putParam("bugId", (Object)bugId);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    @RequestMapping(value={"stateSave.json"})
    @ResponseBody
    public HtmlJsonReBean startSave(HttpServletRequest request, String bugId, String dataState, String oldDataState) {
        if (StringUtils.isBlank((String)bugId) || StringUtils.isBlank((String)dataState) || StringUtils.isBlank((String)oldDataState)) {
            this.logger.error(String.valueOf(CODE) + ".startSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PostParamMap pmap = new PostParamMap("qa.bug.updateBugState");
        pmap.putParam("bugId", (Object)Integer.valueOf(bugId));
        pmap.putParam("dataState", (Object)Integer.valueOf(dataState));
        pmap.putParam("oldDataState", (Object)Integer.valueOf(oldDataState));
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    @RequestMapping(value={"view"})
    public String view(HttpServletRequest request, String bugId, ModelMap modelMap) {
        modelMap.put((Object)"bugReBean", (Object)this.getBug(bugId));
        return String.valueOf(this.getFtlTempPath(request)) + "view";
    }

    private String getBug(String bugId) {
        String rs = "{}";
        if (StringUtils.isBlank((String)bugId)) {
            this.logger.error(String.valueOf(CODE) + ".getBug", (Object)"bugId is null");
        } else {
            PostParamMap pmap = new PostParamMap("qa.bug.getBug");
            pmap.putParam("bugId", (Object)bugId);
            rs = this.htmlIBaseService.sendMesReJson(pmap);
        }
        return rs;
    }

    @RequestMapping(value={"list"})
    public String list(HttpServletRequest request) {
        return String.valueOf(this.getFtlTempPath(request)) + "list";
    }

    @RequestMapping(value={"listQuery.json"})
    @ResponseBody
    public Object listQuery(HttpServletRequest request) {
        PostParamMap pmap = new PostParamMap("qa.bug.queryBugPage");
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (param != null) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        pmap.putParamToJson("map", (Object)param);
        return this.htmlIBaseService.senBySupRq(pmap, (Object)new SupQueryResult());
    }

    @RequestMapping(value={"website/experience.json"})
    @ResponseBody
    public void experience(HttpServletRequest request, HttpServletResponse response, String userName, String userPhone, String companyName, String cityName, String appName, String titlePrefix) {
        response.setContentType("text/plain");
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setHeader("Access-Control-Allow-Origin", "*");
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)userName) || StringUtils.isEmpty((String)userPhone)) {
            this.logger.error(String.valueOf(CODE) + ".website/experience.json", (Object)"\u4e91\u9500\u7ba1\u5bb6\u5b98\u7f51\u7533\u8bf7\u4f53\u9a8c\u63d0\u4ea4\uff0c\u7533\u8bf7\u7528\u6237\u4e3a\u7a7a");
            retMap.put("success", false);
            retMap.put("errorCode", "-1");
            retMap.put("msg", "\u8bf7\u8f93\u5165\u59d3\u540d\u548c\u624b\u673a\u53f7");
        } else {
            BugBean bugBean = new BugBean();
            bugBean.setBugTel(userPhone);
            bugBean.setUserName(userName);
            if (!StringUtils.isEmpty((String)cityName)) {
                bugBean.setBugContent(cityName);
            }
            if (!StringUtils.isEmpty((String)companyName)) {
                bugBean.setBugOther(companyName);
            }
            bugBean.setBugTitle(String.valueOf(titlePrefix) + "\u5b98\u7f51\u7528\u6237\u7533\u8bf7\u4f53\u9a8c");
            bugBean.setTenantCode(appName);
            bugBean.setBugDir(0);
            bugBean.setUserCode("-");
            bugBean.setBugSort(3);
            bugBean.setBugType("1");
            PostParamMap pmap = new PostParamMap("qa.bug.saveBug");
            pmap.putParamToJson("qaBugDomainBean", (Object)bugBean);
            this.htmlIBaseService.sendMesReBean(pmap);
            retMap.put("success", true);
            retMap.put("msg", "\u7533\u8bf7\u6210\u529f");
        }
        String jsonpCallback = request.getParameter("jsonpCallback");
        try {
            PrintWriter out = response.getWriter();
            out.println(String.valueOf(jsonpCallback) + "(" + JsonUtil.buildNormalBinder().toJson(retMap) + ")");
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

