<#include '/layout/listHead.ftl' />
<table id="bugList"></table>
<div id="bugList_window" class="easyui-window" closed="true">
</div>
<div id="bugList_tb" style="padding:5px;height:auto">
	<div style="margin-bottom:5px">
		<a href="#" class="easyui-linkbutton" id="btnadd" iconCls="icon-add" plain="true" onclick="javascript:bugList_add('');" >新增</a>
		<a href="#" class="easyui-linkbutton" id="btnedit" iconCls="icon-edit" plain="true" onclick="javascript:bugList_edit('');">修改</a>
		<a href="#" class="easyui-linkbutton" id="btnremove" iconCls="icon-no" plain="true" onclick="javascript:bugList_remove('');">删除</a>
		<a href="#" class="easyui-linkbutton" id="btndisables" iconCls="icon-remove" plain="true" onclick="javascript:bugList_disables('');">停用</a>
		<a href="#" class="easyui-linkbutton" id="btnenable" iconCls="icon-ok" plain="true" onclick="javascript:bugList_enable('');">启用</a>
		<a href="#" class="easyui-linkbutton" id="btnmore" iconCls="icon-more" plain="true" onclick="javascript:bugList_more('');">查看</a>
	</div>
	<form name="bugList_searchform" method="post" action="" id ="bugList_searchform">
	<div>
		日期 : <input class="easyui-datebox" data-options="formatter:common_myformatter,parser:common_myparser" name="startDate" style="width:100px">
		To: <input class="easyui-datebox" data-options="formatter:common_myformatter,parser:common_myparser" name="endDate"  style="width:100px">
		bugCode: <input class="easyui-textbox" name="bugCode"  style="width:100px">
		<a href="#" class="easyui-linkbutton" iconCls="icon-search" onclick="javascript:bugList_reload('');">查询</a>
	</div>
	</form>
</div>
<script type="text/javascript">
var _datagrid='bugList';
var _windowid='bugList_window';

function bugList_disables(dataObject){
	$('#btndisables').linkbutton('disable');
	if(!dataObject){
		dataObject = bugList_getselected();
	}
	if(!dataObject){
		common_alertInfo("请选择数据");
		$('#btndisables').linkbutton('enable');
		return;
	}
	common_alertConfirm("是否要停用？",function(data){
		if(data){
			var data=new Object();
			data.bugId=dataObject.bugId;
			data.dataState=0;
			data.oldDataState=1;
			common_ajax(_sysAppContextPath+'/web/qa/bug/stateSave.json',data,function(data){
		                if(data){
		                common_alertInfo(data.msg);
		                }
		            });
		     $('#btndisables').linkbutton('enable');
		}else{
			$('#btndisables').linkbutton('enable');
			return;
		}
	});
}

function bugList_enable(dataObject){
	$('#btnenable').linkbutton('disable');
	if(!dataObject){
		dataObject = bugList_getselected();
	}
	if(!dataObject){
		common_alertInfo("请选择数据");
		$('#btnenable').linkbutton('enable');
		return;
	}
	common_alertConfirm("是否要启用？",function(data){
		if(data){
			var data=new Object();
			data.bugId=dataObject.bugId;
			data.dataState=1;
			data.oldDataState=0;
			common_ajax(_sysAppContextPath+'/web/qa/bug/stateSave.json',data,function(data){
		                if(data){
		                common_alertInfo(data.msg);
		                }
		            });
		     $('#btnenable').linkbutton('enable');
		}else{
			$('#btnenable').linkbutton('enable');
			return;
		}
	});
}

function bugList_add(dataObject){
	common_window({
		id:_windowid,
		title:'新增',
		href:_sysAppContextPath+'/web/qa/bug/add'
	});
}
function bugList_getselected(){
	return $('#'+_datagrid).datagrid('getSelected');
}
function bugList_edit(dataObject){
	$('#btnedit').linkbutton('disable');
	if(!dataObject){
		dataObject = bugList_getselected();
	}
	if(!dataObject){
		common_alertInfo("请选择数据");
		$('#btnedit').linkbutton('enable');
		return;
	}
	common_window({
		id:_windowid,
		title:'修改',
		iconCls:'icon-edit',
		href:_sysAppContextPath+'/web/qa/bug/edit?bugId='+dataObject.bugId
	});
	$('#btnedit').linkbutton('enable');
}
function bugList_more(dataObject){
	$('#btnmore').linkbutton('disable');
	if(!dataObject){
		dataObject = bugList_getselected();
	}
	if(!dataObject){
		common_alertInfo("请选择数据");
		$('#btnmore').linkbutton('enable');
		return;
	}
	common_window({
		id:_windowid,
		title:'查看',
		iconCls:'icon-more',
		href:_sysAppContextPath+'/web/qa/bug/view?bugId='+dataObject.bugId
	});
	$('#btnmore').linkbutton('enable');
}
function bugList_remove(dataObject){
	$('#btnremove').linkbutton('disable');
	if(!dataObject){
		dataObject = bugList_getselected();
	}
	if(!dataObject){
		common_alertInfo("请选择数据");
		$('#btnremove').linkbutton('enable');
		return;
	}
	common_alertConfirm("是否要删除？",function(data){
		if(data){
			var data=new Object();
			data.bugId=dataObject.bugId;
			common_ajax(_sysAppContextPath+'/web/qa/bug/delSave.json',data,function(data){
		                if(data){
		                common_alertInfo(data.msg);
		                }
		            });
		     $('#btnremove').linkbutton('enable');
		}else{
			$('#btnremove').linkbutton('enable');
			return;
		}
	});
}
function bugList_search(dataObject){
	return common_formtojson('bugList_searchform');
}
function bugList_reload(dataObject){
	$('#'+_datagrid).datagrid('options').queryParams = bugList_search(dataObject);  
	$('#'+_datagrid).datagrid('reload');  
}

common_datagrid({
	id:_datagrid,
	url:'listQuery.json',
	btnaddFun:function(dataObject){
		bugList_add(dataObject);
	},btneditFun:function(dataObject){
		bugList_edit(dataObject);
	},btnremoveFun:function(dataObject){
		bugList_remove(dataObject);
	},btnmoreFun:function(dataObject){
		bugList_more(dataObject);
	},btnsearchFun:function(dataObject){
		bugList_search(dataObject);
	},btnenableFun:function(dataObject){
		bugList_enable(dataObject);
	},btndisablesFun:function(dataObject){
		bugList_disables(dataObject);
	},
	divtoolbar:'#bugList_tb',
	columns:[[
			 {field:'bugTitle',title:'bugTitle',width:20},
			 {field:'bugSort',title:'bugSort',width:20},
			 {field:'bugType',title:'bugType',width:20},
			 {field:'bugDir',title:'bugDir',width:20},
			 {field:'bugTag',title:'bugTag',width:20},
			 {field:'bugTel',title:'bugTel',width:20},
			 {field:'bugQq',title:'bugQq',width:20},
			 {field:'bugEmail',title:'bugEmail',width:20},
			 {field:'bugOther',title:'bugOther',width:20},
			 {field:'userCode',title:'userCode',width:20},
			 {field:'userName',title:'userName',width:20},
			 {field:'bugContent',title:'bugContent',width:20},
			 {field:'bugSortStr',title:'bugSortStr',width:20},
			 {field:'bugTagStr',title:'bugTagStr',width:20},
			 {field:'tenantCode',title:'tenantCode',width:20}
        ]]
})
</script>
<#include '/layout/listFoot.ftl' />

