/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.am.controller;

import com.yqbsoft.laser.html.am.AppManageConstants;
import com.yqbsoft.laser.html.am.bean.AmAppmanage;
import com.yqbsoft.laser.html.am.bean.SmSeclist;
import com.yqbsoft.laser.html.am.bean.UmUserinfo;
import com.yqbsoft.laser.html.common.send.PostParamMap;
import com.yqbsoft.laser.html.common.util.ResourceUtil;
import com.yqbsoft.laser.html.core.auth.UserSession;
import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.facade.fm.domian.FileDomain;
import com.yqbsoft.laser.html.facade.fm.repository.FileRepository;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.html.springmvc.bean.TmTenant;
import com.yqbsoft.laser.service.suppercore.router.AppState;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.RSAUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.InputStream;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/web/am/appmanageConfig"})
public class AppManageConfigCon
extends SpringmvcController {
    @Autowired
    FileRepository fileRepository;

    protected String getContext() {
        return "am";
    }

    @RequestMapping(value={"index"})
    public String index(HttpServletRequest request, ModelMap map) {
        return this.getFtlTempPath(request) + "index";
    }

    @RequestMapping(value={"list"})
    public String listApp(HttpServletRequest request, ModelMap map) {
        UserSession userSession = this.getUserSession(request);
        List<AmAppmanage> applist = this.queryAppList(userSession);
        map.addAttribute("applist", applist);
        return this.getFtlTempPath(request) + "applist";
    }

    @RequestMapping(value={"add"})
    public String addView(HttpServletRequest request, ModelMap map) {
        String appmanageAppkey = request.getParameter("appmanageAppkey");
        AmAppmanage amAppmanage = this.queryApp(appmanageAppkey);
        SmSeclist seclist_test = null;
        SmSeclist seclist_pro = null;
        if (amAppmanage != null) {
            seclist_test = this.querySmSeclist(amAppmanage.getAppmanageIcode(), AppManageConstants.SEC_LIST_UTYPE_TEST);
            seclist_pro = this.querySmSeclist(amAppmanage.getAppmanageIcode(), AppManageConstants.SEC_LIST_UTYPE_PRO);
        }
        map.addAttribute("amAppmanage", (Object)amAppmanage);
        map.addAttribute("seclist_test", (Object)seclist_test);
        map.addAttribute("seclist_pro", (Object)seclist_pro);
        return this.getFtlTempPath(request) + "appadd";
    }

    @RequestMapping(value={"addSave.json"})
    @ResponseBody
    public HtmlJsonReBean addApp(HttpServletRequest request, AmAppmanage appmanage) {
        AmAppmanage amAppmanageold;
        UserSession userSession = this.getUserSession(request);
        UmUserinfo user = this.getUserInfo(userSession.getUserPcode());
        if (user.getDataState() == null || user.getDataState() != 2) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bf7\u5148\u5b9e\u540d\u516c\u53f8\u4fe1\u606f\uff01");
        }
        if (appmanage == null || StringUtils.isBlank((String)appmanage.getAppmanageName()) || StringUtils.isBlank((String)appmanage.getAppmanagePicurl())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        if (StringUtils.isNotBlank((String)appmanage.getAppmanageAppkey()) && (amAppmanageold = this.queryApp(appmanage.getAppmanageAppkey())) != null) {
            amAppmanageold.setAppmanagePicurl(appmanage.getAppmanagePicurl());
            amAppmanageold.setAppmanageName(appmanage.getAppmanageName());
            PostParamMap pmap = new PostParamMap("am.appmanage.updateAppmanage");
            pmap.putParamToJson("amAppmanageDomain", (Object)amAppmanageold);
            this.htmlIBaseService.sendMesReBean(pmap);
            return new HtmlJsonReBean((Object)appmanage.getAppmanageAppkey());
        }
        PostParamMap pmap = new PostParamMap("am.appmanage.generateAppKey");
        String appKey = this.htmlIBaseService.sendMesReJson(pmap);
        if (StringUtils.isBlank((String)appKey)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u83b7\u53d6appKey\u5931\u8d25!");
        }
        appmanage.setAppmanageAppkey(appKey);
        appmanage.setAppmanageIcode(appKey);
        appmanage.setAppmanageInproxy("http");
        appmanage.setTenantCode(ResourceUtil.getAll((String)"laser", (String)"", (String)"tenantCode"));
        appmanage.setUserCode(userSession.getUserPcode());
        pmap = new PostParamMap("am.appmanage.saveAppmanage");
        pmap.putParamToJson("amAppmanageDomain", (Object)appmanage);
        this.htmlIBaseService.sendMesReJson(pmap);
        ArrayList<SmSeclist> list = new ArrayList<SmSeclist>();
        SmSeclist seclist = new SmSeclist();
        seclist.setSeclistUtype(AppManageConstants.SEC_LIST_UTYPE_TEST);
        seclist.setSeclistOtype(0);
        seclist.setSeclistOcode(appKey);
        seclist.setSeclistProxy("ALL");
        seclist.setTenantCode(ResourceUtil.getAll((String)"laser", (String)"", (String)"tenantCode"));
        SmSeclist seclist_pro = new SmSeclist();
        seclist_pro.setSeclistUtype(AppManageConstants.SEC_LIST_UTYPE_PRO);
        seclist_pro.setSeclistOtype(0);
        seclist_pro.setSeclistOcode(appKey);
        seclist_pro.setTenantCode(ResourceUtil.getAll((String)"laser", (String)"", (String)"tenantCode"));
        seclist_pro.setSeclistProxy("ALL");
        list.add(seclist);
        list.add(seclist_pro);
        pmap = new PostParamMap("sm.security.saveSeclistLot");
        pmap.putParamToJson("smSeclistDomainList", list);
        pmap.putParamToJson("cacheFlag", (Object)0);
        this.htmlIBaseService.sendMesReJson(pmap);
        return new HtmlJsonReBean((Object)appKey);
    }

    @RequestMapping(value={"delete.json"})
    @ResponseBody
    public HtmlJsonReBean deleteApp(HttpServletRequest request, String appmanageId) {
        if (StringUtils.isBlank((String)appmanageId)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        PostParamMap pmap = new PostParamMap("am.appmanage.deleteAppmanage");
        pmap.putParam("appmanageId", (Object)appmanageId);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    @RequestMapping(value={"updateTest.json"})
    @ResponseBody
    public HtmlJsonReBean updateTest(HttpServletRequest request, String appmanageAppkey) {
        if (StringUtils.isBlank((String)appmanageAppkey)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        SmSeclist seclist_test = this.querySmSeclist(appmanageAppkey, AppManageConstants.SEC_LIST_UTYPE_TEST);
        if (seclist_test == null || StringUtils.isBlank((String)seclist_test.getSeclistValue1())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bf7\u5148\u5b8c\u5584\u6d4b\u8bd5\u79d8\u94a5\u4fe1\u606f\uff01");
        }
        AmAppmanage amAppmanage = this.queryApp(appmanageAppkey);
        if (StringUtils.isBlank((String)amAppmanage.getAppmanageTesturl())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bf7\u5148\u5b8c\u5584\u6d4b\u8bd5\u5730\u5740\uff01");
        }
        List<AmAppmanage> listapp = this.queryAppList(this.getUserSession(request));
        if (null == listapp || listapp.size() == 1) {
            // empty if block
        }
        PostParamMap pmap = new PostParamMap("am.appmanage.updateAppmanageStateBykey");
        pmap.putParam("appmanageAppkey", (Object)appmanageAppkey);
        pmap.putParam("appDataState", (Object)AppState.PRE_ONLINE.getCode());
        pmap.putParam("appOldDataState", (Object)AppState.NEW.getCode());
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    @RequestMapping(value={"updatePro.json"})
    @ResponseBody
    public HtmlJsonReBean updatePro(HttpServletRequest request, String appmanageAppkey) {
        if (StringUtils.isBlank((String)appmanageAppkey)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        SmSeclist seclist_pro = this.querySmSeclist(appmanageAppkey, AppManageConstants.SEC_LIST_UTYPE_PRO);
        if (seclist_pro == null || StringUtils.isBlank((String)seclist_pro.getSeclistValue1())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bf7\u5148\u5b8c\u5584\u751f\u4ea7\u79d8\u94a5\u4fe1\u606f\uff01");
        }
        AmAppmanage amAppmanage = this.queryApp(appmanageAppkey);
        if (StringUtils.isBlank((String)amAppmanage.getAppmanageRouterouturl())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bf7\u5148\u5b8c\u5584\u751f\u4ea7\u5730\u5740\uff01");
        }
        PostParamMap pmap = new PostParamMap("am.appmanage.updateAppmanageStateBykey");
        pmap.putParam("appmanageAppkey", (Object)appmanageAppkey);
        pmap.putParam("appDataState", (Object)AppState.APPLY_ONLINE.getCode());
        pmap.putParam("appOldDataState", (Object)AppState.PRE_ONLINE.getCode());
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    @RequestMapping(value={"addSeclist.json"})
    @ResponseBody
    public HtmlJsonReBean addSeclist(HttpServletRequest request, SmSeclist seclist, String appmanageAppkey, String appmanageRouterouturl, String appmanageTesturl) {
        PostParamMap pmap;
        UserSession userSession = this.getUserSession(request);
        if (seclist == null || StringUtils.isBlank((String)seclist.getSeclistValue1()) || StringUtils.isBlank((String)seclist.getSeclistOvalue1()) || StringUtils.isBlank((String)appmanageAppkey)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        SmSeclist sec = this.querySmSeclist(appmanageAppkey, seclist.getSeclistUtype());
        if (sec == null) {
            seclist.setSeclistOtype(0);
            seclist.setSeclistProxy("ALL");
            seclist.setSeclistOcode(appmanageAppkey);
            seclist.setTenantCode(userSession.getTenantCode());
            pmap = new PostParamMap("sm.security.saveSeclist");
            pmap.putParamToJson("smSeclistDomain", (Object)seclist);
            this.htmlIBaseService.sendMesReBean(pmap);
        } else {
            sec.setSeclistValue1(seclist.getSeclistValue1());
            pmap = new PostParamMap("sm.security.updateSeclist");
            pmap.putParamToJson("smSeclistDomain", (Object)sec);
            this.htmlIBaseService.sendMesReBean(pmap);
        }
        AmAppmanage amAppmanage = this.queryApp(appmanageAppkey);
        if (amAppmanage == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "app\u67e5\u8be2\u5931\u8d25\uff01");
        }
        amAppmanage.setAppmanageRouterouturl(appmanageRouterouturl);
        amAppmanage.setAppmanageTesturl(appmanageTesturl);
        PostParamMap pmap2 = new PostParamMap("am.appmanage.updateAppmanage");
        pmap2.putParamToJson("amAppmanageDomain", (Object)amAppmanage);
        return this.htmlIBaseService.sendMesReBean(pmap2);
    }

    @RequestMapping(value={"/fileUpLoad"})
    @ResponseBody
    public String fileUpLoad(@RequestParam(value="file", required=false) MultipartFile file, HttpServletRequest request, ModelMap modelMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            InputStream is = file.getInputStream();
            byte[] b = new byte[(int)file.getSize()];
            is.read(b);
            String stringBuffer = new String(b);
            if (StringUtils.isBlank((String)stringBuffer)) {
                map.put("data", "error");
                map.put("msg", "\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a");
                return JsonUtil.buildNormalBinder().toJson(map);
            }
            FileDomain fileDomain = this.fileRepository.saveFile(file, this.getTenantCode(), "file_03");
            map.put("data", "success");
            map.put("msg", fileDomain.getFileUrl() + "/" + fileDomain.getFileCode() + "." + fileDomain.getFileCtype());
        }
        catch (Exception e) {
            map.put("data", "error");
        }
        return JsonUtil.buildNormalBinder().toJson(map);
    }

    private List<AmAppmanage> queryAppList(UserSession userSession) {
        if (userSession == null) {
            return null;
        }
        PostParamMap pmap = new PostParamMap("am.appmanage.queryAppmanageListNopage");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userCode", userSession.getUserPcode());
        pmap.putParamToJson("map", map);
        List appList = (List)this.htmlIBaseService.senReList(pmap, AmAppmanage.class);
        if (appList == null || appList.size() == 0) {
            return null;
        }
        return appList;
    }

    private AmAppmanage queryApp(String appmanageAppkey) {
        if (StringUtils.isBlank((String)appmanageAppkey)) {
            return null;
        }
        PostParamMap pmap = new PostParamMap("am.appmanage.queryAppmanageListNopage");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appmanageAppkey", appmanageAppkey);
        pmap.putParamToJson("map", map);
        List list = (List)this.htmlIBaseService.senReList(pmap, AmAppmanage.class);
        if (list.size() == 0) {
            return null;
        }
        return (AmAppmanage)list.get(0);
    }

    private SmSeclist querySmSeclist(String seclistOcode, Integer seclistUtype) {
        PostParamMap pmap = new PostParamMap("sm.security.querySeclistPage");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("seclistOcode", seclistOcode);
        map.put("seclistOtype", "0");
        map.put("seclistUtype", seclistUtype);
        pmap.putParamToJson("map", map);
        SupQueryResult rs = this.htmlIBaseService.sendReSupObject(pmap, SmSeclist.class);
        if (null == rs || rs.getList().size() == 0) {
            return null;
        }
        return (SmSeclist)rs.getList().get(0);
    }

    @RequestMapping(value={"getPublicKey.json"})
    @ResponseBody
    public HtmlJsonReBean getPublicKey(String appmanageAppkey, Integer seclistUtype) {
        String publicKey;
        String privateKey;
        if (StringUtils.isBlank((String)appmanageAppkey) || null == seclistUtype) {
            return new HtmlJsonReBean((Object)"\u83b7\u53d6\u516c\u94a5\u5931\u8d25\uff0c\u8bf7\u5148\u5efa\u7acbapp\u4fe1\u606f\uff01");
        }
        try {
            KeyPair keyPair = RSAUtils.genKeyPair();
            privateKey = RSAUtils.getPrivateKey((KeyPair)keyPair);
            publicKey = RSAUtils.getPublicKey((KeyPair)keyPair);
        }
        catch (Exception e) {
            this.logger.error("getPublicKey", (Object)e.getMessage());
            return new HtmlJsonReBean((Object)"\u83b7\u53d6\u516c\u94a5\u5931\u8d25\uff0c\u5237\u65b0\u518d\u6b21\u83b7\u53d6\uff01");
        }
        SmSeclist sec = this.querySmSeclist(appmanageAppkey, seclistUtype);
        if (sec == null) {
            return new HtmlJsonReBean((Object)"\u83b7\u53d6\u516c\u94a5\u5931\u8d25\uff0c\u5237\u65b0\u518d\u6b21\u83b7\u53d6\uff01");
        }
        sec.setSeclistOvalue1(publicKey);
        sec.setSeclistOvalue2(privateKey);
        PostParamMap pmap = new PostParamMap("sm.security.updateSeclist");
        pmap.putParamToJson("smSeclistDomain", (Object)sec);
        this.htmlIBaseService.sendMesReBean(pmap);
        return new HtmlJsonReBean((Object)publicKey);
    }

    @RequestMapping(value={"offline.json"})
    @ResponseBody
    public HtmlJsonReBean offline(HttpServletRequest request, String appmanageAppkey) {
        if (StringUtils.isBlank((String)appmanageAppkey)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        PostParamMap pmap = new PostParamMap("am.appmanage.updateAppmanageStateBykey");
        pmap.putParam("appmanageAppkey", (Object)appmanageAppkey);
        pmap.putParam("appDataState", (Object)AppState.OFFLINE.getCode());
        pmap.putParam("appOldDataState", (Object)AppState.ONLINE.getCode());
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    private String getTenantCode(String userPCode) {
        PostParamMap pmap = new PostParamMap("tm.tenant.queryTenantPage");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantOpuser", userPCode);
        pmap.putParamToJson("map", map);
        SupQueryResult rs = this.htmlIBaseService.sendReSupObject(pmap, TmTenant.class);
        if (rs != null && rs.getList() != null && rs.getList().size() > 0) {
            return ((TmTenant)rs.getList().get(0)).getTenantCode();
        }
        return null;
    }

    private UmUserinfo getUserInfo(String userPCode) {
        PostParamMap pmap = new PostParamMap("um.user.queryUserinfoPage");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userinfoCode", userPCode);
        pmap.putParamToJson("map", map);
        SupQueryResult rs = this.htmlIBaseService.sendReSupObject(pmap, UmUserinfo.class);
        if (rs != null && rs.getList() != null && rs.getList().size() > 0) {
            return (UmUserinfo)rs.getList().get(0);
        }
        return null;
    }
}

