/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.project.controller;

import com.yqbsoft.laser.html.common.send.PostParamMap;
import com.yqbsoft.laser.html.core.auth.UserSession;
import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.core.util.HtmlUtil;
import com.yqbsoft.laser.html.facade.bm.file.bean.DownloadFileDomainBean;
import com.yqbsoft.laser.html.facade.bm.file.repository.DownloadFileRepository;
import com.yqbsoft.laser.html.facade.bm.repository.DdRepository;
import com.yqbsoft.laser.html.facade.est.project.bean.ProjectReBean;
import com.yqbsoft.laser.html.facade.est.project.domain.PtBuildingDomain;
import com.yqbsoft.laser.html.facade.est.project.repository.PtBuildingRepository;
import com.yqbsoft.laser.html.facade.est.project.repository.PtHouseRepository;
import com.yqbsoft.laser.html.facade.est.project.repository.PtProjectRepository;
import com.yqbsoft.laser.html.facade.est.repository.TeamRepository;
import com.yqbsoft.laser.html.project.bean.BuildingBatchBean;
import com.yqbsoft.laser.html.project.bean.BuildingImpBean;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.SupperSysException;
import com.yqbsoft.laser.service.tool.util.ExcelReaderUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/web/pt/building"})
public class BuildingCon
extends SpringmvcController {
    private static String CODE = "pt.building.con";
    @Autowired
    private PtBuildingRepository ptBuildingRepository;
    @Autowired
    private PtHouseRepository ptHouseRepository;
    @Resource
    private DownloadFileRepository downloadFileRepository;
    @Resource
    private TeamRepository teamRepository;
    @Resource
    private PtProjectRepository ptProjectRepository;
    @Resource
    private DdRepository ddRepository;

    protected String getContext() {
        return "building";
    }

    @RequestMapping(value={"add"})
    public String add(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "add";
    }

    @RequestMapping(value={"addSave.json"})
    @ResponseBody
    public HtmlJsonReBean addSave(PtBuildingDomain buildingBean) {
        if (null == buildingBean) {
            this.logger.error(CODE + ".addSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ptProjectRepository.saveBuilding(buildingBean);
    }

    @RequestMapping(value={"edit"})
    public String edit(HttpServletRequest request, String buildingId, ModelMap modelMap) {
        modelMap.put((Object)"buildingReBean", (Object)this.getBuilding(buildingId));
        return this.getFtlTempPath(request) + "edit";
    }

    @RequestMapping(value={"editSave.json"})
    @ResponseBody
    public HtmlJsonReBean editSave(HttpServletRequest request, PtBuildingDomain buildingBean) {
        if (null == buildingBean) {
            this.logger.error(CODE + ".editSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ptProjectRepository.updateBuilding(buildingBean);
    }

    @RequestMapping(value={"delSave.json"})
    @ResponseBody
    public HtmlJsonReBean delSave(HttpServletRequest request, String buildingId) {
        if (StringUtils.isBlank((String)buildingId)) {
            this.logger.error(CODE + ".delSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ptProjectRepository.deleteBuilding(Integer.valueOf(Integer.parseInt(buildingId)));
    }

    @RequestMapping(value={"stateSave.json"})
    @ResponseBody
    public HtmlJsonReBean startSave(HttpServletRequest request, String buildingId, String dataState, String oldDataState) {
        if (StringUtils.isBlank((String)buildingId) || StringUtils.isBlank((String)dataState) || StringUtils.isBlank((String)oldDataState)) {
            this.logger.error(CODE + ".startSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ptProjectRepository.updateBuildingState(buildingId, dataState, oldDataState);
    }

    @RequestMapping(value={"view"})
    public String view(HttpServletRequest request, String buildingId, ModelMap modelMap) {
        modelMap.put((Object)"buildingReBean", (Object)this.getBuilding(buildingId));
        return this.getFtlTempPath(request) + "view";
    }

    private String getBuilding(String buildingId) {
        String rs = "{}";
        if (StringUtils.isBlank((String)buildingId)) {
            this.logger.error(CODE + ".getBuilding", (Object)"buildingId is null");
        } else {
            rs = JsonUtil.buildNormalBinder().toJson((Object)this.ptProjectRepository.getBuilding(Integer.valueOf(Integer.parseInt(buildingId))));
        }
        return rs;
    }

    @RequestMapping(value={"list"})
    public String list(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "list";
    }

    @RequestMapping(value={"listQuery.json"})
    @ResponseBody
    public Object listQuery(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ptProjectRepository.queryBuildingPage(param);
    }

    @RequestMapping(value={"dev/sellControl/imp"})
    public String impAdd(HttpServletRequest request, ModelMap map) {
        UserSession userSession = this.getUserSession(request);
        List projects = this.ptProjectRepository.getProjectByRole(userSession, Integer.valueOf(0), true);
        if (ListUtil.isNotEmpty((Collection)projects)) {
            map.addAttribute("projects", (Object)projects);
        }
        return this.getFtlTempPath(request) + "imp";
    }

    @RequestMapping(value={"dev/sellControl/download/modelfile"})
    public String download(String type, String fileCode, HttpServletResponse response, HttpServletRequest request) {
        if (type == null || "sellControl".equals(type)) {
            // empty if block
        }
        if (StringUtils.isBlank((String)fileCode)) {
            request.setAttribute("ex", (Object)"\u4e0b\u8f7d\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
            throw new SupperSysException("download", "\u4e0b\u8f7d\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
        ServletOutputStream out2 = null;
        DownloadFileDomainBean downloadFile = this.downloadFileRepository.getDownloadFileByCode(fileCode);
        byte[] fileContent = downloadFile.getFilecontent();
        if (fileContent != null && fileContent.length > 0) {
            String fileName = downloadFile.getFileName() == null ? downloadFile.getFileCode() + "." + downloadFile.getFileCtype() : downloadFile.getFileName();
            response.setHeader("content-disposition", "attachment;filename=" + fileName + "." + downloadFile.getFileCtype());
            try {
                out2 = response.getOutputStream();
                out2.write(fileContent);
                out2.flush();
            }
            catch (IOException e) {
                request.setAttribute("ex", (Object)e.getMessage());
                throw new SupperSysException("download", e.getMessage());
            }
        } else {
            request.setAttribute("ex", (Object)"\u4e0b\u8f7d\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
            throw new SupperSysException("download", "\u4e0b\u8f7d\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
        return null;
    }

    private String[] getTeamCode(String userCode) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userCode", userCode);
        String[] teamInfo = this.teamRepository.getTeamInfo(param);
        return teamInfo;
    }

    private String[] getProjectInfo(UserSession userSession, String teamCode) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userCode", userSession.getUserCode());
        param.put("tenantCode", userSession.getTenantCode());
        param.put("dataState", "0");
        param.put("teamCode", teamCode);
        String[] projectInfo = this.ptProjectRepository.getProjectInfoByUserCode(param);
        return projectInfo;
    }

    @RequestMapping(value={"dev/sellControl/imp/initializeBuilding"}, produces={"application/json"})
    @ResponseBody
    public HtmlJsonReBean initializeBuilding(HttpServletRequest request, @RequestParam(value="file", required=false) MultipartFile file, String projectCode, String handleType) {
        HashMap<String, String> projectMap = new HashMap<String, String>();
        projectMap.put("projectCode", projectCode);
        ProjectReBean pb = this.ptProjectRepository.getProjectByCode(projectMap);
        String tenantCode = pb.getTenantCode();
        if (StringUtils.isEmpty((String)tenantCode)) {
            tenantCode = this.getTenantCode(request);
        }
        if (StringUtils.isEmpty((String)handleType)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bf7\u9009\u62e9\u5bfc\u5165\u7c7b\u578b");
        }
        Integer impType = Integer.parseInt(handleType);
        if (file != null) {
            Map columnMap = this.ddRepository.getExcelColumnMatch("ExcelSellControl-impProperty");
            if (MapUtil.isEmpty((Map)columnMap)) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u83b7\u53d6\u5230\u540e\u53f0\u5bf9\u5e94\u7684\u5c5e\u6027,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            List list = null;
            try {
                String buildingNames = ExcelReaderUtils.getSheetsNameByStream((InputStream)file.getInputStream());
                list = ExcelReaderUtils.parseExcelByStream((InputStream)file.getInputStream(), (Object)new BuildingBatchBean(), (Map)columnMap);
                this.logger.info("\u89e3\u6790excel\u7684sheet\u4e2a\u6570\uff1a" + list.size());
                if (ListUtil.isEmpty((Collection)list)) {
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5bfc\u5165\u5931\u8d25\uff0c\u672a\u8bfb\u53d6\u5230\u6570\u636e");
                }
                this.readyInfo(list, projectCode, buildingNames, tenantCode, impType);
                this.logger.info("\u9500\u63a7\u6279\u91cf\u5bfc\u5165\u6210\u529f");
            }
            catch (IOException e) {
                e.printStackTrace();
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, e.getMessage());
            }
            catch (InvalidFormatException e) {
                e.printStackTrace();
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, e.getMessage());
            }
        }
        return new HtmlJsonReBean();
    }

    public Map<String, Object> readyInfo(List<List<BuildingBatchBean>> lists, String projectCode, String buildingNames, String tenantCode, Integer impType) throws Exception {
        int i = 0;
        for (List<BuildingBatchBean> list : lists) {
            for (BuildingBatchBean buildingBatchBean : list) {
                buildingBatchBean.setImpType(impType);
                buildingBatchBean.setBuildingName(buildingNames);
                buildingBatchBean.setProjectCode(projectCode);
                buildingBatchBean.setTenantCode(tenantCode);
            }
            PostParamMap pmap = new PostParamMap("pt.project.insertInitBatchBuilding");
            pmap.putParamToJson("list", list);
            this.htmlIBaseService.senBySupRq(pmap, new ArrayList());
            this.logger.info("\u89e3\u6790\u7b2c" + ++i + "\u4e2asheet\uff0c\u9500\u63a7\u6279\u91cf\u5bfc\u5165\u6210\u529f" + list.size() + "\u6761");
        }
        return null;
    }

    public Map<String, Object> readyInfoBak(List<List<BuildingImpBean>> lists, String projectCode, String buildingNames, String tenantCode, Integer impType) throws Exception {
        if (buildingNames != null) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            for (List<BuildingImpBean> list : lists) {
                int j = 0;
                ArrayList<BuildingBatchBean> buildings = new ArrayList<BuildingBatchBean>();
                for (BuildingImpBean buildingImpBean : list) {
                    ++j;
                    BuildingBatchBean impBatchBean = new BuildingBatchBean();
                    impBatchBean.setUnitName(buildingImpBean.getUnitName());
                    impBatchBean.setHouseType(buildingImpBean.getHouseType());
                    impBatchBean.setBuildingName(buildingNames);
                    impBatchBean.setFloorName(buildingImpBean.getFloorName());
                    impBatchBean.setHouseName(buildingImpBean.getHouseName());
                    impBatchBean.setImpType(impType);
                    try {
                        impBatchBean.setPrivateArea(this.toBigDecimal(buildingImpBean.getPrivateArea()));
                    }
                    catch (Exception e) {
                        throw new Exception(this.getExceptionStr(sb, i, j, "\u79c1\u6709\u9762\u79ef"));
                    }
                    try {
                        impBatchBean.setPublicCoefficient(this.toBigDecimal(buildingImpBean.getPublicCoefficient()));
                    }
                    catch (Exception e) {
                        throw new Exception(this.getExceptionStr(sb, i, j, "\u516c\u644a\u7cfb\u6570"));
                    }
                    try {
                        impBatchBean.setPublicArea(this.toBigDecimal(buildingImpBean.getPublicArea()));
                    }
                    catch (Exception e) {
                        throw new Exception(this.getExceptionStr(sb, i, j, "\u516c\u644a\u9762\u79ef"));
                    }
                    try {
                        impBatchBean.setBalconyArea(this.toBigDecimal(buildingImpBean.getBalconyArea()));
                    }
                    catch (Exception e) {
                        throw new Exception(this.getExceptionStr(sb, i, j, "\u9633\u53f0\u9762\u79ef"));
                    }
                    try {
                        impBatchBean.setTotalArea(this.toBigDecimal(buildingImpBean.getTotalArea()));
                    }
                    catch (Exception e) {
                        throw new Exception(this.getExceptionStr(sb, i, j, "\u5efa\u7b51\u603b\u9762\u79ef"));
                    }
                    try {
                        impBatchBean.setAveragePrice(this.toBigDecimal(buildingImpBean.getAveragePrice()));
                    }
                    catch (Exception e) {
                        throw new Exception(this.getExceptionStr(sb, i, j, "\u5355\u4ef7"));
                    }
                    try {
                        impBatchBean.setTotalPrice(this.toBigDecimal(buildingImpBean.getTotalPrice()));
                    }
                    catch (Exception e) {
                        throw new Exception(this.getExceptionStr(sb, i, j, "\u603b\u4ef7"));
                    }
                    impBatchBean.setFunctionalAreas(buildingImpBean.getFunctionalAreas());
                    impBatchBean.setProjectCode(projectCode);
                    impBatchBean.setTenantCode(tenantCode);
                    impBatchBean.setComment(buildingImpBean.getComment());
                    buildings.add(impBatchBean);
                }
                PostParamMap pmap = new PostParamMap("pt.project.insertInitBatchBuilding");
                pmap.putParamToJson("list", buildings);
                this.htmlIBaseService.senBySupRq(pmap, new ArrayList());
                this.logger.info("\u89e3\u6790\u7b2c" + ++i + "\u4e2asheet\uff0c\u9500\u63a7\u6279\u91cf\u5bfc\u5165\u6210\u529f" + list.size() + "\u6761");
            }
        } else {
            throw new Exception("\u672a\u6309\u7167\u6307\u5b9a\u683c\u5f0f\u5bfc\u5165\uff0c\u8bf7\u68c0\u67e5sheet\u540d\u79f0");
        }
        return null;
    }

    private String getExceptionStr(StringBuffer sb, int i, int j, String exceStr) {
        if (sb != null && sb.length() > 0) {
            sb.delete(0, sb.length() - 1);
        }
        sb.append("\u9519\u8bef\uff0c\u5728\u7b2c");
        sb.append(i + 1);
        sb.append("\u4e2asheet\uff0c\u7b2c");
        sb.append(j);
        sb.append("\u884c");
        sb.append(exceStr);
        sb.append("\u9519\u8bef\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165");
        return sb.toString();
    }

    private BigDecimal toBigDecimal(String str) throws Exception {
        if (StringUtils.isNotBlank((String)str)) {
            try {
                return new BigDecimal(str);
            }
            catch (Exception e) {
                throw new Exception("\u8bf7\u68c0\u67e5\u5404\u6570\u5b57\u6b63\u786e");
            }
        }
        return new BigDecimal(0);
    }

    /*
     * WARNING - void declaration
     */
    @RequestMapping(value={"dev/sellControl/list"})
    public String devSellControlList(HttpServletRequest request, ModelMap modelMap) {
        List houses;
        List buildings;
        UserSession user = this.getUserSession(request);
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        param.put("tenantCode", user.getTenantCode());
        if (param != null) {
            if (param.get("projectSelect") != null) {
                param.put("projectCode", param.get("projectSelect"));
            }
            if (param.get("buildingSelect") != null) {
                param.put("buildingCode", param.get("buildingSelect"));
            }
        }
        Map<String, Object> supsBuilding = this.queryBuildingProcess(param);
        String defaultBuildingCode = "";
        String defaultBuildingName = "";
        Integer buildingType = 1;
        if (supsBuilding != null && ListUtil.isNotEmpty((Collection)(buildings = (List)supsBuilding.get("list")))) {
            defaultBuildingCode = ((Map)buildings.get(0)).get("buildingCode");
            defaultBuildingName = (String)((Map)buildings.get(0)).get("buildingName");
            buildingType = (Integer)((Map)buildings.get(0)).get("buildingType");
        }
        if (StringUtils.isNotBlank((String)defaultBuildingName)) {
            param.put("buildingCode", defaultBuildingCode);
        }
        param.put("orderStr", " unit_name*1 ,floor_name*1,house_name*1");
        Map sups = (Map)this.ptHouseRepository.queryHousePage(param, true, false);
        HashMap<String, Serializable> retMap = new HashMap<String, Serializable>();
        if (sups != null && ListUtil.isNotEmpty((Collection)(houses = (List)sups.get("list")))) {
            ArrayList units = new ArrayList();
            for (Object houseMap : houses) {
                boolean exists = false;
                HashMap unit = new HashMap();
                for (Map map : units) {
                    if (!map.get("unitCode").equals(houseMap.get("unitCode"))) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                unit.put("unitCode", houseMap.get("unitCode"));
                unit.put("unitName", houseMap.get("unitName"));
                units.add(unit);
            }
            retMap.put("units", units);
            ArrayList floors = new ArrayList();
            for (Map houseMap : houses) {
                HashMap floor = new HashMap();
                boolean bl = false;
                for (Map map : floors) {
                    if (!houseMap.get("floorName").equals(map.get("floorName"))) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                floor.put("floorCode", houseMap.get("floorCode"));
                floor.put("floorName", houseMap.get("floorName"));
                floors.add(floor);
            }
            String unitCodeMark = "";
            int unitColspanCount = 4;
            for (Map map : floors) {
                void var18_28;
                boolean bl = false;
                ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
                for (Map houseMap_housess : houses) {
                    if (!unitCodeMark.equals(houseMap_housess.get("unitCode"))) {
                        if (StringUtils.isNotBlank((String)unitCodeMark) && unitColspanCount > var18_28 && var18_28 > 0) {
                            for (int i = 0; i < unitColspanCount - var18_28; ++i) {
                                this.assemblingHouse(arrayList, "", "", "-1", "0");
                                ++var18_28;
                            }
                        }
                        unitCodeMark = (String)houseMap_housess.get("unitCode");
                    }
                    if (!map.get("floorName").equals(houseMap_housess.get("floorName"))) continue;
                    boolean houseExists = false;
                    for (Map map2 : arrayList) {
                        if (!map2.get("houseCode").equals(houseMap_housess.get("houseCode"))) continue;
                        houseExists = true;
                        break;
                    }
                    if (houseExists) break;
                    this.assemblingHouse(arrayList, houseMap_housess.get("houseCode"), houseMap_housess.get("houseName"), houseMap_housess.get("dataState"), houseMap_housess.get("manageUpdateNum"));
                    ++var18_28;
                }
                if (buildingType == 2 && var18_28 > unitColspanCount) {
                    unitColspanCount = var18_28;
                }
                map.put("housess", arrayList);
            }
            for (Map map : floors) {
                List list = (List)map.get("housess");
                int n = 0;
                int j = list.size();
                if (j % unitColspanCount > 0) {
                    n = unitColspanCount - j % unitColspanCount;
                }
                for (int i = 0; i < n; ++i) {
                    this.assemblingHouse(list, "", "", "-1", "0");
                }
            }
            retMap.put("floors", floors);
            retMap.put("unitColspan", Integer.valueOf(unitColspanCount));
            retMap.put("projectSelect", (Serializable)param.get("projectCode"));
            retMap.put("buildingSelect", (Serializable)param.get("buildingSelect"));
            retMap.put("sellDataState", (Serializable)param.get("sellDataState"));
            modelMap.put((Object)"retMap", retMap);
        }
        return this.getFtlTempPath(request) + "list";
    }

    private void assemblingHouse(List<Map<String, Object>> housess, Object houseCode, Object houseName, Object dataState, Object manageUpdateNum) {
        HashMap<String, Object> house = new HashMap<String, Object>();
        house.put("houseCode", houseCode);
        house.put("houseName", houseName);
        house.put("dataState", Integer.valueOf(String.valueOf(dataState)));
        house.put("manageUpdateNum", Integer.valueOf(String.valueOf(manageUpdateNum)));
        housess.add(house);
    }

    @RequestMapping(value={"dev/sellControl/setting"})
    public String devSellControlSetting(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "list";
    }

    @RequestMapping(value={"dev/sellControl/examlist"})
    public String devSellControlExamList(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "list";
    }

    @RequestMapping(value={"dev/queryPtBuilding.json"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseBody
    public HtmlJsonReBean queryPtBuilding(HttpServletRequest request) {
        List buildings;
        UserSession user = this.getUserSession(request);
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        param.put("tenantCode", user.getTenantCode());
        Map<String, Object> sups = this.queryBuildingProcess(param);
        if (sups != null && ListUtil.isNotEmpty((Collection)(buildings = (List)sups.get("list")))) {
            return new HtmlJsonReBean((Object)buildings);
        }
        return new HtmlJsonReBean(new ArrayList());
    }

    private Map<String, Object> queryBuildingProcess(Map<String, Object> param) {
        Map sups = (Map)this.ptBuildingRepository.queryBuildingPage(param, false, false);
        return sups;
    }
}

