/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.project.controller;

import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.core.util.HtmlUtil;
import com.yqbsoft.laser.html.facade.est.project.domain.PtProjectCpDomain;
import com.yqbsoft.laser.html.facade.est.project.repository.PtProjectRepository;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/pt/projectCp"})
public class ProjectCpCon
extends SpringmvcController {
    private static String CODE = "pt.projectCp.con";
    @Autowired
    private PtProjectRepository projectRepository;

    protected String getContext() {
        return "projectCp";
    }

    @RequestMapping(value={"add"})
    public String add(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "add";
    }

    @RequestMapping(value={"addSave.json"})
    @ResponseBody
    public HtmlJsonReBean addSave(PtProjectCpDomain projectCpBean) {
        if (null == projectCpBean) {
            this.logger.error(CODE + ".addSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.projectRepository.saveProjectCp(projectCpBean);
    }

    @RequestMapping(value={"edit"})
    public String edit(HttpServletRequest request, String cpId, ModelMap modelMap) {
        modelMap.put((Object)"projectCpReBean", (Object)this.getProjectCp(cpId));
        return this.getFtlTempPath(request) + "edit";
    }

    @RequestMapping(value={"editSave.json"})
    @ResponseBody
    public HtmlJsonReBean editSave(HttpServletRequest request, PtProjectCpDomain projectCpBean) {
        if (null == projectCpBean) {
            this.logger.error(CODE + ".editSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.projectRepository.updateProjectCp(projectCpBean);
    }

    @RequestMapping(value={"delSave.json"})
    @ResponseBody
    public HtmlJsonReBean delSave(HttpServletRequest request, String cpId) {
        if (StringUtils.isBlank((String)cpId)) {
            this.logger.error(CODE + ".delSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.projectRepository.deleteProjectCp(Integer.valueOf(Integer.parseInt(cpId)));
    }

    @RequestMapping(value={"stateSave.json"})
    @ResponseBody
    public HtmlJsonReBean startSave(HttpServletRequest request, String cpId, String dataState, String oldDataState) {
        if (StringUtils.isBlank((String)cpId) || StringUtils.isBlank((String)dataState) || StringUtils.isBlank((String)oldDataState)) {
            this.logger.error(CODE + ".startSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.projectRepository.updateProjectCpState(cpId, dataState, oldDataState);
    }

    @RequestMapping(value={"view"})
    public String view(HttpServletRequest request, String cpId, ModelMap modelMap) {
        modelMap.put((Object)"projectCpReBean", (Object)this.getProjectCp(cpId));
        return this.getFtlTempPath(request) + "view";
    }

    private String getProjectCp(String cpId) {
        String rs = "{}";
        if (StringUtils.isBlank((String)cpId)) {
            this.logger.error(CODE + ".getProjectCp", (Object)"cpId is null");
        } else {
            rs = JsonUtil.buildNormalBinder().toJson((Object)this.projectRepository.getProjectCp(Integer.valueOf(Integer.parseInt(cpId))));
        }
        return rs;
    }

    @RequestMapping(value={"list"})
    public String list(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "list";
    }

    @RequestMapping(value={"listQuery.json"})
    @ResponseBody
    public Object listQuery(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.projectRepository.queryProjectCpPage(param);
    }
}

