/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.project.controller;

import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.core.util.HtmlUtil;
import com.yqbsoft.laser.html.facade.est.project.domain.PtProjectTmDomain;
import com.yqbsoft.laser.html.facade.est.project.repository.PtProjectRepository;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/pt/projectTm"})
public class ProjectTmCon
extends SpringmvcController {
    private static String CODE = "pt.projectTm.con";
    @Autowired
    private PtProjectRepository projectRepository;

    protected String getContext() {
        return "projectTm";
    }

    @RequestMapping(value={"add"})
    public String add(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "add";
    }

    @RequestMapping(value={"addSave.json"})
    @ResponseBody
    public HtmlJsonReBean addSave(PtProjectTmDomain projectTmBean) {
        if (null == projectTmBean) {
            this.logger.error(CODE + ".addSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.projectRepository.saveProjectTm(projectTmBean);
    }

    @RequestMapping(value={"edit"})
    public String edit(HttpServletRequest request, String tmId, ModelMap modelMap) {
        modelMap.put((Object)"projectTmReBean", (Object)this.getProjectTm(tmId));
        return this.getFtlTempPath(request) + "edit";
    }

    @RequestMapping(value={"editSave.json"})
    @ResponseBody
    public HtmlJsonReBean editSave(HttpServletRequest request, PtProjectTmDomain projectTmBean) {
        if (null == projectTmBean) {
            this.logger.error(CODE + ".editSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.projectRepository.updateProjectTm(projectTmBean);
    }

    @RequestMapping(value={"delSave.json"})
    @ResponseBody
    public HtmlJsonReBean delSave(HttpServletRequest request, String tmId) {
        if (StringUtils.isBlank((String)tmId)) {
            this.logger.error(CODE + ".delSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.projectRepository.deleteProjectTm(Integer.valueOf(Integer.parseInt(tmId)));
    }

    @RequestMapping(value={"stateSave.json"})
    @ResponseBody
    public HtmlJsonReBean startSave(HttpServletRequest request, String tmId, String dataState, String oldDataState) {
        if (StringUtils.isBlank((String)tmId) || StringUtils.isBlank((String)dataState) || StringUtils.isBlank((String)oldDataState)) {
            this.logger.error(CODE + ".startSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.projectRepository.updateProjectTmState(tmId, dataState, oldDataState);
    }

    @RequestMapping(value={"view"})
    public String view(HttpServletRequest request, String tmId, ModelMap modelMap) {
        modelMap.put((Object)"projectTmReBean", (Object)this.getProjectTm(tmId));
        return this.getFtlTempPath(request) + "view";
    }

    private String getProjectTm(String tmId) {
        String rs = "{}";
        if (!StringUtils.isBlank((String)tmId)) {
            return JsonUtil.buildNormalBinder().toJson((Object)this.projectRepository.getProjectTm(Integer.valueOf(Integer.parseInt(tmId))));
        }
        this.logger.error(CODE + ".getProjectTm", (Object)"tmId is null");
        return rs;
    }

    @RequestMapping(value={"list"})
    public String list(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "list";
    }

    @RequestMapping(value={"listQuery.json"})
    @ResponseBody
    public Object listQuery(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.projectRepository.queryProjectTmPage(param);
    }
}

