/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.springmvc;

import com.yqbsoft.laser.html.common.send.PostParamMap;
import com.yqbsoft.laser.html.common.service.HtmlIBaseService;
import com.yqbsoft.laser.html.core.auth.AuthBean;
import com.yqbsoft.laser.html.core.auth.UserSession;
import com.yqbsoft.laser.html.core.supcontroller.SupController;
import com.yqbsoft.laser.html.springmvc.bean.FileDomain;
import com.yqbsoft.laser.html.springmvc.interceptor.SpringMVCInterceptor;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.file.FileBean;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.InputStream;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.multipart.MultipartFile;

public abstract class SpringmvcController
extends SupController {
    @Autowired
    public HtmlIBaseService htmlIBaseService;

    protected abstract String getContext();

    public UserSession getUserSession(HttpServletRequest request) {
        if (null == request || null == request.getSession()) {
            return null;
        }
        return (UserSession)request.getSession().getAttribute(SpringMVCInterceptor.SESSION_KEY);
    }

    public void setUserSession(HttpServletRequest request, UserSession userSession) {
        if (null == request || null == request.getSession()) {
            return;
        }
        request.getSession().setAttribute(SpringMVCInterceptor.SESSION_KEY, (Object)userSession);
    }

    public String getUrlPath(HttpServletRequest request) {
        if (null == request) {
            return "";
        }
        AuthBean authBean = (AuthBean)request.getSession().getAttribute(SpringMVCInterceptor.res_sesskey);
        if (null != authBean && null != authBean.getResBean()) {
            return authBean.getResBean().getUrlPath();
        }
        return "";
    }

    public String getFtlTempPath(HttpServletRequest request) {
        String context = this.getUrlPath(request);
        if (StringUtils.isBlank((String)context)) {
            context = this.getContext();
        }
        if (StringUtils.isNotBlank((String)context) && !"/".equals(context.substring(context.length() - 1))) {
            context = context + "/";
        }
        return context;
    }

    public SupPageTools buildPage(SupPageTools supPageTools, HttpServletRequest request) {
        String page = request.getParameter("page");
        String rows = request.getParameter("rows");
        if (StringUtils.isBlank((String)page)) {
            return supPageTools;
        }
        Integer pageNo = Integer.parseInt(page);
        supPageTools.setStartRow(Integer.parseInt(rows) * (pageNo - 1));
        return supPageTools;
    }

    public FileDomain saveFile(MultipartFile file, String tenantCode, String fileSort) {
        FileDomain fileDomain = null;
        try {
            if (file == null) {
                return null;
            }
            PostParamMap pmap = new PostParamMap("fm.file.saveFile");
            String filename = file.getOriginalFilename();
            String fileType = filename.substring(filename.lastIndexOf(".") + 1, filename.length());
            String name = filename.substring(0, filename.lastIndexOf("."));
            FileDomain fileDomainBean = new FileDomain();
            fileDomainBean.setFileName(name);
            fileDomainBean.setFileSize((int)file.getSize());
            fileDomainBean.setFileType("0");
            fileDomainBean.setFileCtype(fileType);
            fileDomainBean.setFileSort(StringUtils.isBlank((String)fileSort) ? "FILE_02" : fileSort);
            fileDomainBean.setTenantCode(tenantCode);
            ArrayList<FileBean> fileBeanList = new ArrayList<FileBean>();
            FileBean fileBean = new FileBean();
            fileBean.setFileType(fileType);
            fileBean.setOriginalFilename(name);
            fileBean.setSize(Long.valueOf(file.getSize()));
            InputStream is = file.getInputStream();
            byte[] b = new byte[(int)file.getSize()];
            is.read(b);
            fileBean.setBytes(b);
            fileBeanList.add(fileBean);
            pmap.putParamToJson("fmFileDomainBean", (Object)fileDomainBean);
            pmap.putParamToJson("fileBeanList", fileBeanList);
            String key = "filePath";
            String settingType = "0";
            fileDomain = (FileDomain)((Object)this.htmlIBaseService.senReObject(pmap, FileDomain.class));
            String httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-" + settingType + "-" + key));
            String fileUrl = fileDomain.getFileUrl();
            if (StringUtils.isNotBlank((String)fileUrl)) {
                fileDomain.setFileUrl(httpPath + fileUrl);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileDomain;
    }
}

