/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.springmvc.interceptor;

import com.yqbsoft.laser.html.common.util.ResourceUtil;
import com.yqbsoft.laser.html.core.auth.AuthBean;
import com.yqbsoft.laser.html.core.auth.AuthCheck;
import com.yqbsoft.laser.html.core.auth.AuthService;
import com.yqbsoft.laser.html.core.auth.UserSession;
import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.core.intercepter.AbstractIntercepter;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.tool.util.BrowTypeUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class SpringMVCInterceptor
extends AbstractIntercepter
implements HandlerInterceptor {
    private String sys_code = "SpringMVCInterceptor";
    public static String res_sesskey = "res_sesskey";
    public static String SESSION_KEY = "laser_UserSession";
    public static String UP_URL = "laser_upurl";
    public static String Tokenkey = "tokenkey";
    public static String TenantCode = "tenantCode";
    public static String REBACK_URL = "reback_url";
    @Autowired
    private AuthService authService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String requestType = request.getHeader("X-Requested-With");
        String url = "";
        String method = "";
        String contextPath = "";
        String userCode = "";
        boolean json = false;
        boolean app = false;
        String charset = "";
        String token = request.getParameter(Tokenkey);
        String tenantCode = ResourceUtil.getOut((String)"laser", (String)"", (String)"tenantCode");
        UserSession userSession = null;
        String group = SupDisUtil.getMap((String)"osconfig_key", (String)ServletMain.getAppName());
        if (null != request) {
            url = request.getServletPath();
            method = request.getMethod();
            contextPath = request.getContextPath();
            if (BrowTypeUtil.getBrowType((String)request.getHeader("User-Agent")).equals("3")) {
                app = true;
            }
            if (null != request.getCookies()) {
                Cookie[] cookies;
                for (Cookie cookie : cookies = request.getCookies()) {
                    if (cookie.getName().equalsIgnoreCase(Tokenkey + "-" + group) && StringUtils.isBlank((String)token)) {
                        token = cookie.getValue();
                    }
                    if (!cookie.getName().equalsIgnoreCase(TenantCode + "-" + group)) continue;
                    tenantCode = cookie.getValue();
                }
            }
            if (StringUtils.isNotBlank((String)token)) {
                userSession = this.authService.checkOauth(token, ServletMain.getAppName(), tenantCode);
            }
            request.getSession().setAttribute(SESSION_KEY, userSession);
            if (null != userSession) {
                userCode = userSession.getUserCode();
            }
            this.logger.info("==url==", (Object)(url + ":" + method));
            json = url.indexOf(".json") > 0;
            charset = request.getCharacterEncoding();
        }
        if (null != request && null != handler) {
            boolean jsonFlag;
            AuthCheck authCheck = new AuthCheck();
            authCheck.setAppKey(ServletMain.getAppKey());
            authCheck.setAppName(ServletMain.getAppName());
            authCheck.setMethod(method);
            authCheck.setUrl(url);
            authCheck.setContextPath(contextPath);
            authCheck.setUserSession(userSession);
            AuthBean authBean = this.authService.check(authCheck);
            request.getSession().setAttribute(res_sesskey, (Object)authBean);
            String redurl = URLEncoder.encode(contextPath + url);
            boolean bl = jsonFlag = json || app || StringUtils.isNotBlank((String)requestType);
            if (null == authBean) {
                request.getSession().setAttribute(UP_URL, (Object)redurl);
                this.logger.error(this.sys_code + ".preHandle", (Object)(url + ":" + method + " authBean is null"));
                if (jsonFlag) {
                    this.sendRedirect(request, response, charset, jsonFlag, JsonUtil.buildNormalBinder().toJson((Object)new HtmlJsonReBean("noresource", "\u8d44\u6e90\u4e0d\u5b58\u5728")));
                } else {
                    this.sendRedirect(request, response, charset, jsonFlag, contextPath + "/web/mi/mlogin/noresource?redirectURL=" + redurl);
                }
                return false;
            }
            if (AuthBean.anthFlag_nr == authBean.getFlag()) {
                request.getSession().setAttribute(UP_URL, (Object)redurl);
                this.logger.debug(this.sys_code + ".preHandle", (Object)(url + ":" + method + " is no resource"));
                if (jsonFlag) {
                    this.sendRedirect(request, response, charset, jsonFlag, JsonUtil.buildNormalBinder().toJson((Object)new HtmlJsonReBean("noresource", "\u8d44\u6e90\u4e0d\u5b58\u5728")));
                } else {
                    this.sendRedirect(request, response, charset, jsonFlag, contextPath + "/web/mi/mlogin/noresource?redirectURL=" + redurl);
                }
                return false;
            }
            if (AuthBean.anthFlag_nl == authBean.getFlag()) {
                request.getSession().setAttribute(UP_URL, (Object)redurl);
                this.logger.debug(this.sys_code + ".preHandle", (Object)(url + ":" + method + " is no login"));
                if (jsonFlag) {
                    this.sendRedirect(request, response, charset, jsonFlag, JsonUtil.buildNormalBinder().toJson((Object)new HtmlJsonReBean("nologin", "\u8bf7\u91cd\u65b0\u767b\u5f55")));
                } else {
                    this.sendRedirect(request, response, charset, jsonFlag, contextPath + "/web/mi/mlogin/login?redirectURL=" + redurl);
                }
                return false;
            }
            if (AuthBean.anthFlag_np == authBean.getFlag()) {
                request.getSession().setAttribute(UP_URL, (Object)redurl);
                this.logger.debug(this.sys_code + ".preHandle", (Object)("(" + userCode + ")" + url + ":" + method + " is no permisson"));
                if (jsonFlag) {
                    this.sendRedirect(request, response, charset, jsonFlag, JsonUtil.buildNormalBinder().toJson((Object)new HtmlJsonReBean("noper", "\u6ca1\u6709\u6743\u9650")));
                } else {
                    this.sendRedirect(request, response, charset, jsonFlag, contextPath + "/web/mi/mlogin/noper?redirectURL=" + redurl);
                }
                return false;
            }
        } else {
            this.logger.error(this.sys_code + ".preHandle", (Object)(url + " request is null"));
            return false;
        }
        String rebackUrl = request.getParameter("redirectURL");
        if (StringUtils.isNotBlank((String)rebackUrl) && userSession != null) {
            userSession.setRedirectURL(rebackUrl);
        }
        return true;
    }

    private void sendRedirect(HttpServletRequest request, HttpServletResponse response, String charset, boolean json, String msg) {
        if (null == response) {
            return;
        }
        if (json) {
            response.addHeader("Access-Control-Allow-Origin", "*");
            response.setContentType("text/json; charset=" + charset);
            try {
                response.getWriter().print(msg);
            }
            catch (Exception e) {
                this.logger.error(this.sys_code + ".sendRedirect.json", (Object)msg, (Throwable)e);
            }
        } else {
            try {
                PrintWriter out = response.getWriter();
                out.println("<html>");
                out.println("<script>");
                out.println("window.open('" + this.getRequestservice(request) + msg + "','_top')");
                out.println("</script>");
                out.println("</html>");
            }
            catch (Exception e) {
                this.logger.error(this.sys_code + ".sendRedirect.url", (Object)msg, (Throwable)e);
            }
        }
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        AuthBean authBean;
        request.setAttribute("path_servername", (Object)this.getRequestservice(request));
        request.setAttribute("sysAppContextPath", (Object)request.getContextPath());
        if (null != modelAndView && null != request && null != (authBean = (AuthBean)request.getSession().getAttribute(res_sesskey)) && null != authBean.getResBean()) {
            modelAndView.addObject("HtmlTitle", (Object)authBean.getResBean().getMenuName());
        }
    }

    private String getRequestservice(HttpServletRequest request) {
        int port = request.getServerPort();
        String schemeStr = ResourceUtil.getIn((String)"laser", (String)"app.scheme");
        schemeStr = StringUtils.isBlank((String)schemeStr) ? "http" : schemeStr;
        String str = schemeStr + "://" + request.getServerName();
        if (port != 80) {
            str = str + ":" + port;
        }
        return str;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        request.getSession().removeAttribute(res_sesskey);
        if (null != ex) {
            this.logger.error((Throwable)ex);
        }
    }

    public static void main(String[] args) throws Exception {
        URL url = new URL("https://www.bestbeijia.com");
        URI uri = url.toURI();
        System.out.println(uri.getScheme());
    }
}

