/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.ulogin.controller;

import com.yqbsoft.laser.html.common.send.PostParamMap;
import com.yqbsoft.laser.html.common.util.CookieUtil;
import com.yqbsoft.laser.html.common.util.ResourceUtil;
import com.yqbsoft.laser.html.core.auth.UserSession;
import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.core.util.HtmlUtil;
import com.yqbsoft.laser.html.facade.ar.repository.OsLoginRepository;
import com.yqbsoft.laser.html.facade.ar.repository.RdrandomRepository;
import com.yqbsoft.laser.html.facade.bm.datadictionary.repository.DdFalgSettingRepository;
import com.yqbsoft.laser.html.facade.est.project.bean.ProjectReBean;
import com.yqbsoft.laser.html.facade.est.project.repository.PtProjectRepository;
import com.yqbsoft.laser.html.facade.est.repository.TeamRepository;
import com.yqbsoft.laser.html.facade.um.bean.TmRolePermission;
import com.yqbsoft.laser.html.facade.um.bean.UmUser;
import com.yqbsoft.laser.html.facade.um.bean.UserBean;
import com.yqbsoft.laser.html.facade.um.repository.RolePermissionRepository;
import com.yqbsoft.laser.html.facade.um.repository.TmTenantRepository;
import com.yqbsoft.laser.html.facade.um.repository.UserRepository;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.html.ulogin.bean.TmTenant;
import com.yqbsoft.laser.html.ulogin.bean.UserLoginInfo;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.BrowTypeUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MD5Util;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jsoup.helper.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/mi/mlogin"})
public class UloginCon
extends SpringmvcController {
    private static String CODE = "um.ulogin.con";
    private static String Tokenkey = "tokenkey";
    @Resource
    private RdrandomRepository rdrandomRepository;
    @Resource
    private UserRepository userRepository;
    @Resource
    private TmTenantRepository tmTenantRepository;
    @Resource
    private TeamRepository teamRepository;
    @Resource
    private PtProjectRepository ptProjectRepository;
    @Resource
    private DdFalgSettingRepository ddFalgSettingRepository;
    @Autowired
    private RolePermissionRepository RolePermissionRepository;
    @Autowired
    private OsLoginRepository osLoginRepository;

    protected String getContext() {
        return "ulogin";
    }

    public String queryTenantPermission(UserSession userSession) {
        String tenantCode = userSession.getTenantCode();
        String appCodes = "";
        List permissionList = this.RolePermissionRepository.queryPermissionByTenantCode(tenantCode, "0");
        if (permissionList != null && !permissionList.isEmpty()) {
            for (TmRolePermission tmRolePermissionDomain : permissionList) {
                String appmanageIcode = tmRolePermissionDomain.getAppmanageIcode();
                if (appCodes.indexOf(appmanageIcode) > -1) continue;
                appCodes = StringUtil.isBlank((String)appCodes) ? appmanageIcode : appCodes + "," + appmanageIcode;
            }
        }
        if (StringUtil.isBlank((String)appCodes)) {
            appCodes = "devucenter,devoperate";
        }
        this.reloadUserSession(userSession.getTicketTokenid(), "appIcodes", appCodes);
        return null;
    }

    @RequestMapping(value={"noresource"})
    public String noresource(HttpServletRequest request, ModelMap map, String redirectURL) {
        map.addAttribute("redirectURL", (Object)redirectURL);
        return this.getFtlTempPath(request) + "noresource";
    }

    @RequestMapping(value={"noper"})
    public String noper(HttpServletRequest request, ModelMap map, String redirectURL) {
        map.addAttribute("redirectURL", (Object)redirectURL);
        return this.getFtlTempPath(request) + "noper";
    }

    @RequestMapping(value={"login"})
    public String login(HttpServletRequest request, ModelMap map, String redirectURL) {
        map.addAttribute("redirectURL", (Object)redirectURL);
        map.addAttribute("appName", (Object)ServletMain.getAppName());
        return this.getFtlTempPath(request) + "login";
    }

    @RequestMapping(value={"regist"})
    public String regist(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "regist";
    }

    @RequestMapping(value={"checkPhone.json"})
    @ResponseBody
    public HtmlJsonReBean checkphone(HttpServletRequest request, String phone) {
        String tenantCode = ResourceUtil.getOut((String)"laser", (String)"", (String)"tenantCode");
        PostParamMap pmap = new PostParamMap("um.user.getUserByName");
        pmap.putParam("userName", (Object)phone);
        pmap.putParam("tenantCode", (Object)tenantCode);
        com.yqbsoft.laser.html.ulogin.bean.UmUser olduser = (com.yqbsoft.laser.html.ulogin.bean.UmUser)this.htmlIBaseService.sendMes(pmap, com.yqbsoft.laser.html.ulogin.bean.UmUser.class);
        if (olduser != null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u624b\u673a\u53f7\u5df2\u6ce8\u518c\uff01");
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"saveRegist.json"})
    @ResponseBody
    public HtmlJsonReBean saveUmUser(HttpServletRequest request, ModelMap map, String phone, String password, String verCode) {
        String tenantCode = ResourceUtil.getOut((String)"laser", (String)"", (String)"tenantCode");
        PostParamMap pmap = new PostParamMap("um.user.getUserByName");
        pmap.putParam("userName", (Object)phone);
        pmap.putParam("tenantCode", (Object)tenantCode);
        com.yqbsoft.laser.html.ulogin.bean.UmUser olduser = (com.yqbsoft.laser.html.ulogin.bean.UmUser)this.htmlIBaseService.sendMes(pmap, com.yqbsoft.laser.html.ulogin.bean.UmUser.class);
        if (olduser != null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u624b\u673a\u53f7\u5df2\u6ce8\u518c\uff01");
        }
        if (StringUtils.isBlank((String)phone) || StringUtils.isBlank((String)password) || StringUtils.isBlank((String)verCode)) {
            this.logger.error(CODE + ".saveUmUser", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        if (!this.checkVerCode("0", phone, verCode, tenantCode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e\uff01");
        }
        com.yqbsoft.laser.html.ulogin.bean.UmUser user = new com.yqbsoft.laser.html.ulogin.bean.UmUser();
        user.setUserName(phone);
        user.setUserPhone(phone);
        user.setUserPwsswd(password);
        user.setTenantCode(tenantCode);
        String defRole = SupDisUtil.getDisCache().getMap("DdFalgSetting-key", tenantCode + "-user-defRole");
        if (StringUtils.isNotBlank((String)defRole)) {
            user.setRoleCode(defRole);
        }
        pmap = new PostParamMap("um.user.saveUmuserAll");
        pmap.putParamToJson("umUserDomainBean", (Object)user);
        user = (com.yqbsoft.laser.html.ulogin.bean.UmUser)this.htmlIBaseService.sendMes(pmap, com.yqbsoft.laser.html.ulogin.bean.UmUser.class);
        map.addAttribute("user", (Object)user);
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"loginIn.json"})
    public ResponseEntity<HtmlJsonReBean> loginIn(HttpServletRequest request, HttpServletResponse response, String loginName, String passwd, String code, String redirectURL, String tenantCode) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.TEXT_PLAIN);
        if (StringUtils.isBlank((String)loginName) || StringUtils.isBlank((String)passwd)) {
            this.logger.error(CODE + ".loginIn", (Object)"param is null");
            return new ResponseEntity((Object)new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param is null"), (MultiValueMap)headers, HttpStatus.OK);
        }
        if (StringUtils.isBlank((String)(tenantCode = StringUtils.isBlank((String)tenantCode) ? ResourceUtil.getOut((String)"laser", (String)"", (String)"tenantCode") : ResourceUtil.getOut((String)"laser", (String)"", (String)"tenantCode") + "," + tenantCode))) {
            this.logger.error("laser.properties tenantCode missing \u5e94\u7528\u914d\u7f6e\u79df\u6237code\u914d\u7f6e\u7f3a\u5931");
            return new ResponseEntity((Object)new HtmlJsonReBean("error", "\u79df\u6237Code\u7f3a\u5931\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d"), (MultiValueMap)headers, HttpStatus.OK);
        }
        String browType = BrowTypeUtil.getBrowType((String)request.getHeader("User-Agent"));
        Map<String, Object> result = this.executeLogin(loginName, passwd, tenantCode, browType);
        if (!((Boolean)result.get("flag")).booleanValue()) {
            return new ResponseEntity((Object)new HtmlJsonReBean(CODE + ".loginIn.no", result.get("message").toString()), (MultiValueMap)headers, HttpStatus.OK);
        }
        UserSession userSession = (UserSession)JsonUtil.getAllJsonUtil().getJsonToObject(result.get("session").toString(), UserSession.class);
        this.setUserSession(request, userSession);
        String group = SupDisUtil.getMap((String)"osconfig_key", (String)ServletMain.getAppName());
        CookieUtil.CreateCook((HttpServletResponse)response, (String)Tokenkey, (String)userSession.getTicketTokenid(), (String)group);
        SupDisUtil.set((String)"initLoginFlag", (String)"true");
        return new ResponseEntity((Object)new HtmlJsonReBean((Object)redirectURL), (MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(value={"getRegistrationID.json"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseBody
    public HtmlJsonReBean getRegistrationID(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (param != null && param.get("registrationID") != null) {
            PostParamMap pmap = new PostParamMap("imsg.imsg.clearOtherRegistrationID");
            param.put("userCode", userSession.getUserCode());
            param.put("appmanageIcode", ServletMain.getAppName());
            pmap.putParamToJson("map", (Object)param);
            this.htmlIBaseService.sendMesReBeanInAsync(pmap);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"handLoginOut.json"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseBody
    public HtmlJsonReBean handLoginOut(HttpServletRequest request, String userName, String browType, String tenantCode) {
        this.osLoginRepository.handLoginOut(userName, browType, tenantCode, ServletMain.getAppName());
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"loginToken.json"})
    @ResponseBody
    public HtmlJsonReBean loginToken(HttpServletRequest request, HttpServletResponse response, @RequestBody com.yqbsoft.laser.html.ulogin.bean.UmUser umUser) {
        return this.loginProcess(request, response, umUser);
    }

    public HtmlJsonReBean loginProcess(HttpServletRequest request, HttpServletResponse response, com.yqbsoft.laser.html.ulogin.bean.UmUser umUser) {
        Map map3;
        Map company;
        String loginName = umUser.getLoginName();
        String passwd = umUser.getPasswd();
        String loginTenantCode = umUser.getTenantCode();
        String verCode = umUser.getVerCode();
        String tenantCode = ResourceUtil.getOut((String)"laser", (String)"", (String)"tenantCode");
        String phoneValid = ResourceUtil.getOut((String)"laser", (String)"", (String)"phoneValid");
        String loginType = umUser.getLoginType();
        if (StringUtils.isBlank((String)loginTenantCode)) {
            loginTenantCode = ResourceUtil.getOut((String)"laser", (String)"", (String)"apptenantCode");
        }
        if (loginType != null && "pwd".equals(loginType)) {
            if (StringUtils.isBlank((String)loginName) || StringUtils.isBlank((String)passwd) || StringUtils.isBlank((String)loginTenantCode)) {
                this.logger.error(CODE + ".loginIn", (Object)"param is null");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u767b\u5f55\u53c2\u6570\u4e3a\u7a7a");
            }
            loginType = "1";
        } else if (loginType == null || "verCode".equals(loginType)) {
            if (StringUtils.isBlank((String)loginName) || StringUtils.isBlank((String)verCode) || StringUtils.isBlank((String)loginTenantCode)) {
                this.logger.error(CODE + ".loginIn", (Object)"param is null");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u767b\u5f55\u53c2\u6570\u4e3a\u7a7a");
            }
            if ((phoneValid == null || Boolean.valueOf(phoneValid).booleanValue()) && !this.checkVerCode("0", loginName, verCode, tenantCode)) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e\uff01");
            }
            loginType = "2";
        } else {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u77e5\u7684\u767b\u9646\u65b9\u5f0f\uff01");
        }
        String browType = BrowTypeUtil.getBrowType((String)request.getHeader("User-Agent"));
        tenantCode = tenantCode + "," + loginTenantCode;
        Map<String, Object> result = this.executeLogin(loginName, passwd, tenantCode, browType, loginType);
        if (!((Boolean)result.get("flag")).booleanValue()) {
            return new HtmlJsonReBean(CODE + ".loginIn.no", result.get("message").toString());
        }
        UserSession userSession = (UserSession)JsonUtil.getAllJsonUtil().getJsonToObject(result.get("session").toString(), UserSession.class);
        this.setUserSession(request, userSession);
        String group = SupDisUtil.getMap((String)"osconfig_key", (String)ServletMain.getAppName());
        CookieUtil.CreateCook((HttpServletResponse)response, (String)Tokenkey, (String)userSession.getTicketTokenid(), (String)group);
        PostParamMap pmap = null;
        List teams = (List)this.getTeamCode(pmap, userSession.getUserCode());
        String teamCode = "";
        String teamName = "";
        String companyCode = "";
        String companyName = "";
        if (ListUtil.isNotEmpty((Collection)teams)) {
            for (Map team : teams) {
                if (team.get("teamCode") == null || "".equals(team.get("teamCode"))) continue;
                teamCode = (String)team.get("teamCode");
                teamName = (String)team.get("teamName");
                companyCode = (String)team.get("companyCode");
                break;
            }
        }
        if (MapUtil.isNotEmpty((Map)(company = (Map)this.getCompanyCode(pmap, companyCode)))) {
            companyName = (String)company.get("companyName");
        }
        pmap = new PostParamMap("pt.project.queryByUserCode");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userCode", userSession.getUserCode());
        param.put("dataState", "0");
        param.put("teamCode", teamCode);
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("userCode", userSession.getUserCode());
        map2.put("queryParentTeam", "1");
        String[] teamInfo = this.teamRepository.getTeamInfo(map2);
        String teamCodeParent = "";
        if (teamInfo != null && teamInfo.length > 0 && teamInfo[0] != null && teamCode.equals(teamCodeParent = teamInfo[0])) {
            teamCodeParent = "";
        }
        HashSet<Object> repeatProjectCodes = new HashSet<Object>();
        param.put("tenantCode", loginTenantCode);
        pmap.putParamToJson("map", param);
        List projects = (List)this.htmlIBaseService.senBySupRq(pmap, new HashMap());
        String project = "";
        String projectCode = "";
        if (projects != null && projects.size() > 0) {
            Iterator i$ = projects.iterator();
            if (i$.hasNext()) {
                map3 = (Map)i$.next();
                projectCode = (String)map3.get("PROJECT_CODE");
                project = (String)map3.get("PROJECT_NAME");
            }
            for (Map map3 : projects) {
                repeatProjectCodes.add(map3.get("PROJECT_CODE"));
            }
        }
        String areaCode = "";
        map3 = new HashMap<String, String>();
        map3.put("projectCode", projectCode);
        map3.put("tenantCode", loginTenantCode);
        ProjectReBean projectReBean = this.ptProjectRepository.getProjectByCode(map3);
        if (projectReBean != null) {
            areaCode = projectReBean.getAreaCode();
        }
        UserLoginInfo uli = new UserLoginInfo();
        try {
            BeanUtils.copyAllPropertys((Object)uli, (Object)userSession);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        uli.setProject(project);
        uli.setProjectCode(projectCode);
        uli.setTeamName(teamName);
        uli.setTeamCode(teamCode);
        uli.setCompanyCode(companyCode);
        uli.setCompanyName(companyName);
        uli.setTeamCodeParent(teamCodeParent);
        uli.setAreaCode(areaCode);
        uli.setUserId(userSession.getUserId());
        uli.setRepeatProjectCodes(repeatProjectCodes);
        return new HtmlJsonReBean((Object)uli);
    }

    private Map<String, Object> executeLogin(String loginName, String passwd, String tenantCode, String browType) {
        PostParamMap pmap = new PostParamMap("os.oauthserver.validateLogin");
        pmap.putParam("userName", (Object)loginName);
        pmap.putParam("userPasswd", (Object)passwd);
        pmap.putParam("browType", (Object)browType);
        pmap.putParam("appmanageIcode", (Object)ServletMain.getAppName());
        pmap.putParam("tenantCode", (Object)tenantCode);
        Map result = (Map)this.htmlIBaseService.senReObject(pmap, Map.class);
        return result;
    }

    private Map<String, Object> executeLogin(String loginName, String passwd, String tenantCode, String browType, String loginType) {
        PostParamMap pmap = new PostParamMap("os.oauthserver.validateLoginByAll");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userName", loginName);
        map.put("userPasswd", passwd);
        map.put("browType", browType);
        map.put("appmanageIcode", ServletMain.getAppName());
        map.put("tenantCode", tenantCode);
        map.put("loginType", loginType);
        pmap.putParamToJson("map", map);
        Map result = (Map)this.htmlIBaseService.senReObject(pmap, Map.class);
        return result;
    }

    @RequestMapping(value={"loginOut.json"})
    @ResponseBody
    public HtmlJsonReBean loginOut(HttpServletRequest request, HttpServletResponse response) {
        String loginUrl;
        this.setUserSession(request, null);
        String appName = ServletMain.getAppName();
        String group = SupDisUtil.getMap((String)"osconfig_key", (String)appName);
        String token = "";
        String tenantCode = "";
        if (null != request.getCookies()) {
            Cookie[] cookies;
            for (Cookie cookie : cookies = request.getCookies()) {
                if (!cookie.getName().equalsIgnoreCase(Tokenkey + "-" + group)) continue;
                token = cookie.getValue();
            }
        }
        tenantCode = ResourceUtil.getOut((String)"laser", (String)"", (String)"tenantCode");
        String browType = BrowTypeUtil.getBrowType((String)request.getHeader("User-Agent"));
        PostParamMap pmap = new PostParamMap("os.oauthserver.LoginOut");
        pmap.putParam("oauthTokenToken", (Object)token);
        pmap.putParam("browType", (Object)browType);
        pmap.putParam("tenantCode", (Object)tenantCode);
        pmap.putParam("appmanageIcode", (Object)appName);
        this.htmlIBaseService.sendMesReJson(pmap);
        CookieUtil.CreateCook((HttpServletResponse)response, (String)Tokenkey, null, (String)group);
        if (!"devucenter".equals(appName)) {
            appName = "devlogin";
        }
        if (ResourceUtil.getAll((String)"laser", (String)"", (String)"test").equals("true")) {
            appName = ServletMain.getAppName();
            appName = "yqbsoft-app-wallet-html-" + appName;
        }
        if (StringUtils.isNotBlank((String)(loginUrl = CookieUtil.getCookie((HttpServletRequest)request, (String)"loginUrl", (String)group)))) {
            appName = loginUrl;
            CookieUtil.CreateCook((HttpServletResponse)response, (String)"loginUrl", null, (String)group);
        }
        return new HtmlJsonReBean((Object)appName);
    }

    @RequestMapping(value={"getVerCode"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseBody
    public HtmlJsonReBean getVerCode(HttpServletRequest request) {
        String host;
        String businessType;
        Map random;
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (param == null || param.get("businessType") == null || param.get("userPhone") == null || param.get("type") == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u83b7\u53d6\u5230\u624b\u673a\u53f7");
        }
        param.put("tenantCode", this.getTenantCode(request));
        UmUser user = this.userRepository.getUserByNameOrPhone(param);
        if ("1".equals(param.get("type"))) {
            if (user == null) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u624b\u673a\u53f7\u6709\u8bef,\u8bf7\u91cd\u65b0\u8f93\u5165");
            }
        } else if ("2".equals(param.get("type")) && user != null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u624b\u673a\u53f7\u5df2\u5b58\u5728,\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        if (!((Boolean)(random = this.rdrandomRepository.getRandom(businessType = (String)param.get("businessType"), host = (String)param.get("userPhone"), ServletMain.getAppName(), this.getTenantCode(request))).get("flag")).booleanValue()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, random.get("message").toString());
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"checkVerCode"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseBody
    public HtmlJsonReBean checkVerCode(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (param == null || param.get("verCode") == null || param.get("userPhone") == null || param.get("businessType") == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u83b7\u53d6\u5230\u9a8c\u8bc1\u53c2\u6570");
        }
        if (!this.checkVerCode(param, this.getTenantCode(request))) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e\uff01");
        }
        return new HtmlJsonReBean();
    }

    private boolean checkVerCode(Map<String, Object> param, String tenantCode) {
        String businessType = (String)param.get("businessType");
        String host = (String)param.get("userPhone");
        String verCode = (String)param.get("verCode");
        Map result_code = this.rdrandomRepository.check(businessType, host, tenantCode, verCode);
        return (Boolean)result_code.get("flag");
    }

    @RequestMapping(value={"updateUserPhone"}, produces={"application/json"}, method={RequestMethod.POST})
    @ResponseBody
    public HtmlJsonReBean updateUserPhone(HttpServletRequest request) {
        UserSession user = this.getUserSession(request);
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (param == null || param.get("verCode") == null || param.get("userPhone") == null || param.get("businessType") == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u83b7\u53d6\u5230\u9a8c\u8bc1\u53c2\u6570\uff01");
        }
        if (!this.checkVerCode(param, this.getTenantCode(request))) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e\uff01");
        }
        Map map = new HashMap<String, String>();
        map.put("oldUserPhone", user.getUserPhone());
        map.put("tenantCode", this.getTenantCode(request));
        map.put("newUserPhone", param.get("userPhone"));
        map.put("needSFFlow", "1");
        map = this.userRepository.updateUserPhoneByOldUserPhone(map);
        if (!((Boolean)map.get("successFlag")).booleanValue()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4fee\u6539\u5931\u8d25\uff01");
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"getVerCode.img"}, produces={"application/json"})
    @ResponseBody
    public HtmlJsonReBean getVerCode(HttpServletRequest request, String phone) {
        String tenantCode = request.getParameter("tenantCode");
        if (StringUtils.isBlank((String)tenantCode)) {
            tenantCode = ResourceUtil.getOut((String)"laser", (String)"", (String)"tenantCode");
        }
        PostParamMap pmap = new PostParamMap("rd.random.createRandom");
        pmap.putParam("businessType", (Object)0);
        pmap.putParam("host", (Object)phone);
        pmap.putParam("app_id", (Object)ServletMain.getAppName());
        pmap.putParam("tenantCode", (Object)tenantCode);
        Map result = (Map)this.htmlIBaseService.sendMes(pmap, Map.class);
        if (((Boolean)result.get("flag")).booleanValue()) {
            return new HtmlJsonReBean();
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, result.get("message").toString());
    }

    private boolean checkVerCode(String businessType, String host, String verCode, String tenantCode) {
        PostParamMap pmap_verCode = new PostParamMap("rd.random.executeRandomValidity");
        pmap_verCode.putParam("businessType", (Object)businessType);
        pmap_verCode.putParam("host", (Object)host);
        pmap_verCode.putParam("random", (Object)verCode);
        pmap_verCode.putParam("app_id", (Object)ServletMain.getAppName());
        pmap_verCode.putParam("tenantCode", (Object)tenantCode);
        Map result_code = (Map)this.htmlIBaseService.senReObject(pmap_verCode, Map.class);
        return (Boolean)result_code.get("flag");
    }

    @RequestMapping(value={"findPassword"})
    public String findPassword(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "findPassword";
    }

    @RequestMapping(value={"getUmUserByLoginName.json"})
    @ResponseBody
    public HtmlJsonReBean getUmUserByLoginName(HttpServletRequest request, String loginName, String userPhone) {
        if (StringUtils.isBlank((String)loginName) && StringUtils.isBlank((String)userPhone)) {
            this.logger.error(CODE + ".getUmUserByLoginName", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7528\u6237\u540d\u4e3a\u7a7a");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)loginName)) {
            map.put("userName", loginName);
        } else if (StringUtils.isNotBlank((String)userPhone)) {
            map.put("userPhone", userPhone);
        }
        List users = (List)this.userRepository.queryUserList(map);
        if (ListUtil.isNotEmpty((Collection)users) && users.size() > 0) {
            ArrayList retMaps = new ArrayList();
            List list = null;
            Map tmtenant = SupDisUtil.getMapAll((String)"tmtenant");
            if (tmtenant.containsKey("list")) {
                String tmlistStr = (String)tmtenant.get("list");
                list = (List)JsonUtil.buildNormalBinder().getJsonToList(tmlistStr, TmTenant.class);
            }
            String sysTenantCode = ResourceUtil.getOut((String)"laser", (String)"", (String)"tenantCode");
            if (users.size() == 1) {
                HashMap<String, String> retMap = new HashMap<String, String>();
                UserBean user = (UserBean)users.get(0);
                String userPcode = user.getUserPcode();
                String tenantCode = user.getTenantCode();
                Integer type = 1;
                if (!sysTenantCode.equals(tenantCode)) {
                    userPcode = tenantCode;
                    type = 2;
                }
                String[] tmInfo = this.getTmInfo(list, userPcode, type);
                String userinfoCompname = tmInfo[1];
                retMap.put("userRelname", user.getUserRelname());
                retMap.put("tenantCode", tenantCode);
                retMap.put("userinfoCompname", userinfoCompname);
                retMaps.add(retMap);
            } else {
                for (UserBean user : users) {
                    String tenantCode = user.getTenantCode();
                    String userPcode = user.getUserPcode();
                    Integer type = 1;
                    if (!sysTenantCode.equals(tenantCode)) {
                        userPcode = tenantCode;
                        type = 2;
                    }
                    String[] tmInfo = this.getTmInfo(list, userPcode, type);
                    String userinfoCompname = tmInfo[1];
                    HashMap<String, String> retMap = new HashMap<String, String>();
                    retMap.put("userRelname", user.getUserRelname());
                    retMap.put("tenantCode", tenantCode);
                    retMap.put("userinfoCompname", userinfoCompname);
                    retMaps.add(retMap);
                }
            }
            return new HtmlJsonReBean(retMaps);
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u67e5\u8be2\u5230\u6709\u591a\u4e2a\u7528\u6237\u5b58\u5728");
    }

    private String[] getTmInfo(List<TmTenant> list, String userPcode, Integer type) {
        String[] str = new String[2];
        for (TmTenant temp : list) {
            String tenantCompname;
            String tenantOpuser = temp.getTenantOpuser();
            String tenantCode = temp.getTenantCode();
            if (type == 1) {
                if (!StringUtils.isNotBlank((String)tenantOpuser) || !tenantOpuser.equals(userPcode)) continue;
                str[0] = temp.getTenantCode();
                tenantCompname = temp.getTenantCompname();
                if (StringUtils.isBlank((String)tenantCompname)) {
                    tenantCompname = "";
                }
                str[1] = tenantCompname;
                continue;
            }
            if (!StringUtils.isNotBlank((String)tenantCode) || !tenantCode.equals(userPcode)) continue;
            str[0] = temp.getTenantCode();
            tenantCompname = temp.getTenantCompname();
            if (StringUtils.isBlank((String)tenantCompname)) {
                tenantCompname = "";
            }
            str[1] = tenantCompname;
        }
        return str;
    }

    @RequestMapping(value={"getUserByName.json"})
    @ResponseBody
    public HtmlJsonReBean getUmserByName(HttpServletRequest request, String phone) {
        if (StringUtils.isBlank((String)phone)) {
            this.logger.error(CODE + ".loginIn", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u624b\u673a\u53f7\u7801\u4e3a\u7a7a");
        }
        PostParamMap pmap = new PostParamMap("um.user.getUserByName");
        pmap.putParam("userName", (Object)phone);
        com.yqbsoft.laser.html.ulogin.bean.UmUser user = (com.yqbsoft.laser.html.ulogin.bean.UmUser)this.htmlIBaseService.sendMes(pmap, com.yqbsoft.laser.html.ulogin.bean.UmUser.class);
        if (user == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u624b\u673a\u53f7\u7801\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f");
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"findNewPassword"})
    public String findNewPassword(HttpServletRequest request, String phone, String tenantCode) {
        request.setAttribute("phone", (Object)phone);
        if (StringUtils.isNotBlank((String)tenantCode)) {
            request.setAttribute("tenantCode", (Object)tenantCode);
        }
        return this.getFtlTempPath(request) + "findNewPassword";
    }

    @RequestMapping(value={"upadtePassword.json"})
    @ResponseBody
    public HtmlJsonReBean upadtePassword(HttpServletRequest request, String phone, String verCode, String password, String tenantCode) {
        if (StringUtils.isBlank((String)phone)) {
            this.logger.error(CODE + ".loginIn", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u624b\u673a\u53f7\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(CODE + ".upadtePassword.json", (Object)"\u83b7\u53d6\u79df\u6237\u4e3a\u7a7a");
            tenantCode = ResourceUtil.getOut((String)"laser", (String)"", (String)"tenantCode");
        }
        PostParamMap pmap = new PostParamMap("um.user.getUserByName");
        pmap.putParam("userName", (Object)phone);
        pmap.putParam("tenantCode", (Object)tenantCode);
        com.yqbsoft.laser.html.ulogin.bean.UmUser user = (com.yqbsoft.laser.html.ulogin.bean.UmUser)this.htmlIBaseService.sendMes(pmap, com.yqbsoft.laser.html.ulogin.bean.UmUser.class);
        if (user == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7528\u6237\u67e5\u8be2\u9519\u8bef\uff01");
        }
        if (this.checkVerCode("0", phone, verCode, ResourceUtil.getOut((String)"laser", (String)"", (String)"tenantCode"))) {
            pmap = new PostParamMap("um.user.updateUserPwsswd");
            pmap.putParam("userId", (Object)user.getUserId());
            pmap.putParam("userPwsswd", (Object)password);
            return this.htmlIBaseService.sendMesReBean(pmap);
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
    }

    @RequestMapping(value={"updatePasswordToken.json"})
    @ResponseBody
    public HtmlJsonReBean upadtePassword(HttpServletRequest request, @RequestBody com.yqbsoft.laser.html.ulogin.bean.UmUser user) {
        UserSession userSession = this.getUserSession(request);
        if (user == null) {
            this.logger.error(CODE + ".loginIn", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8f93\u5165\u53c2\u6570\u4e3a\u7a7a");
        }
        PostParamMap pmap = new PostParamMap("um.user.getUserByName");
        pmap.putParam("userName", (Object)userSession.getUserName());
        com.yqbsoft.laser.html.ulogin.bean.UmUser queryUser = (com.yqbsoft.laser.html.ulogin.bean.UmUser)this.htmlIBaseService.sendMes(pmap, com.yqbsoft.laser.html.ulogin.bean.UmUser.class);
        if (MD5Util.saltMD5Verify((String)user.getPasswd(), (String)queryUser.getUserPwsswd())) {
            pmap = new PostParamMap("um.user.updateUserPwsswd");
            pmap.putParam("userId", (Object)queryUser.getUserId());
            pmap.putParam("userPwsswd", (Object)user.getNewPasswd());
            return this.htmlIBaseService.sendMesReBean(pmap);
        }
        this.logger.error(CODE + ".updatePasswordToken", (Object)"not match the old password");
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u539f\u5bc6\u7801\u9519\u8bef");
    }

    @RequestMapping(value={"regenerateApp.json"})
    @ResponseBody
    public HtmlJsonReBean regenerateApp(HttpServletRequest request, String key) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (StringUtils.isEmpty((String)key) || param == null) {
            this.logger.error(CODE + ".regenerateApp", (Object)"\u83b7\u53d6\u66f4\u65b0\u5931\u8d25\uff0c\u672a\u4f20\u5165code\u503c");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u83b7\u53d6\u66f4\u65b0\u5931\u8d25");
        }
        param.put("flagSettingCode", key);
        param.put("tenantCode", this.getTenantCode());
        Map ddFalg = this.ddFalgSettingRepository.getFalgSetting(param);
        param.clear();
        param.put("appUrl", ddFalg.get("FLAG_SETTING_INFO"));
        param.put("appSize", ddFalg.get("FLAG_SETTING_PRO"));
        param.put("forceUpgrade", ddFalg.get("FLAG_SETTING_PRO1"));
        param.put("version", ddFalg.get("FLAG_SETTING_PRO2"));
        param.put("appDesc", ddFalg.get("MEMO"));
        return new HtmlJsonReBean((Object)param);
    }

    @RequestMapping(value={"getSession.json"})
    @ResponseBody
    public HtmlJsonReBean getSession(HttpServletRequest request) {
        UserSession user = this.getUserSession(request);
        if (user == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "");
        }
        return new HtmlJsonReBean((Object)user);
    }

    @RequestMapping(value={"getMbuserInfo.json"})
    @ResponseBody
    public HtmlJsonReBean getMbuserInfo(HttpServletRequest request) {
        return new HtmlJsonReBean();
    }

    public Object getTeamCode(PostParamMap<String, Object> pmap, String userCode) {
        pmap = new PostParamMap("um.user.queryTeamByUser");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userCode", userCode);
        pmap.putParamToJson("map", param);
        return this.htmlIBaseService.senBySupRq(pmap, new HashMap());
    }

    public Object getCompanyCode(PostParamMap<String, Object> pmap, String companyCode) {
        pmap = new PostParamMap("um.user.getCompanyByCode");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("companyCode", companyCode);
        pmap.putParamToJson("map", param);
        return this.htmlIBaseService.senBySupRq(pmap, new HashMap());
    }
}

