/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pos.baseinfo.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pos.baseinfo.dao.PosBankBinInfMapper;
import com.yqbsoft.laser.service.pos.baseinfo.domain.PosBankBinInfDomain;
import com.yqbsoft.laser.service.pos.baseinfo.model.PosBankBinInf;
import com.yqbsoft.laser.service.pos.baseinfo.service.BankBinInfService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class BankBinInfServiceImpl
extends BaseServiceImpl
implements BankBinInfService {
    public static final String SYS_CODE = "pb.POS.BASEINFO.BankBinInfServiceImpl";
    private PosBankBinInfMapper posBankBinInfMapper;
    private static final String CACHE_KEY = "PbBankBinInf-pro";

    public void setPosBankBinInfMapper(PosBankBinInfMapper posBankBinInfMapper) {
        this.posBankBinInfMapper = posBankBinInfMapper;
    }

    private Date getSysDate() {
        try {
            return this.posBankBinInfMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pb.POS.BASEINFO.BankBinInfServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkBankBinInf(PosBankBinInfDomain posBankBinInfDomain) {
        if (posBankBinInfDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setBankBinInfDefault(PosBankBinInf posBankBinInf) {
        if (posBankBinInf == null) {
            return;
        }
        if (posBankBinInf.getDataState() == null) {
            posBankBinInf.setDataState(0);
        }
        if (posBankBinInf.getGmtCreate() == null) {
            posBankBinInf.setGmtCreate(this.getSysDate());
        }
        posBankBinInf.setGmtModified(this.getSysDate());
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.posBankBinInfMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pb.POS.BASEINFO.BankBinInfServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setBankBinInfUpdataDefault(PosBankBinInf posBankBinInf) {
        if (posBankBinInf == null) {
            return;
        }
        posBankBinInf.setGmtModified(this.getSysDate());
    }

    private void saveBankBinInfModel(PosBankBinInf posBankBinInf) throws ApiException {
        if (posBankBinInf == null) {
            return;
        }
        try {
            this.posBankBinInfMapper.insert(posBankBinInf);
        }
        catch (Exception e) {
            throw new ApiException("pb.POS.BASEINFO.BankBinInfServiceImpl.saveFtpserverModel.ex");
        }
    }

    private PosBankBinInf getBankBinInfModelById(Integer bankBinInfId) {
        if (bankBinInfId == null) {
            return null;
        }
        try {
            return this.posBankBinInfMapper.selectByPrimaryKey(bankBinInfId);
        }
        catch (Exception e) {
            this.logger.error("pb.POS.BASEINFO.BankBinInfServiceImpl.getBankBinInfModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteBankBinInfModel(Integer bankBinInfId) throws ApiException {
        if (bankBinInfId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.posBankBinInfMapper.deleteByPrimaryKey(bankBinInfId);
        }
        catch (Exception e) {
            throw new ApiException("pb.POS.BASEINFO.BankBinInfServiceImpl.deleteBankBinInfModel.ex");
        }
        if (1 != i) {
            throw new ApiException("pb.POS.BASEINFO.BankBinInfServiceImpl.deleteBankBinInfModel.num");
        }
    }

    private void updateBankBinInfModel(PosBankBinInf posBankBinInf) throws ApiException {
        if (posBankBinInf == null) {
            return;
        }
        try {
            this.posBankBinInfMapper.updateByPrimaryKeySelective(posBankBinInf);
        }
        catch (Exception e) {
            throw new ApiException("pb.POS.BASEINFO.BankBinInfServiceImpl.updateBankBinInfModel.ex");
        }
    }

    private void updateStateBankBinInfModel(Integer bankBinInfId, Integer dataState, Integer oldDataState) throws ApiException {
        if (bankBinInfId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bankBinInfId", bankBinInfId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.posBankBinInfMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pb.POS.BASEINFO.BankBinInfServiceImpl.updateStateBankBinInfModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("pb.POS.BASEINFO.BankBinInfServiceImpl.updateStateBankBinInfModel.null");
        }
    }

    private PosBankBinInf makeBankBinInf(PosBankBinInfDomain posBankBinInfDomain, PosBankBinInf posBankBinInf) {
        if (posBankBinInfDomain == null) {
            return null;
        }
        if (posBankBinInf == null) {
            posBankBinInf = new PosBankBinInf();
        }
        try {
            BeanUtils.copyAllPropertys((Object)posBankBinInf, (Object)posBankBinInfDomain);
        }
        catch (Exception e) {
            this.logger.error("pb.POS.BASEINFO.BankBinInfServiceImpl.makeBankBinInf", (Throwable)e);
        }
        return posBankBinInf;
    }

    private List<PosBankBinInf> queryBankBinInfModelPage(Map<String, Object> parammap) {
        try {
            return this.posBankBinInfMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pb.POS.BASEINFO.BankBinInfServiceImpl.queryBankBinInfModel", (Throwable)e);
            return null;
        }
    }

    private int countBankBinInf(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.posBankBinInfMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pb.POS.BASEINFO.BankBinInfServiceImpl.countBankBinInf", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveBankBinInf(PosBankBinInfDomain posBankBinInfDomain) throws ApiException {
        String msg = this.checkBankBinInf(posBankBinInfDomain);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            throw new ApiException("pb.POS.BASEINFO.BankBinInfServiceImpl.saveBankBinInf.checkBankBinInf", msg);
        }
        PosBankBinInf posBankBinInf = this.makeBankBinInf(posBankBinInfDomain, null);
        this.setBankBinInfDefault(posBankBinInf);
        this.saveBankBinInfModel(posBankBinInf);
    }

    @Override
    public void updateBankBinInfState(Integer bankBinInfId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateBankBinInfModel(bankBinInfId, dataState, oldDataState);
        try {
            this.refreshBankBinInfCache(this.getBankBinInf(bankBinInfId), dataState);
        }
        catch (Exception e) {
            this.logger.error("\u5237\u65b0\u7f13\u5b58\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a", (Throwable)e);
            throw new ApiException((Throwable)e);
        }
    }

    private void refreshBankBinInfCache(PosBankBinInf posBankBinInf, Integer dataState) {
        boolean addflag;
        this.logger.info("pb.POS.BASEINFO.BankBinInfServiceImpl.refreshBankBinInfCache", (Object)"\u5237\u65b0\u94f6\u884c\u4fe1\u606f\u7f13\u5b58[PbBankBinInf-pro]\u5f00\u59cb\u3002");
        ArrayList<Map<String, Object>> list = DisUtil.getListJson((String)CACHE_KEY, LinkedHashMap.class);
        if (CollectionUtils.isEmpty((Collection)list)) {
            list = new ArrayList<Map<String, Object>>();
        }
        boolean bl = addflag = dataState == 1;
        if (addflag) {
            this.saveBankBinCache(posBankBinInf, list);
        } else {
            this.deleteBankBinCache(posBankBinInf, list);
        }
        DisUtil.setVer((String)CACHE_KEY, (String)JsonUtil.buildNormalBinder().toJson(list));
        this.logger.info("pb.POS.BASEINFO.BankBinInfServiceImpl.refreshBankBinInfCache", (Object)"\u5237\u65b0\u94f6\u884c\u4fe1\u606f\u7f13\u5b58[PbBankBinInf-pro]\u5b8c\u6210\u3002");
    }

    private List<PosBankBinInf> getBin() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("dataState", 1);
        List<PosBankBinInf> binInfList = this.queryBankBinInfModelPage(paramMap);
        if (CollectionUtils.isEmpty(binInfList)) {
            this.logger.warn("pb.POS.BASEINFO.BankBinInfServiceImpl.getBin", (Object)"\u6ca1\u6709\u542f\u7528\u72b6\u6001\u7684\u94f6\u884c\u4fe1\u606f\uff0c\u4e0d\u9700\u8981\u8bbe\u7f6e\u7f13\u5b58\u3002");
            return binInfList;
        }
        return binInfList;
    }

    private void saveBankBinCache(PosBankBinInf posBankBinInf, List<Map<String, Object>> cardBinList) {
        Integer index = null;
        int i = 0;
        while (i < cardBinList.size()) {
            if (StringUtils.equals((CharSequence)posBankBinInf.getBankBinInfId().toString().trim(), (CharSequence)cardBinList.get(i).get("bankBinInfId").toString().trim())) {
                index = i;
                break;
            }
            ++i;
        }
        String binInfoString = JsonUtil.buildNormalBinder().toJson((Object)posBankBinInf);
        Map binMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(binInfoString, String.class, Object.class);
        if (index == null) {
            cardBinList.add(binMap);
        } else {
            cardBinList.set(index, binMap);
        }
    }

    private void deleteBankBinCache(PosBankBinInf posBankBinInf, List<Map<String, Object>> cardBinList) {
        int i = 0;
        while (i < cardBinList.size()) {
            if (StringUtils.equals((CharSequence)posBankBinInf.getBankBinInfId().toString().trim(), (CharSequence)cardBinList.get(i).get("bankBinInfId").toString().trim())) {
                cardBinList.remove(i);
            }
            ++i;
        }
    }

    @Override
    public void updateBankBinInf(PosBankBinInfDomain posBankBinInfDomain) throws ApiException {
        String msg = this.checkBankBinInf(posBankBinInfDomain);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            throw new ApiException("pb.POS.BASEINFO.BankBinInfServiceImpl.updateBankBinInf.checkBankBinInf", msg);
        }
        PosBankBinInf oldPosBankBinInf = this.getBankBinInfModelById(posBankBinInfDomain.getBankBinInfId());
        if (oldPosBankBinInf == null) {
            throw new ApiException("pb.POS.BASEINFO.BankBinInfServiceImpl.updateBankBinInf.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PosBankBinInf posBankBinInf = this.makeBankBinInf(posBankBinInfDomain, oldPosBankBinInf);
        this.setBankBinInfUpdataDefault(posBankBinInf);
        this.updateBankBinInfModel(posBankBinInf);
    }

    @Override
    public PosBankBinInf getBankBinInf(Integer bankBinInfId) {
        return this.getBankBinInfModelById(bankBinInfId);
    }

    @Override
    public void deleteBankBinInf(Integer bankBinInfId) throws ApiException {
        this.deleteBankBinInfModel(bankBinInfId);
    }

    @Override
    public QueryResult<PosBankBinInf> queryBankBinInfPage(Map<String, Object> map) {
        List<PosBankBinInf> posBankBinInfList = this.queryBankBinInfModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countBankBinInf(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(posBankBinInfList);
        return queryResult;
    }

    @Override
    public void queryBankBinInfCache() {
        this.logger.info("pb.POS.BASEINFO.BankBinInfServiceImpl.queryBankBinInfCache", (Object)"=======\u5237\u65b0\u94f6\u884c\u4fe1\u606f\u7f13\u5b58[PbBankBinInf-pro]\u5f00\u59cb=======");
        List<PosBankBinInf> list = this.getBin();
        if (CollectionUtils.isEmpty(list)) {
            DisUtil.delVer((String)CACHE_KEY);
            this.logger.info("pb.POS.BASEINFO.BankBinInfServiceImpl.queryBankBinInfCache", (Object)"=======\u5237\u65b0\u94f6\u884c\u4fe1\u606f\u7f13\u5b58[PbBankBinInf-pro]\u8c03\u5ea6end-del=======");
            return;
        }
        ArrayList<Map<String, Object>> cardBinList = new ArrayList<Map<String, Object>>();
        for (PosBankBinInf posBankBinInf : list) {
            this.saveBankBinCache(posBankBinInf, cardBinList);
        }
        DisUtil.setVer((String)CACHE_KEY, (String)JsonUtil.buildNormalBinder().toJson(cardBinList));
        this.logger.info("pb.POS.BASEINFO.BankBinInfServiceImpl.queryBankBinInfCache", (Object)"=======\u5237\u65b0\u94f6\u884c\u4fe1\u606f\u7f13\u5b58[PbBankBinInf-pro]\u8c03\u5ea6end=======");
    }
}

