/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pos.baseinfo.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pos.baseinfo.dao.PosCityCodeMapper;
import com.yqbsoft.laser.service.pos.baseinfo.domain.PosCityCodeDomain;
import com.yqbsoft.laser.service.pos.baseinfo.model.PosCityCode;
import com.yqbsoft.laser.service.pos.baseinfo.service.CityCodeService;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CityCodeServiceImpl
extends BaseServiceImpl
implements CityCodeService {
    public static final String SYS_CODE = "pb.POS.BASEINFO.CityCodeServiceImpl";
    public static final Integer CITY_CODE_LENGTH = 4;
    public static final String PROVINCE_MAP_KEY = "0000";
    public static final String CACHECITYCODE_PROVINCE = "CACHE_PROVINCE";
    public static final String CACHECITYCODE_CITY = "CACHE_CITY";
    public static final String CACHECITYCODE_AREA = "CACHE_AREA";
    private PosCityCodeMapper posCityCodeMapper;
    public static final String BEI_JING = "1000";
    public static final String TIAN_JIN = "1100";
    public static final String SHANG_HAI = "2900";
    public static final String CHONG_QING = "6900";
    public static final String QUERY_TYPE_PROVINCE = "0";
    public static final String QUERY_TYPE_CITY = "1";
    public static final String QUERY_TYPE_AREA = "2";
    public static final String QUERY_TYPE_BACK = "3";

    public void setPosCityCodeMapper(PosCityCodeMapper posCityCodeMapper) {
        this.posCityCodeMapper = posCityCodeMapper;
    }

    private Date getSysDate() {
        try {
            return this.posCityCodeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pb.POS.BASEINFO.CityCodeServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCityCode(PosCityCodeDomain posCityCodeDomain) {
        if (posCityCodeDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setCityCodeDefault(PosCityCode posCityCode) {
        if (posCityCode == null) {
            return;
        }
        if (posCityCode.getDataState() == null) {
            posCityCode.setDataState(0);
        }
        if (posCityCode.getGmtCreate() == null) {
            posCityCode.setGmtCreate(this.getSysDate());
        }
        posCityCode.setGmtModified(this.getSysDate());
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.posCityCodeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pb.POS.BASEINFO.CityCodeServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCityCodeUpdataDefault(PosCityCode posCityCode) {
        if (posCityCode == null) {
            return;
        }
        posCityCode.setGmtModified(this.getSysDate());
    }

    private void saveCityCodeModel(PosCityCode posCityCode) throws ApiException {
        if (posCityCode == null) {
            return;
        }
        try {
            this.posCityCodeMapper.insert(posCityCode);
        }
        catch (Exception e) {
            throw new ApiException("pb.POS.BASEINFO.CityCodeServiceImpl.saveFtpserverModel.ex");
        }
    }

    private PosCityCode getCityCodeModelById(Integer cityCodeId) {
        if (cityCodeId == null) {
            return null;
        }
        try {
            return this.posCityCodeMapper.selectByPrimaryKey(cityCodeId);
        }
        catch (Exception e) {
            this.logger.error("pb.POS.BASEINFO.CityCodeServiceImpl.getCityCodeModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteCityCodeModel(Integer cityCodeId) throws ApiException {
        if (cityCodeId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.posCityCodeMapper.deleteByPrimaryKey(cityCodeId);
        }
        catch (Exception e) {
            throw new ApiException("pb.POS.BASEINFO.CityCodeServiceImpl.deleteCityCodeModel.ex");
        }
        if (1 != i) {
            throw new ApiException("pb.POS.BASEINFO.CityCodeServiceImpl.deleteCityCodeModel.num");
        }
    }

    private void updateCityCodeModel(PosCityCode posCityCode) throws ApiException {
        if (posCityCode == null) {
            return;
        }
        try {
            this.posCityCodeMapper.updateByPrimaryKeySelective(posCityCode);
        }
        catch (Exception e) {
            throw new ApiException("pb.POS.BASEINFO.CityCodeServiceImpl.updateCityCodeModel.ex");
        }
    }

    private void updateStateCityCodeModel(Integer cityCodeId, Integer dataState, Integer oldDataState) throws ApiException {
        if (cityCodeId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cityCodeId", cityCodeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.posCityCodeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pb.POS.BASEINFO.CityCodeServiceImpl.updateStateCityCodeModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("pb.POS.BASEINFO.CityCodeServiceImpl.updateStateCityCodeModel.null");
        }
    }

    private PosCityCode makeCityCode(PosCityCodeDomain posCityCodeDomain, PosCityCode posCityCode) {
        if (posCityCodeDomain == null) {
            return null;
        }
        if (posCityCode == null) {
            posCityCode = new PosCityCode();
        }
        try {
            BeanUtils.copyAllPropertys((Object)posCityCode, (Object)posCityCodeDomain);
        }
        catch (Exception e) {
            this.logger.error("pb.POS.BASEINFO.CityCodeServiceImpl.makeCityCode", (Throwable)e);
        }
        return posCityCode;
    }

    private List<PosCityCode> queryCityCodeModelPage(Map<String, Object> parammap) {
        try {
            return this.posCityCodeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pb.POS.BASEINFO.CityCodeServiceImpl.queryCityCodeModel", (Throwable)e);
            return null;
        }
    }

    private int countCityCode(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.posCityCodeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pb.POS.BASEINFO.CityCodeServiceImpl.countCityCode", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveCityCode(PosCityCodeDomain posCityCodeDomain) throws ApiException {
        String msg = this.checkCityCode(posCityCodeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pb.POS.BASEINFO.CityCodeServiceImpl.saveCityCode.checkCityCode", msg);
        }
        PosCityCode posCityCode = this.makeCityCode(posCityCodeDomain, null);
        this.setCityCodeDefault(posCityCode);
        this.saveCityCodeModel(posCityCode);
    }

    @Override
    public void updateCityCodeState(Integer cityCodeId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateCityCodeModel(cityCodeId, dataState, oldDataState);
    }

    @Override
    public void updateCityCode(PosCityCodeDomain posCityCodeDomain) throws ApiException {
        String msg = this.checkCityCode(posCityCodeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pb.POS.BASEINFO.CityCodeServiceImpl.updateCityCode.checkCityCode", msg);
        }
        PosCityCode oldPosCityCode = this.getCityCodeModelById(posCityCodeDomain.getCityCodeId());
        if (oldPosCityCode == null) {
            throw new ApiException("pb.POS.BASEINFO.CityCodeServiceImpl.updateCityCode.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PosCityCode posCityCode = this.makeCityCode(posCityCodeDomain, oldPosCityCode);
        this.setCityCodeUpdataDefault(posCityCode);
        this.updateCityCodeModel(posCityCode);
    }

    @Override
    public PosCityCode getCityCode(Integer cityCodeId) {
        return this.getCityCodeModelById(cityCodeId);
    }

    @Override
    public void deleteCityCode(Integer cityCodeId) throws ApiException {
        this.deleteCityCodeModel(cityCodeId);
    }

    @Override
    public QueryResult<PosCityCode> queryCityCodePage(Map<String, Object> map) {
        List<PosCityCode> posCityCodeList = this.queryCityCodeModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCityCode(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(posCityCodeList);
        return queryResult;
    }

    @Override
    public void queryCityCodeLoadCache() {
        this.info("pb.POS.BASEINFO.CityCodeServiceImpl.queryCityCodeLoadCache", "=====CityCode==start====" + ServletMain.getAppName());
        List<PosCityCodeDomain> cityCodeList = this.posCityCodeMapper.queryForCache();
        ArrayList<String> zhixiashiList = new ArrayList<String>();
        zhixiashiList.add(BEI_JING);
        zhixiashiList.add(TIAN_JIN);
        zhixiashiList.add(SHANG_HAI);
        zhixiashiList.add(CHONG_QING);
        HashMap<String, ArrayList<PosCityCodeDomain>> provinceMap = new HashMap<String, ArrayList<PosCityCodeDomain>>();
        HashMap<String, ArrayList<PosCityCodeDomain>> cityMap = new HashMap<String, ArrayList<PosCityCodeDomain>>();
        HashMap<String, ArrayList<PosCityCodeDomain>> areaMap = new HashMap<String, ArrayList<PosCityCodeDomain>>();
        String allFalg = "*";
        String provinceSuffix = "00";
        String citySuffix = QUERY_TYPE_PROVINCE;
        String provinceCode = null;
        String cityCode = null;
        for (PosCityCodeDomain posCityCodeDomain : cityCodeList) {
            ArrayList<PosCityCodeDomain> areaList;
            ArrayList<PosCityCodeDomain> cityList;
            List<PosCityCodeDomain> provinceList;
            if (StringUtils.isBlank((String)posCityCodeDomain.getCityCode())) {
                this.logger.error("pb.POS.BASEINFO.CityCodeServiceImpl.queryCityCodeLoadCache", (Object)"==\u57ce\u5e02\u4ee3\u7801\u4e3a\u7a7a");
                return;
            }
            if (posCityCodeDomain.getCityCode().equals(allFalg) || posCityCodeDomain.getCityCode().length() != CITY_CODE_LENGTH.intValue()) continue;
            if (zhixiashiList.contains(posCityCodeDomain.getCityCode())) {
                provinceCode = posCityCodeDomain.getCityCode();
                cityCode = posCityCodeDomain.getCityCode();
                provinceList = (ArrayList<PosCityCodeDomain>)provinceMap.get(PROVINCE_MAP_KEY);
                cityList = (ArrayList<PosCityCodeDomain>)cityMap.get(posCityCodeDomain.getCityCode());
                areaList = (List)areaMap.get(posCityCodeDomain.getCityCode());
                if (provinceList != null) {
                    provinceList.add(posCityCodeDomain);
                } else {
                    provinceList = new ArrayList();
                    provinceList.add(posCityCodeDomain);
                    provinceMap.put(PROVINCE_MAP_KEY, (ArrayList<PosCityCodeDomain>)provinceList);
                }
                if (cityList != null) {
                    cityList.add(posCityCodeDomain);
                } else {
                    cityList = new ArrayList();
                    cityList.add(posCityCodeDomain);
                    cityMap.put(provinceCode, cityList);
                }
                if (areaList != null) {
                    areaList.add(posCityCodeDomain);
                    continue;
                }
                areaList = new ArrayList();
                areaList.add(posCityCodeDomain);
                areaMap.put(cityCode, areaList);
                continue;
            }
            if (posCityCodeDomain.getCityCode().substring(2).equals(provinceSuffix)) {
                provinceCode = posCityCodeDomain.getCityCode();
                provinceList = (List)provinceMap.get(PROVINCE_MAP_KEY);
                if (provinceList != null) {
                    provinceList.add(posCityCodeDomain);
                    continue;
                }
                provinceList = new ArrayList<PosCityCodeDomain>();
                provinceList.add(posCityCodeDomain);
                provinceMap.put(PROVINCE_MAP_KEY, (ArrayList<PosCityCodeDomain>)provinceList);
                continue;
            }
            if (posCityCodeDomain.getCityCode().substring(3).equals(citySuffix)) {
                cityCode = posCityCodeDomain.getCityCode();
                if (provinceCode == null) {
                    this.logger.error("pb.POS.BASEINFO.CityCodeServiceImpl.queryCityCodeLoadCache", (Object)"==\u6dfb\u52a0\u5e02\u65f6\uff0c\u7701\u4ee3\u7801\u4e3a\u7a7a");
                    return;
                }
                cityList = (List)cityMap.get(provinceCode);
                if (cityList != null) {
                    cityList.add(posCityCodeDomain);
                    continue;
                }
                cityList = new ArrayList<PosCityCodeDomain>();
                cityList.add(posCityCodeDomain);
                cityMap.put(provinceCode, cityList);
                continue;
            }
            if (cityCode == null) {
                this.logger.error("pb.POS.BASEINFO.CityCodeServiceImpl.queryCityCodeLoadCache", (Object)"==\u6dfb\u52a0\u53bf\u65f6\uff0c\u5e02\u4ee3\u7801\u4e3a\u7a7a");
                return;
            }
            areaList = (ArrayList<PosCityCodeDomain>)areaMap.get(cityCode);
            if (areaList != null) {
                areaList.add(posCityCodeDomain);
                continue;
            }
            areaList = new ArrayList<PosCityCodeDomain>();
            areaList.add(posCityCodeDomain);
            areaMap.put(cityCode, areaList);
        }
        DisUtil.setVer((String)CACHECITYCODE_PROVINCE, (String)JsonUtil.buildNormalBinder().toJson(provinceMap));
        DisUtil.setVer((String)CACHECITYCODE_CITY, (String)JsonUtil.buildNormalBinder().toJson(cityMap));
        DisUtil.setVer((String)CACHECITYCODE_AREA, (String)JsonUtil.buildNormalBinder().toJson(areaMap));
        this.info("pb.POS.BASEINFO.CityCodeServiceImpl.queryCityCodeLoadCache", "=====dd==end====" + ServletMain.getAppName());
    }

    @Override
    public List<PosCityCodeDomain> queryCityCodeList(String code, String type) {
        ArrayList<PosCityCodeDomain> cityCodeList;
        block9: {
            block11: {
                block10: {
                    block8: {
                        cityCodeList = null;
                        if (!type.equals(QUERY_TYPE_PROVINCE)) break block8;
                        Map provinceMap = DisUtil.getMapByListJson((String)CACHECITYCODE_PROVINCE, String.class, PosCityCodeDomain.class);
                        if (provinceMap == null) break block9;
                        cityCodeList = (ArrayList<PosCityCodeDomain>)provinceMap.get(PROVINCE_MAP_KEY);
                        break block9;
                    }
                    if (!type.equals(QUERY_TYPE_CITY)) break block10;
                    Map cityMap = DisUtil.getMapByListJson((String)CACHECITYCODE_CITY, String.class, PosCityCodeDomain.class);
                    if (cityMap == null) break block9;
                    cityCodeList = (List)cityMap.get(code);
                    break block9;
                }
                if (!type.equals(QUERY_TYPE_AREA)) break block11;
                Map areaMap = DisUtil.getMapByListJson((String)CACHECITYCODE_AREA, String.class, PosCityCodeDomain.class);
                if (areaMap == null) break block9;
                cityCodeList = (List)areaMap.get(code);
                break block9;
            }
            if (type.equals(QUERY_TYPE_BACK)) {
                Map provinceMap = DisUtil.getMapByListJson((String)CACHECITYCODE_PROVINCE, String.class, PosCityCodeDomain.class);
                Map cityMap = DisUtil.getMapByListJson((String)CACHECITYCODE_CITY, String.class, PosCityCodeDomain.class);
                Map areaMap = DisUtil.getMapByListJson((String)CACHECITYCODE_AREA, String.class, PosCityCodeDomain.class);
                if (areaMap == null || provinceMap == null || cityMap == null) {
                    return null;
                }
                cityCodeList = new ArrayList<PosCityCodeDomain>();
                List tempList = null;
                String provinceCode = null;
                String cityCode = null;
                boolean flag = false;
                for (String key : areaMap.keySet()) {
                    tempList = (List)areaMap.get(key);
                    for (PosCityCodeDomain posCityCodeDomain : tempList) {
                        if (!posCityCodeDomain.getCityCode().equals(code)) continue;
                        cityCode = key;
                        cityCodeList.add(posCityCodeDomain);
                        flag = true;
                        break;
                    }
                    if (flag) break;
                }
                if (cityCode == null) {
                    return null;
                }
                flag = false;
                for (String key : cityMap.keySet()) {
                    tempList = (List)cityMap.get(key);
                    for (PosCityCodeDomain posCityCodeDomain : tempList) {
                        if (!posCityCodeDomain.getCityCode().equals(cityCode)) continue;
                        provinceCode = key;
                        cityCodeList.add(posCityCodeDomain);
                        flag = true;
                        break;
                    }
                    if (flag) break;
                }
                tempList = (List)provinceMap.get(PROVINCE_MAP_KEY);
                for (PosCityCodeDomain posCityCodeDomain : tempList) {
                    if (!posCityCodeDomain.getCityCode().equals(provinceCode)) continue;
                    cityCodeList.add(posCityCodeDomain);
                    break;
                }
            }
        }
        return cityCodeList;
    }
}

