/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pos.baseinfo.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pos.baseinfo.dao.PosMerchInfMapper;
import com.yqbsoft.laser.service.pos.baseinfo.domain.PosMerchInfDomain;
import com.yqbsoft.laser.service.pos.baseinfo.model.PosMerchInf;
import com.yqbsoft.laser.service.pos.baseinfo.service.MerchInfService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class MerchInfServiceImpl
extends BaseServiceImpl
implements MerchInfService {
    public static final String SYS_CODE = "pb.POS.BASEINFO.MerchInfServiceImpl";
    private static final String CACHE_KEY = "PbMerchInf-pro";
    public static final String IDENTIFIER_UNDERSCORE = "_";
    private PosMerchInfMapper posMerchInfMapper;

    public void setPosMerchInfMapper(PosMerchInfMapper posMerchInfMapper) {
        this.posMerchInfMapper = posMerchInfMapper;
    }

    private Date getSysDate() {
        try {
            return this.posMerchInfMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pb.POS.BASEINFO.MerchInfServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkMerchInf(PosMerchInfDomain posMerchInfDomain) {
        if (posMerchInfDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setMerchInfDefault(PosMerchInf posMerchInf) {
        if (posMerchInf == null) {
            return;
        }
        if (posMerchInf.getDataState() == null) {
            posMerchInf.setDataState(0);
        }
        if (posMerchInf.getGmtCreate() == null) {
            posMerchInf.setGmtCreate(this.getSysDate());
        }
        posMerchInf.setGmtModified(this.getSysDate());
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.posMerchInfMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pb.POS.BASEINFO.MerchInfServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setMerchInfUpdataDefault(PosMerchInf posMerchInf) {
        if (posMerchInf == null) {
            return;
        }
        posMerchInf.setGmtModified(this.getSysDate());
    }

    private void saveMerchInfModel(PosMerchInf posMerchInf) throws ApiException {
        if (posMerchInf == null) {
            return;
        }
        try {
            this.posMerchInfMapper.insert(posMerchInf);
        }
        catch (Exception e) {
            throw new ApiException("pb.POS.BASEINFO.MerchInfServiceImpl.saveFtpserverModel.ex");
        }
    }

    private PosMerchInf getMerchInfModelById(Integer merchId) {
        if (merchId == null) {
            return null;
        }
        try {
            return this.posMerchInfMapper.selectByPrimaryKey(merchId);
        }
        catch (Exception e) {
            this.logger.error("pb.POS.BASEINFO.MerchInfServiceImpl.getMerchInfModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteMerchInfModel(Integer merchId) throws ApiException {
        if (merchId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.posMerchInfMapper.deleteByPrimaryKey(merchId);
        }
        catch (Exception e) {
            throw new ApiException("pb.POS.BASEINFO.MerchInfServiceImpl.deleteMerchInfModel.ex");
        }
        if (1 != i) {
            throw new ApiException("pb.POS.BASEINFO.MerchInfServiceImpl.deleteMerchInfModel.num");
        }
    }

    private void updateMerchInfModel(PosMerchInf posMerchInf) throws ApiException {
        if (posMerchInf == null) {
            return;
        }
        try {
            this.posMerchInfMapper.updateByPrimaryKeySelective(posMerchInf);
        }
        catch (Exception e) {
            throw new ApiException("pb.POS.BASEINFO.MerchInfServiceImpl.updateMerchInfModel.ex");
        }
    }

    private void updateStateMerchInfModel(Integer merchId, Integer dataState, Integer oldDataState) throws ApiException {
        if (merchId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("merchId", merchId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.posMerchInfMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pb.POS.BASEINFO.MerchInfServiceImpl.updateStateMerchInfModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("pb.POS.BASEINFO.MerchInfServiceImpl.updateStateMerchInfModel.null");
        }
    }

    private PosMerchInf makeMerchInf(PosMerchInfDomain posMerchInfDomain, PosMerchInf posMerchInf) {
        if (posMerchInfDomain == null) {
            return null;
        }
        if (posMerchInf == null) {
            posMerchInf = new PosMerchInf();
        }
        try {
            BeanUtils.copyAllPropertys((Object)posMerchInf, (Object)posMerchInfDomain);
        }
        catch (Exception e) {
            this.logger.error("pb.POS.BASEINFO.MerchInfServiceImpl.makeMerchInf", (Throwable)e);
        }
        return posMerchInf;
    }

    private List<PosMerchInf> queryMerchInfModelPage(Map<String, Object> parammap) {
        try {
            return this.posMerchInfMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pb.POS.BASEINFO.MerchInfServiceImpl.queryMerchInfModel", (Throwable)e);
            return null;
        }
    }

    private int countMerchInf(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.posMerchInfMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pb.POS.BASEINFO.MerchInfServiceImpl.countMerchInf", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveMerchInf(PosMerchInfDomain posMerchInfDomain) throws ApiException {
        String msg = this.checkMerchInf(posMerchInfDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pb.POS.BASEINFO.MerchInfServiceImpl.saveMerchInf.checkMerchInf", msg);
        }
        PosMerchInf posMerchInf = this.makeMerchInf(posMerchInfDomain, null);
        this.setMerchInfDefault(posMerchInf);
        this.saveMerchInfModel(posMerchInf);
    }

    @Override
    public void updateMerchInfState(Integer merchId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateMerchInfModel(merchId, dataState, oldDataState);
        this.refreshMerchInfoCache(this.getMerchInfModelById(merchId), dataState);
    }

    @Override
    public void updateMerchInf(PosMerchInfDomain posMerchInfDomain) throws ApiException {
        String msg = this.checkMerchInf(posMerchInfDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pb.POS.BASEINFO.MerchInfServiceImpl.updateMerchInf.checkMerchInf", msg);
        }
        PosMerchInf oldPosMerchInf = this.getMerchInfModelById(posMerchInfDomain.getMerchId());
        if (oldPosMerchInf == null) {
            throw new ApiException("pb.POS.BASEINFO.MerchInfServiceImpl.updateMerchInf.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PosMerchInf posMerchInf = this.makeMerchInf(posMerchInfDomain, oldPosMerchInf);
        this.setMerchInfUpdataDefault(posMerchInf);
        this.updateMerchInfModel(posMerchInf);
    }

    @Override
    public PosMerchInf getMerchInf(Integer merchId) {
        return this.getMerchInfModelById(merchId);
    }

    @Override
    public void deleteMerchInf(Integer merchId) throws ApiException {
        this.deleteMerchInfModel(merchId);
    }

    @Override
    public QueryResult<PosMerchInf> queryMerchInfPage(Map<String, Object> map) {
        List<PosMerchInf> posMerchInfList = this.queryMerchInfModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMerchInf(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(posMerchInfList);
        return queryResult;
    }

    @Override
    public void queryMerchInfCache() {
        this.logger.info("pb.POS.BASEINFO.MerchInfServiceImpl.queryMerchInfCache", (Object)" =======\u5237\u65b0\u6388\u6743\u5546\u6237\u4fe1\u606f\u7f13\u5b58[PbMerchInfo-pro]\u5f00\u59cb=======");
        List<PosMerchInf> list = this.getAllPosMerchInf();
        if (CollectionUtils.isEmpty(list)) {
            DisUtil.delVer((String)CACHE_KEY);
            this.logger.info("pb.POS.BASEINFO.MerchInfServiceImpl.queryMerchInfCache", (Object)"=======\u5237\u65b0\u6388\u6743\u5546\u6237\u4fe1\u606f\u7f13\u5b58[PbMerchInfo-pro]\u8c03\u5ea6end-del=======");
            return;
        }
        HashMap<String, String> txnInfoMap = new HashMap<String, String>();
        for (PosMerchInf txnInfo : list) {
            this.saveTxnInfoCache(txnInfo, txnInfoMap);
        }
        DisUtil.setVer((String)CACHE_KEY, (String)JsonUtil.buildNormalBinder().toJson(txnInfoMap));
        this.logger.info("pb.POS.BASEINFO.MerchInfServiceImpl.queryMerchInfCache", (Object)"=======\u5237\u65b0\u6388\u6743\u5546\u6237\u4fe1\u606f\u7f13\u5b58[PbMerchInfo-pro]\u8c03\u5ea6end=======");
    }

    private List<PosMerchInf> getAllPosMerchInf() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("dataState", 1);
        List<PosMerchInf> txnInfoList = this.queryMerchInfModelPage(paramMap);
        if (CollectionUtils.isEmpty(txnInfoList)) {
            this.logger.info("pb.POS.BASEINFO.MerchInfServiceImpl.getAllPosTxnInf", (Object)" \u6ca1\u6709\u542f\u7528\u72b6\u6001\u7684\u6388\u6743\u5546\u6237\u4fe1\u606f\uff0c\u4e0d\u9700\u8981\u8bbe\u7f6e\u7f13\u5b58\u3002");
            return txnInfoList;
        }
        return txnInfoList;
    }

    private void saveTxnInfoCache(PosMerchInf merchInf, Map<String, String> txnInfoMap) {
        String key = String.valueOf(merchInf.getMchtNo()) + IDENTIFIER_UNDERSCORE + merchInf.getInstId();
        if (StringUtils.isNotBlank((String)txnInfoMap.get(key))) {
            txnInfoMap.remove(key);
        }
        String agencyInfoString = JsonUtil.buildNormalBinder().toJson((Object)merchInf);
        txnInfoMap.put(key, agencyInfoString);
    }

    private void refreshMerchInfoCache(PosMerchInf PosMerchInf2, Integer dataState) {
        boolean addflag;
        this.logger.info("pb.POS.BASEINFO.MerchInfServiceImpl.refreshTxnInfCache", (Object)"=======\u5237\u65b0\u4ea4\u6613\u4fe1\u606f\u7f13\u5b58[PbMerchInf-pro]\u5f00\u59cb=======");
        HashMap<String, String> map = DisUtil.getMapJson((String)CACHE_KEY, String.class, String.class);
        if (MapUtils.isEmpty((Map)map)) {
            map = new HashMap<String, String>();
        }
        boolean bl = addflag = dataState == 1;
        if (addflag) {
            this.saveTxnInfoCache(PosMerchInf2, map);
        } else {
            this.deleteTxnInfoCache(PosMerchInf2, map);
        }
        DisUtil.setVer((String)CACHE_KEY, (String)JsonUtil.buildNormalBinder().toJson(map));
        this.logger.info("pb.POS.BASEINFO.MerchInfServiceImpl.refreshTxnInfCache", (Object)"=======\u5237\u65b0\u4ea4\u6613\u4fe1\u606f\u7f13\u5b58[PbMerchInf-pro]\u7ed3\u675f=======");
    }

    private void deleteTxnInfoCache(PosMerchInf merchInf, Map<String, String> map) {
        String key = String.valueOf(merchInf.getMchtNo()) + IDENTIFIER_UNDERSCORE + merchInf.getInstId();
        if (StringUtils.isNotBlank((String)map.get(key))) {
            map.remove(key);
        }
    }
}

