/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pos.baseinfo.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pos.baseinfo.dao.PosTxnInfMapper;
import com.yqbsoft.laser.service.pos.baseinfo.domain.PosTxnInfDomain;
import com.yqbsoft.laser.service.pos.baseinfo.model.PosTxnInf;
import com.yqbsoft.laser.service.pos.baseinfo.service.TxnInfService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class TxnInfServiceImpl
extends BaseServiceImpl
implements TxnInfService {
    public static final String SYS_CODE = "pb.POS.BASEINFO.TxnInfServiceImpl";
    private static final String CACHE_KEY = "PbTxnInf-pro";
    private PosTxnInfMapper posTxnInfMapper;

    public void setPosTxnInfMapper(PosTxnInfMapper posTxnInfMapper) {
        this.posTxnInfMapper = posTxnInfMapper;
    }

    private Date getSysDate() {
        try {
            return this.posTxnInfMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pb.POS.BASEINFO.TxnInfServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkTxnInf(PosTxnInfDomain posTxnInfDomain) {
        if (posTxnInfDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setTxnInfDefault(PosTxnInf posTxnInf) {
        if (posTxnInf == null) {
            return;
        }
        if (posTxnInf.getDataState() == null) {
            posTxnInf.setDataState(0);
        }
        if (posTxnInf.getGmtCreate() == null) {
            posTxnInf.setGmtCreate(this.getSysDate());
        }
        posTxnInf.setGmtModified(this.getSysDate());
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.posTxnInfMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pb.POS.BASEINFO.TxnInfServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setTxnInfUpdataDefault(PosTxnInf posTxnInf) {
        if (posTxnInf == null) {
            return;
        }
        posTxnInf.setGmtModified(this.getSysDate());
    }

    private void saveTxnInfModel(PosTxnInf posTxnInf) throws ApiException {
        if (posTxnInf == null) {
            return;
        }
        try {
            this.posTxnInfMapper.insert(posTxnInf);
        }
        catch (Exception e) {
            throw new ApiException("pb.POS.BASEINFO.TxnInfServiceImpl.saveFtpserverModel.ex");
        }
    }

    private PosTxnInf getTxnInfModelById(Integer txnInfId) {
        if (txnInfId == null) {
            return null;
        }
        try {
            return this.posTxnInfMapper.selectByPrimaryKey(txnInfId);
        }
        catch (Exception e) {
            this.logger.error("pb.POS.BASEINFO.TxnInfServiceImpl.getTxnInfModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteTxnInfModel(Integer txnInfId) throws ApiException {
        if (txnInfId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.posTxnInfMapper.deleteByPrimaryKey(txnInfId);
        }
        catch (Exception e) {
            throw new ApiException("pb.POS.BASEINFO.TxnInfServiceImpl.deleteTxnInfModel.ex");
        }
        if (1 != i) {
            throw new ApiException("pb.POS.BASEINFO.TxnInfServiceImpl.deleteTxnInfModel.num");
        }
    }

    private void updateTxnInfModel(PosTxnInf posTxnInf) throws ApiException {
        if (posTxnInf == null) {
            return;
        }
        try {
            this.posTxnInfMapper.updateByPrimaryKeySelective(posTxnInf);
        }
        catch (Exception e) {
            throw new ApiException("pb.POS.BASEINFO.TxnInfServiceImpl.updateTxnInfModel.ex");
        }
    }

    private void updateStateTxnInfModel(Integer txnInfId, Integer dataState, Integer oldDataState) throws ApiException {
        if (txnInfId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("txnInfId", txnInfId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.posTxnInfMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pb.POS.BASEINFO.TxnInfServiceImpl.updateStateTxnInfModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("pb.POS.BASEINFO.TxnInfServiceImpl.updateStateTxnInfModel.null");
        }
    }

    private PosTxnInf makeTxnInf(PosTxnInfDomain posTxnInfDomain, PosTxnInf posTxnInf) {
        if (posTxnInfDomain == null) {
            return null;
        }
        if (posTxnInf == null) {
            posTxnInf = new PosTxnInf();
        }
        try {
            BeanUtils.copyAllPropertys((Object)posTxnInf, (Object)posTxnInfDomain);
        }
        catch (Exception e) {
            this.logger.error("pb.POS.BASEINFO.TxnInfServiceImpl.makeTxnInf", (Throwable)e);
        }
        return posTxnInf;
    }

    private List<PosTxnInf> queryTxnInfModelPage(Map<String, Object> parammap) {
        try {
            return this.posTxnInfMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pb.POS.BASEINFO.TxnInfServiceImpl.queryTxnInfModel", (Throwable)e);
            return null;
        }
    }

    private int countTxnInf(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.posTxnInfMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pb.POS.BASEINFO.TxnInfServiceImpl.countTxnInf", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveTxnInf(PosTxnInfDomain posTxnInfDomain) throws ApiException {
        String msg = this.checkTxnInf(posTxnInfDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pb.POS.BASEINFO.TxnInfServiceImpl.saveTxnInf.checkTxnInf", msg);
        }
        PosTxnInf posTxnInf = this.makeTxnInf(posTxnInfDomain, null);
        this.setTxnInfDefault(posTxnInf);
        this.saveTxnInfModel(posTxnInf);
    }

    @Override
    public void updateTxnInfState(Integer txnInfId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateTxnInfModel(txnInfId, dataState, oldDataState);
        this.refreshTxnInfoCache(this.getTxnInfModelById(txnInfId), dataState);
    }

    @Override
    public void updateTxnInf(PosTxnInfDomain posTxnInfDomain) throws ApiException {
        String msg = this.checkTxnInf(posTxnInfDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pb.POS.BASEINFO.TxnInfServiceImpl.updateTxnInf.checkTxnInf", msg);
        }
        PosTxnInf oldPosTxnInf = this.getTxnInfModelById(posTxnInfDomain.getTxnInfId());
        if (oldPosTxnInf == null) {
            throw new ApiException("pb.POS.BASEINFO.TxnInfServiceImpl.updateTxnInf.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PosTxnInf posTxnInf = this.makeTxnInf(posTxnInfDomain, oldPosTxnInf);
        this.setTxnInfUpdataDefault(posTxnInf);
        this.updateTxnInfModel(posTxnInf);
    }

    @Override
    public PosTxnInf getTxnInf(Integer txnInfId) {
        return this.getTxnInfModelById(txnInfId);
    }

    @Override
    public void deleteTxnInf(Integer txnInfId) throws ApiException {
        this.deleteTxnInfModel(txnInfId);
    }

    @Override
    public QueryResult<PosTxnInf> queryTxnInfPage(Map<String, Object> map) {
        List<PosTxnInf> posTxnInfList = this.queryTxnInfModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countTxnInf(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(posTxnInfList);
        return queryResult;
    }

    @Override
    public PosTxnInf getTxnInfByTxnNum(String txnNum) {
        if (txnNum == null || txnNum.length() <= 0) {
            throw new ApiException("pb.POS.BASEINFO.TxnInfServiceImpl.getTxnInfByTxnNum", "txnNum\u4e3a\u7a7a");
        }
        PosTxnInf poxTxnInf = null;
        try {
            poxTxnInf = this.posTxnInfMapper.selectByTxnNum(txnNum);
        }
        catch (Exception e) {
            this.logger.error("pb.POS.BASEINFO.TxnInfServiceImpl.getTxnInfByTxnNum", (Throwable)e);
        }
        return poxTxnInf;
    }

    private List<PosTxnInf> getAllPosTxnInf() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("dataState", 1);
        List<PosTxnInf> txnInfoList = this.queryTxnInfModelPage(paramMap);
        if (CollectionUtils.isEmpty(txnInfoList)) {
            this.logger.info("pb.POS.BASEINFO.TxnInfServiceImpl.getAllPosTxnInf", (Object)" \u6ca1\u6709\u542f\u7528\u72b6\u6001\u7684\u4ea4\u6613\u4fe1\u606f\uff0c\u4e0d\u9700\u8981\u8bbe\u7f6e\u7f13\u5b58\u3002");
            return txnInfoList;
        }
        return txnInfoList;
    }

    @Override
    public void queryTxnInfCache() {
        this.logger.info("pb.POS.BASEINFO.TxnInfServiceImpl.queryTxnInfoCache", (Object)" =======\u5237\u65b0\u4ea4\u6613\u4fe1\u606f\u7f13\u5b58[PbTxnInfo-pro]\u5f00\u59cb=======");
        List<PosTxnInf> list = this.getAllPosTxnInf();
        if (CollectionUtils.isEmpty(list)) {
            DisUtil.delVer((String)CACHE_KEY);
            this.logger.info("pb.POS.BASEINFO.TxnInfServiceImpl.queryTxnInfoCache", (Object)"=======\u5237\u65b0\u4ea4\u6613\u4fe1\u606f\u7f13\u5b58[PbTxnInfo-pro]\u8c03\u5ea6end-del=======");
            return;
        }
        HashMap<String, String> txnInfoMap = new HashMap<String, String>();
        for (PosTxnInf txnInfo : list) {
            this.saveTxnInfoCache(txnInfo, txnInfoMap);
        }
        DisUtil.setVer((String)CACHE_KEY, (String)JsonUtil.buildNormalBinder().toJson(txnInfoMap));
        this.logger.info("pb.POS.BASEINFO.TxnInfServiceImpl.queryTxnInfoCache", (Object)"=======\u5237\u65b0\u4ea4\u6613\u4fe1\u606f\u7f13\u5b58[PbTxnInfo-pro]\u8c03\u5ea6end=======");
    }

    private void saveTxnInfoCache(PosTxnInf txnInfo, Map<String, String> txnInfoMap) {
        String txnNum = txnInfo.getTxnNum().toString().trim();
        if (StringUtils.isNotBlank((String)txnInfoMap.get(txnNum))) {
            txnInfoMap.remove(txnNum);
        }
        String agencyInfoString = JsonUtil.buildNormalBinder().toJson((Object)txnInfo);
        txnInfoMap.put(txnNum, agencyInfoString);
    }

    private void refreshTxnInfoCache(PosTxnInf PosTxnInf2, Integer dataState) {
        boolean addflag;
        this.logger.info("pb.POS.BASEINFO.TxnInfServiceImpl.refreshTxnInfCache", (Object)"=======\u5237\u65b0\u4ea4\u6613\u4fe1\u606f\u7f13\u5b58[PbTxnInfo-pro]\u5f00\u59cb=======");
        HashMap<String, String> map = DisUtil.getMapJson((String)CACHE_KEY, String.class, String.class);
        if (MapUtils.isEmpty((Map)map)) {
            map = new HashMap<String, String>();
        }
        boolean bl = addflag = dataState == 1;
        if (addflag) {
            this.saveTxnInfoCache(PosTxnInf2, map);
        } else {
            this.deleteTxnInfoCache(PosTxnInf2, map);
        }
        DisUtil.setVer((String)CACHE_KEY, (String)JsonUtil.buildNormalBinder().toJson(map));
        this.logger.info("pb.POS.BASEINFO.TxnInfServiceImpl.refreshTxnInfCache", (Object)"=======\u5237\u65b0\u4ea4\u6613\u4fe1\u606f\u7f13\u5b58[PbTxnInfo-pro]\u7ed3\u675f=======");
    }

    private void deleteTxnInfoCache(PosTxnInf PosTxnInf2, Map<String, String> map) {
        String txnNum = PosTxnInf2.getTxnNum().toString().trim();
        if (StringUtils.isNotBlank((String)map.get(txnNum))) {
            map.remove(txnNum);
        }
    }
}

