/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.financetitile.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.financetitile.constants.FtFinanceTitileDataStateEnum;
import com.yqbsoft.laser.service.financetitile.dao.FtFinanceTitileDailyMapper;
import com.yqbsoft.laser.service.financetitile.dao.FtFinanceTitileMapper;
import com.yqbsoft.laser.service.financetitile.domain.FtFinanceTitileDailyDomain;
import com.yqbsoft.laser.service.financetitile.domain.FtFinanceTitileDomain;
import com.yqbsoft.laser.service.financetitile.domain.VdFaccountDtDomain;
import com.yqbsoft.laser.service.financetitile.model.FtFinanceTitile;
import com.yqbsoft.laser.service.financetitile.model.FtFinanceTitileDaily;
import com.yqbsoft.laser.service.financetitile.service.BaseFtFinanceTitileService;
import com.yqbsoft.laser.service.financetitile.service.FtFinanceTitileService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class FtFinanceTitileServiceImpl
extends BaseFtFinanceTitileService
implements FtFinanceTitileService {
    public static final String SYS_CODE = "ft.FtFinanceTitileServiceImpl";
    private FtFinanceTitileMapper ftFinanceTitileMapper;
    private FtFinanceTitileDailyMapper ftFinanceTitileDailyMapper;

    public void setFtFinanceTitileMapper(FtFinanceTitileMapper ftFinanceTitileMapper) {
        this.ftFinanceTitileMapper = ftFinanceTitileMapper;
    }

    public void setFtFinanceTitileDailyMapper(FtFinanceTitileDailyMapper ftFinanceTitileDailyMapper) {
        this.ftFinanceTitileDailyMapper = ftFinanceTitileDailyMapper;
    }

    private Date getSysDate() {
        try {
            return this.ftFinanceTitileMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("ft.FtFinanceTitileServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkFinanceTitile(FtFinanceTitileDomain ftFinanceTitileDomain) {
        if (null == ftFinanceTitileDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setFinanceTitileDefault(FtFinanceTitile ftFinanceTitile) {
        if (null == ftFinanceTitile) {
            return;
        }
        if (null == ftFinanceTitile.getDataState()) {
            ftFinanceTitile.setDataState(0);
        }
        if (null == ftFinanceTitile.getGmtCreate()) {
            ftFinanceTitile.setGmtCreate(this.getSysDate());
        }
        ftFinanceTitile.setGmtModified(this.getSysDate());
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.ftFinanceTitileMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ft.FtFinanceTitileServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setFinanceTitileUpdataDefault(FtFinanceTitile ftFinanceTitile) {
        if (null == ftFinanceTitile) {
            return;
        }
        ftFinanceTitile.setGmtModified(this.getSysDate());
    }

    private void saveFinanceTitileModel(FtFinanceTitile ftFinanceTitile) throws ApiException {
        if (null == ftFinanceTitile) {
            return;
        }
        try {
            this.ftFinanceTitileMapper.insert(ftFinanceTitile);
        }
        catch (Exception e) {
            throw new ApiException("ft.FtFinanceTitileServiceImpl.saveFinanceTitileModel.ex", (Throwable)e);
        }
    }

    private FtFinanceTitile getFinanceTitileModelById(Integer financeTitileId) {
        if (null == financeTitileId) {
            return null;
        }
        try {
            return this.ftFinanceTitileMapper.selectByPrimaryKey(financeTitileId);
        }
        catch (Exception e) {
            this.logger.error("ft.FtFinanceTitileServiceImpl.getFinanceTitileModelById", (Throwable)e);
            return null;
        }
    }

    public FtFinanceTitile getFinanceTitileModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ftFinanceTitileMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ft.FtFinanceTitileServiceImpl.getFinanceTitileModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delFinanceTitileModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ftFinanceTitileMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ft.FtFinanceTitileServiceImpl.delFinanceTitileModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ft.FtFinanceTitileServiceImpl.delFinanceTitileModelByCode.num");
        }
    }

    private void deleteFinanceTitileModel(Integer financeTitileId) throws ApiException {
        if (null == financeTitileId) {
            return;
        }
        int i = 0;
        try {
            i = this.ftFinanceTitileMapper.deleteByPrimaryKey(financeTitileId);
        }
        catch (Exception e) {
            throw new ApiException("ft.FtFinanceTitileServiceImpl.deleteFinanceTitileModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ft.FtFinanceTitileServiceImpl.deleteFinanceTitileModel.num");
        }
    }

    private void updateFinanceTitileModel(FtFinanceTitile ftFinanceTitile) throws ApiException {
        if (null == ftFinanceTitile) {
            return;
        }
        try {
            this.ftFinanceTitileMapper.updateByPrimaryKeySelective(ftFinanceTitile);
        }
        catch (Exception e) {
            throw new ApiException("ft.FtFinanceTitileServiceImpl.updateFinanceTitileModel.ex", (Throwable)e);
        }
    }

    private void updateStateFinanceTitileModel(Integer financeTitileId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == financeTitileId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("financeTitileId", financeTitileId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ftFinanceTitileMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ft.FtFinanceTitileServiceImpl.updateStateFinanceTitileModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ft.FtFinanceTitileServiceImpl.updateStateFinanceTitileModel.null");
        }
    }

    private FtFinanceTitile makeFinanceTitile(FtFinanceTitileDomain ftFinanceTitileDomain, FtFinanceTitile ftFinanceTitile) {
        if (null == ftFinanceTitileDomain) {
            return null;
        }
        if (null == ftFinanceTitile) {
            ftFinanceTitile = new FtFinanceTitile();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ftFinanceTitile, (Object)ftFinanceTitileDomain);
        }
        catch (Exception e) {
            this.logger.error("ft.FtFinanceTitileServiceImpl.makeFinanceTitile", (Throwable)e);
        }
        return ftFinanceTitile;
    }

    private List<FtFinanceTitile> queryFinanceTitileModelPage(Map<String, Object> parammap) {
        try {
            return this.ftFinanceTitileMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ft.FtFinanceTitileServiceImpl.queryFinanceTitileModel", (Throwable)e);
            return null;
        }
    }

    private int countFinanceTitile(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ftFinanceTitileMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ft.FtFinanceTitileServiceImpl.countFinanceTitile", (Throwable)e);
        }
        return i;
    }

    private String checkFinanceTitileDaily(FtFinanceTitileDailyDomain ftFinanceTitileDailyDomain) {
        if (null == ftFinanceTitileDailyDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setFinanceTitileDailyDefault(FtFinanceTitileDaily ftFinanceTitileDaily) {
        if (null == ftFinanceTitileDaily) {
            return;
        }
        if (null == ftFinanceTitileDaily.getDataState()) {
            ftFinanceTitileDaily.setDataState(0);
        }
        if (null == ftFinanceTitileDaily.getGmtCreate()) {
            ftFinanceTitileDaily.setGmtCreate(this.getSysDate());
        }
        ftFinanceTitileDaily.setGmtModified(this.getSysDate());
    }

    private int getTitileDailyMaxCode() {
        int code = 0;
        try {
            return this.ftFinanceTitileDailyMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ft.FtFinanceTitileServiceImpl.getTitileDailyMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setFinanceTitileDailyUpdataDefault(FtFinanceTitileDaily ftFinanceTitileDaily) {
        if (null == ftFinanceTitileDaily) {
            return;
        }
        ftFinanceTitileDaily.setGmtModified(this.getSysDate());
    }

    private void saveFinanceTitileDailyModel(FtFinanceTitileDaily ftFinanceTitileDaily) throws ApiException {
        if (null == ftFinanceTitileDaily) {
            return;
        }
        try {
            this.ftFinanceTitileDailyMapper.insert(ftFinanceTitileDaily);
        }
        catch (Exception e) {
            throw new ApiException("ft.FtFinanceTitileServiceImpl.saveFinanceTitileDailyModel.ex", (Throwable)e);
        }
    }

    private FtFinanceTitileDaily getFinanceTitileDailyModelById(Integer financeTitileDailyId) {
        if (null == financeTitileDailyId) {
            return null;
        }
        try {
            return this.ftFinanceTitileDailyMapper.selectByPrimaryKey(financeTitileDailyId);
        }
        catch (Exception e) {
            this.logger.error("ft.FtFinanceTitileServiceImpl.getFinanceTitileDailyModelById", (Throwable)e);
            return null;
        }
    }

    public FtFinanceTitileDaily getFinanceTitileDailyModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ftFinanceTitileDailyMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ft.FtFinanceTitileServiceImpl.getFinanceTitileDailyModelByCode", (Throwable)e);
            return null;
        }
    }

    private FtFinanceTitileDaily getFinanceTitileDailyLockModelByCode(String faccountDate, String tenantCode, String financeTitileCode) {
        if (StringUtils.isBlank((String)faccountDate)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("faccountDate", faccountDate);
        map.put("tenantCode", tenantCode);
        map.put("financeTitileCode", financeTitileCode);
        try {
            return this.ftFinanceTitileDailyMapper.getLockByDate(map);
        }
        catch (Exception e) {
            this.logger.error("ft.FtFinanceTitileServiceImpl.getFinanceTitileDailyLockModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delFinanceTitileDailyModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ftFinanceTitileDailyMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ft.FtFinanceTitileServiceImpl.delFinanceTitileDailyModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ft.FtFinanceTitileServiceImpl.delFinanceTitileDailyModelByCode.num");
        }
    }

    private void deleteFinanceTitileDailyModel(Integer financeTitileDailyId) throws ApiException {
        if (null == financeTitileDailyId) {
            return;
        }
        int i = 0;
        try {
            i = this.ftFinanceTitileDailyMapper.deleteByPrimaryKey(financeTitileDailyId);
        }
        catch (Exception e) {
            throw new ApiException("ft.FtFinanceTitileServiceImpl.deleteFinanceTitileDailyModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ft.FtFinanceTitileServiceImpl.deleteFinanceTitileDailyModel.num");
        }
    }

    private void updateFinanceTitileDailyModel(FtFinanceTitileDaily ftFinanceTitileDaily) throws ApiException {
        if (null == ftFinanceTitileDaily) {
            return;
        }
        try {
            this.ftFinanceTitileDailyMapper.updateByPrimaryKeySelective(ftFinanceTitileDaily);
        }
        catch (Exception e) {
            throw new ApiException("ft.FtFinanceTitileServiceImpl.updateFinanceTitileDailyModel.ex", (Throwable)e);
        }
    }

    private void updateStateFinanceTitileDailyModel(Integer financeTitileDailyId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == financeTitileDailyId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("financeTitileDailyId", financeTitileDailyId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ftFinanceTitileDailyMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ft.FtFinanceTitileServiceImpl.updateStateFinanceTitileDailyModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ft.FtFinanceTitileServiceImpl.updateStateFinanceTitileDailyModel.null");
        }
    }

    private FtFinanceTitileDaily makeFinanceTitileDaily(FtFinanceTitileDailyDomain ftFinanceTitileDailyDomain, FtFinanceTitileDaily ftFinanceTitileDaily) {
        if (null == ftFinanceTitileDailyDomain) {
            return null;
        }
        if (null == ftFinanceTitileDaily) {
            ftFinanceTitileDaily = new FtFinanceTitileDaily();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ftFinanceTitileDaily, (Object)ftFinanceTitileDailyDomain);
        }
        catch (Exception e) {
            this.logger.error("ft.FtFinanceTitileServiceImpl.makeFinanceTitileDaily", (Throwable)e);
        }
        return ftFinanceTitileDaily;
    }

    private List<FtFinanceTitileDaily> queryFinanceTitileDailyModelPage(Map<String, Object> parammap) {
        try {
            return this.ftFinanceTitileDailyMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ft.FtFinanceTitileServiceImpl.queryFinanceTitileDailyModel", (Throwable)e);
            return null;
        }
    }

    private int countFinanceTitileDaily(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ftFinanceTitileDailyMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ft.FtFinanceTitileServiceImpl.countFinanceTitileDaily", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveFinanceTitile(FtFinanceTitileDomain ftFinanceTitileDomain) throws ApiException {
        String msg = this.checkFinanceTitile(ftFinanceTitileDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ft.FtFinanceTitileServiceImpl.saveFinanceTitile.checkFinanceTitile", msg);
        }
        FtFinanceTitile ftFinanceTitile = this.makeFinanceTitile(ftFinanceTitileDomain, null);
        this.setFinanceTitileDefault(ftFinanceTitile);
        this.saveFinanceTitileModel(ftFinanceTitile);
    }

    @Override
    public void updateFinanceTitileState(Integer financeTitileId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateFinanceTitileModel(financeTitileId, dataState, oldDataState);
    }

    @Override
    public void updateFinanceTitile(FtFinanceTitileDomain ftFinanceTitileDomain) throws ApiException {
        String msg = this.checkFinanceTitile(ftFinanceTitileDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ft.FtFinanceTitileServiceImpl.updateFinanceTitile.checkFinanceTitile", msg);
        }
        FtFinanceTitile oldFtFinanceTitile = this.getFinanceTitileModelById(ftFinanceTitileDomain.getFinanceTitileId());
        if (null == oldFtFinanceTitile) {
            throw new ApiException("ft.FtFinanceTitileServiceImpl.updateFinanceTitile.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        FtFinanceTitile ftFinanceTitile = this.makeFinanceTitile(ftFinanceTitileDomain, oldFtFinanceTitile);
        this.setFinanceTitileUpdataDefault(ftFinanceTitile);
        this.updateFinanceTitileModel(ftFinanceTitile);
    }

    @Override
    public FtFinanceTitile getFinanceTitile(Integer financeTitileId) {
        return this.getFinanceTitileModelById(financeTitileId);
    }

    @Override
    public FtFinanceTitile getFinanceTitileByCode(String financeTitileCode, String tenantCode) {
        assert (StringUtils.hasBlank((String[])new String[]{financeTitileCode, tenantCode}));
        try {
            return this.ftFinanceTitileMapper.getByCode(this.getQueryMapParam("financeTitileCode,tenantCode", new Object[]{financeTitileCode, tenantCode}));
        }
        catch (Exception e) {
            this.logger.error("ft.FtFinanceTitileServiceImpl.getFinanceTitileByCode", (Throwable)e);
            return null;
        }
    }

    @Override
    public void deleteFinanceTitile(Integer financeTitileId) throws ApiException {
        this.deleteFinanceTitileModel(financeTitileId);
    }

    @Override
    public QueryResult<FtFinanceTitile> queryFinanceTitilePage(Map<String, Object> map) {
        List<FtFinanceTitile> ftFinanceTitileList = this.queryFinanceTitileModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFinanceTitile(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ftFinanceTitileList);
        return queryResult;
    }

    @Override
    public void saveFinanceTitileDaily(FtFinanceTitileDailyDomain ftFinanceTitileDailyDomain) throws ApiException {
        String msg = this.checkFinanceTitileDaily(ftFinanceTitileDailyDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ft.FtFinanceTitileServiceImpl.saveFinanceTitileDaily.checkFinanceTitileDaily", msg);
        }
        FtFinanceTitileDaily ftFinanceTitileDaily = this.makeFinanceTitileDaily(ftFinanceTitileDailyDomain, null);
        this.setFinanceTitileDailyDefault(ftFinanceTitileDaily);
        this.saveFinanceTitileDailyModel(ftFinanceTitileDaily);
    }

    @Override
    public void updateFinanceTitileDailyState(Integer financeTitileDailyId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateFinanceTitileDailyModel(financeTitileDailyId, dataState, oldDataState);
    }

    @Override
    public void updateFinanceTitileDaily(FtFinanceTitileDailyDomain ftFinanceTitileDailyDomain) throws ApiException {
        String msg = this.checkFinanceTitileDaily(ftFinanceTitileDailyDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ft.FtFinanceTitileServiceImpl.updateFinanceTitileDaily.checkFinanceTitileDaily", msg);
        }
        FtFinanceTitileDaily oldFtFinanceTitileDaily = this.getFinanceTitileDailyModelById(ftFinanceTitileDailyDomain.getFinanceTitileDailyId());
        if (null == oldFtFinanceTitileDaily) {
            throw new ApiException("ft.FtFinanceTitileServiceImpl.updateFinanceTitileDaily.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        FtFinanceTitileDaily ftFinanceTitileDaily = this.makeFinanceTitileDaily(ftFinanceTitileDailyDomain, oldFtFinanceTitileDaily);
        this.setFinanceTitileDailyUpdataDefault(ftFinanceTitileDaily);
        this.updateFinanceTitileDailyModel(ftFinanceTitileDaily);
    }

    @Override
    public FtFinanceTitileDaily getFinanceTitileDaily(Integer financeTitileDailyId) {
        return this.getFinanceTitileDailyModelById(financeTitileDailyId);
    }

    @Override
    public void deleteFinanceTitileDaily(Integer financeTitileDailyId) throws ApiException {
        this.deleteFinanceTitileDailyModel(financeTitileDailyId);
    }

    @Override
    public QueryResult<FtFinanceTitileDaily> queryFinanceTitileDailyPage(Map<String, Object> map) {
        List<FtFinanceTitileDaily> ftFinanceTitileDailyList = this.queryFinanceTitileDailyModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFinanceTitileDaily(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ftFinanceTitileDailyList);
        return queryResult;
    }

    @Override
    public void saveTitileDaily(VdFaccountDtDomain vdFaccountDtDomain) {
        if (null == vdFaccountDtDomain) {
            return;
        }
        if (StringUtils.isBlank((String)vdFaccountDtDomain.getFaccountTitileCode())) {
            this.logger.error("ft.FtFinanceTitileServiceImpl.saveTitileDaily.titleCode.null", (Object)"\u79d1\u76ee\u4ee3\u7801\u4e3a\u7a7a");
            return;
        }
        FtFinanceTitile ftFinanceTitile = this.queryTitileByCache(vdFaccountDtDomain.getFaccountTitileCode(), vdFaccountDtDomain.getTenantCode());
        if (ftFinanceTitile == null && (ftFinanceTitile = this.queryTitileByCache(vdFaccountDtDomain.getFaccountTitileCode(), "00000000")) == null) {
            this.logger.error("ft.FtFinanceTitileServiceImpl.saveTitileDaily.ftFinanceTitile.null", (Object)("\u79d1\u76ee\u4e3a\u7a7a\u3010" + vdFaccountDtDomain.getFaccountTitileCode() + "\u3011"));
            return;
        }
        vdFaccountDtDomain.setFaccountTitleRange(ftFinanceTitile.getFaccountTitileRange());
        FtFinanceTitileDaily ftFinanceTitileDaily = this.getFinanceTitileDailyLockModelByCode(vdFaccountDtDomain.getFaccountingDate(), vdFaccountDtDomain.getTenantCode(), vdFaccountDtDomain.getFaccountTitileCode());
        FtFinanceTitileDailyDomain ftFinanceTitileDailyDomain = this.makeDailyDomain(vdFaccountDtDomain, ftFinanceTitileDaily);
        if (null == ftFinanceTitileDailyDomain.getFinanceTitileDailyId()) {
            this.saveFinanceTitileDaily(ftFinanceTitileDailyDomain);
        } else {
            this.updateFinanceTitileDaily(ftFinanceTitileDailyDomain);
        }
    }

    @Override
    public void preloadTitile2Cache() throws ApiException {
        this.logger.info("FT.PRELOAD.TITILE", (Object)"\u79d1\u76ee\u7f13\u5b58\u9884\u52a0\u8f7d start....");
        List<FtFinanceTitile> titileList = this.queryFinanceTitileModelPage(this.getQueryMapParam("dataState", new Object[]{FtFinanceTitileDataStateEnum.NORMAL.getCode()}));
        if (CollectionUtils.isEmpty(titileList)) {
            DisUtil.del((String)"FINANCE_TITILE_MAP");
            return;
        }
        HashMap<String, String> titileMap = new HashMap<String, String>();
        for (FtFinanceTitile titile : titileList) {
            titileMap.put(this.getFieldKey(titile.getTenantCode(), titile.getFinanceTitileCode()), JsonUtil.buildNormalBinder().toJson((Object)titile));
        }
        DisUtil.setMap((String)"FINANCE_TITILE_MAP", titileMap);
        this.logger.info("FT.PRELOAD.TITILE", (Object)"\u79d1\u76ee\u7f13\u5b58\u9884\u52a0\u8f7dend");
    }

    @Override
    public FtFinanceTitile queryTitileByCache(String financeTitileCode, String tenantCode) throws ApiException {
        String resultStr = DisUtil.getMap((String)"FINANCE_TITILE_MAP", (String)this.getFieldKey(tenantCode, financeTitileCode));
        if (StringUtils.isNotBlank((String)resultStr)) {
            return (FtFinanceTitile)JsonUtil.buildNormalBinder().getJsonToObject(resultStr, FtFinanceTitile.class);
        }
        FtFinanceTitile titile = this.getFinanceTitileByCode(financeTitileCode, tenantCode);
        if (titile != null) {
            DisUtil.setMap((String)"FINANCE_TITILE_MAP", (String)this.getFieldKey(tenantCode, financeTitileCode), (String)JsonUtil.buildNormalBinder().toJson((Object)titile));
            return titile;
        }
        return null;
    }

    private String getFieldKey(String tenantCode, String financeTitileCode) {
        return org.apache.commons.lang3.StringUtils.join((Object[])new String[]{tenantCode, financeTitileCode}, (String)"-");
    }

    private FtFinanceTitileDailyDomain makeDailyDomain(VdFaccountDtDomain vdFaccountDtDomain, FtFinanceTitileDaily ftFinanceTitileDaily) {
        if (null == vdFaccountDtDomain) {
            return null;
        }
        FtFinanceTitileDailyDomain ftFinanceTitileDailyDomain = this.createFtFinanceTitileDaily(vdFaccountDtDomain, ftFinanceTitileDaily);
        this.initFaccountAbalance(ftFinanceTitileDailyDomain, vdFaccountDtDomain);
        this.accumulateDtCountAndAmount(ftFinanceTitileDailyDomain, vdFaccountDtDomain);
        this.calculateFaccountAbalance(ftFinanceTitileDailyDomain, vdFaccountDtDomain);
        return ftFinanceTitileDailyDomain;
    }

    private FtFinanceTitileDailyDomain createFtFinanceTitileDaily(VdFaccountDtDomain vdFaccountDtDomain, FtFinanceTitileDaily ftFinanceTitileDaily) {
        assert (vdFaccountDtDomain != null);
        FtFinanceTitileDailyDomain ftFinanceTitileDailyDomain = new FtFinanceTitileDailyDomain();
        ftFinanceTitileDailyDomain.setCurrencyCode(vdFaccountDtDomain.getCurrencyCode());
        ftFinanceTitileDailyDomain.setCurrencyDirection(vdFaccountDtDomain.getCurrencyAfdirection());
        ftFinanceTitileDailyDomain.setTenantCode(vdFaccountDtDomain.getTenantCode());
        ftFinanceTitileDailyDomain.setFinanceTitileCode(vdFaccountDtDomain.getFaccountTitileCode());
        ftFinanceTitileDailyDomain.setFaccountDate(vdFaccountDtDomain.getFaccountingDate());
        ftFinanceTitileDailyDomain.setFaccountCrcount(0L);
        ftFinanceTitileDailyDomain.setFaccountDecount(0L);
        ftFinanceTitileDailyDomain.setFaccountCramount(BigDecimal.ZERO);
        ftFinanceTitileDailyDomain.setFaccountDeamount(BigDecimal.ZERO);
        if (null != ftFinanceTitileDaily) {
            ftFinanceTitileDailyDomain.setFaccountCrabalance(ftFinanceTitileDaily.getFaccountCrabalance());
            ftFinanceTitileDailyDomain.setFaccountDeabalance(ftFinanceTitileDaily.getFaccountDeabalance());
            if (ftFinanceTitileDaily.getFaccountCramount() != null) {
                ftFinanceTitileDailyDomain.setFaccountCramount(ftFinanceTitileDaily.getFaccountCramount());
            }
            if (ftFinanceTitileDaily.getFaccountCrcount() != null) {
                ftFinanceTitileDailyDomain.setFaccountCrcount(ftFinanceTitileDaily.getFaccountCrcount());
            }
            if (ftFinanceTitileDaily.getFaccountDeamount() != null) {
                ftFinanceTitileDailyDomain.setFaccountDeamount(ftFinanceTitileDaily.getFaccountDeamount());
            }
            if (ftFinanceTitileDaily.getFaccountDecount() != null) {
                ftFinanceTitileDailyDomain.setFaccountDecount(ftFinanceTitileDaily.getFaccountDecount());
            }
            ftFinanceTitileDailyDomain.setFinanceTitileDailyId(ftFinanceTitileDaily.getFinanceTitileDailyId());
            ftFinanceTitileDailyDomain.setFinanceTitileDailySqeno(ftFinanceTitileDaily.getFinanceTitileDailySqeno());
        }
        return ftFinanceTitileDailyDomain;
    }

    private void initFaccountAbalance(FtFinanceTitileDailyDomain ftFinanceTitileDailyDomain, VdFaccountDtDomain vdFaccountDtDomain) {
        if (ftFinanceTitileDailyDomain.getFaccountCrabalance() == null || ftFinanceTitileDailyDomain.getFaccountDeabalance() == null) {
            boolean nearDailyDeabalanceIsEffect;
            boolean nearDailyCrabalanceIsEffect;
            String dateStr = DateUtils.changeDateStrformat((String)vdFaccountDtDomain.getFaccountingDate(), (String)"yyyy-MM-dd", (String[])new String[]{"yyyyMMdd"});
            FtFinanceTitileDaily nearFaccountDateDily = this.getFtFinanceTitileDailyNearDate(dateStr, vdFaccountDtDomain.getFaccountTitileCode(), vdFaccountDtDomain.getTenantCode());
            ftFinanceTitileDailyDomain.setFaccountCrabalance(BigDecimal.ZERO);
            ftFinanceTitileDailyDomain.setFaccountDeabalance(BigDecimal.ZERO);
            boolean bl = nearDailyCrabalanceIsEffect = nearFaccountDateDily != null && this.gtZero(nearFaccountDateDily.getFaccountCrabalance());
            if (!this.gtZero(ftFinanceTitileDailyDomain.getFaccountCrabalance()) && nearDailyCrabalanceIsEffect) {
                ftFinanceTitileDailyDomain.setFaccountCrabalance(nearFaccountDateDily.getFaccountCrabalance());
            }
            boolean bl2 = nearDailyDeabalanceIsEffect = nearFaccountDateDily != null && this.gtZero(nearFaccountDateDily.getFaccountDeabalance());
            if (!this.gtZero(ftFinanceTitileDailyDomain.getFaccountDeabalance()) && nearDailyDeabalanceIsEffect) {
                ftFinanceTitileDailyDomain.setFaccountDeabalance(nearFaccountDateDily.getFaccountDeabalance());
            }
        }
    }

    private void accumulateDtCountAndAmount(FtFinanceTitileDailyDomain ftFinanceTitileDailyDomain, VdFaccountDtDomain vdFaccountDtDomain) {
        if ("2".equals(vdFaccountDtDomain.getOrderDc())) {
            ftFinanceTitileDailyDomain.setFaccountCrcount(ftFinanceTitileDailyDomain.getFaccountCrcount() + 1L);
            ftFinanceTitileDailyDomain.setFaccountCramount(ftFinanceTitileDailyDomain.getFaccountCramount().add(vdFaccountDtDomain.getOrderAmount()));
        } else {
            ftFinanceTitileDailyDomain.setFaccountDecount(ftFinanceTitileDailyDomain.getFaccountDecount() + 1L);
            ftFinanceTitileDailyDomain.setFaccountDeamount(ftFinanceTitileDailyDomain.getFaccountDeamount().add(vdFaccountDtDomain.getOrderAmount()));
        }
    }

    private void calculateFaccountAbalance(FtFinanceTitileDailyDomain ftFinanceTitileDailyDomain, VdFaccountDtDomain vdFaccountDtDomain) {
        if ("2".equals(vdFaccountDtDomain.getCurrencyAfdirection()) && "2".equals(vdFaccountDtDomain.getCurrencyBfdirection())) {
            ftFinanceTitileDailyDomain.setFaccountCrabalance(ftFinanceTitileDailyDomain.getFaccountCrabalance().add(vdFaccountDtDomain.getOrderAmount()));
        } else if ("1".equals(vdFaccountDtDomain.getCurrencyAfdirection()) && "1".equals(vdFaccountDtDomain.getCurrencyBfdirection())) {
            ftFinanceTitileDailyDomain.setFaccountDeabalance(ftFinanceTitileDailyDomain.getFaccountDeabalance().add(vdFaccountDtDomain.getOrderAmount()));
        } else if ("2".equals(vdFaccountDtDomain.getCurrencyAfdirection()) && "1".equals(vdFaccountDtDomain.getCurrencyBfdirection())) {
            ftFinanceTitileDailyDomain.setFaccountCrabalance(vdFaccountDtDomain.getOrderAmount().subtract(ftFinanceTitileDailyDomain.getFaccountDeabalance()));
            ftFinanceTitileDailyDomain.setFaccountDeabalance(BigDecimal.ZERO);
        } else if ("1".equals(vdFaccountDtDomain.getCurrencyAfdirection()) && "2".equals(vdFaccountDtDomain.getCurrencyBfdirection())) {
            ftFinanceTitileDailyDomain.setFaccountDeabalance(vdFaccountDtDomain.getOrderAmount().subtract(ftFinanceTitileDailyDomain.getFaccountCrabalance()));
            ftFinanceTitileDailyDomain.setFaccountCrabalance(BigDecimal.ZERO);
        } else if ("2".equals(vdFaccountDtDomain.getCurrencyAfdirection()) && "0".equals(vdFaccountDtDomain.getCurrencyBfdirection())) {
            if (vdFaccountDtDomain.getOrderDc().equals(vdFaccountDtDomain.getCurrencyAfdirection())) {
                ftFinanceTitileDailyDomain.setFaccountCrabalance(ftFinanceTitileDailyDomain.getFaccountCrabalance().subtract(vdFaccountDtDomain.getOrderAmount()));
            } else {
                ftFinanceTitileDailyDomain.setFaccountCrabalance(ftFinanceTitileDailyDomain.getFaccountCrabalance().add(vdFaccountDtDomain.getOrderAmount()));
            }
        } else if ("1".equals(vdFaccountDtDomain.getCurrencyAfdirection()) && "0".equals(vdFaccountDtDomain.getCurrencyBfdirection())) {
            if (vdFaccountDtDomain.getOrderDc().equals(vdFaccountDtDomain.getCurrencyAfdirection())) {
                ftFinanceTitileDailyDomain.setFaccountDeabalance(ftFinanceTitileDailyDomain.getFaccountDeabalance().subtract(vdFaccountDtDomain.getOrderAmount()));
            } else {
                ftFinanceTitileDailyDomain.setFaccountDeabalance(ftFinanceTitileDailyDomain.getFaccountDeabalance().add(vdFaccountDtDomain.getOrderAmount()));
            }
        }
    }

    public static void main(String[] args) {
        String testDate = "20171001";
        String result = DateUtils.changeDateStrformat((String)testDate, (String)"yyyy-MM-dd", (String[])new String[]{"yyyyMMdd"});
        System.out.println(result);
    }
}

