/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.finterface.iface.base;

import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.finterface.iface.base.InterfaceRequest;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.TokenUtil;
import java.util.Map;

public abstract class BaseInterfaceServiceImpl
extends BaseServiceImpl {
    public static final String SYS_CODE = "INTERFACE";

    protected void loadConfig(InterfaceRequest request) {
        if (request == null) {
            this.logger.error("INTERFACE.BaseInterfaceServiceImpl.loadConfig", (Object)"request is null");
            return;
        }
        if (StringUtils.isBlank((String)request.getTenantCode()) || StringUtils.isBlank((String)request.getFinterfaceChannel())) {
            this.logger.error("INTERFACE.BaseInterfaceServiceImpl.loadConfig", (Object)"TenantCode or FinterfaceChannel is null");
            return;
        }
        String configkey = TokenUtil.genToken((Object[])new Object[]{request.getTenantCode(), request.getFinterfaceChannel()});
        String configStr = DisUtil.getMap((String)"FINTERFACE_CONFIG", (String)configkey);
        if (StringUtils.isBlank((String)configStr)) {
            this.logger.error("INTERFACE.BaseInterfaceServiceImpl.loadConfig", (Object)configStr);
            return;
        }
        Map configMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(configStr, String.class, String.class);
        if (configMap == null || configMap.isEmpty()) {
            this.logger.error("INTERFACE.BaseInterfaceServiceImpl.loadConfig", (Object)(String.valueOf(configkey) + ":" + configStr));
            return;
        }
        request.setConfigMap(configMap);
    }
}

