/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.job.schedule;

import com.yqbsoft.laser.service.job.schedule.AsynchroExecuteJob;
import com.yqbsoft.laser.service.job.schedule.ScheduleExeCache;
import com.yqbsoft.laser.service.job.schedule.ScheduleExeSuccessCache;
import com.yqbsoft.laser.service.job.schedule.ScheduleJobEntity;
import com.yqbsoft.laser.service.job.schedule.SynchroExecuteJob;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.TokenUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Repository;

@Repository(value="scheduleInfoManager")
@Scope(value="prototype")
public class ScheduleManager {
    public static final String SYS_CODE = "job.JOB.ScheduleManager";
    private static final SupperLogUtil logger = new SupperLogUtil(ScheduleManager.class);
    private static Scheduler scheduler;

    public static boolean enableCronSchedule(ScheduleJobEntity schedulingJob) {
        Date date = null;
        if (schedulingJob == null) {
            return false;
        }
        String scheduleTappkeyUUID = schedulingJob.getScheduleTappkeyUUID();
        String successKey = TokenUtil.genToken((Object[])new Object[]{schedulingJob.getJobName(), schedulingJob.getScheduleTappkey()});
        try {
            String exuuid;
            if ((StringUtils.isBlank((String)schedulingJob.getJobType()) || "0".equals(schedulingJob.getJobType())) && StringUtils.isNotBlank((String)(exuuid = ScheduleExeSuccessCache.getInstance().getSuccessJobMap().get(successKey))) && exuuid.equals(scheduleTappkeyUUID)) {
                return true;
            }
            if (!ScheduleManager.checkExJob(schedulingJob)) {
                return true;
            }
            String jobId = schedulingJob.getJobId();
            String jobGroupId = schedulingJob.getJobGroup();
            String triggerName = schedulingJob.getTriggerName();
            ScheduleExeCache.getInstance().put(jobId, schedulingJob);
            if (StringUtils.isBlank((String)schedulingJob.getJobType()) || "0".equals(schedulingJob.getJobType())) {
                JobDetail jobDetail = ScheduleManager.newJobDetail(jobId, jobGroupId, schedulingJob.isStateFull());
                SimpleTrigger trigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity(triggerName, jobGroupId).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule()).build();
                if (ScheduleManager.getRun(schedulingJob.getJobId(), schedulingJob.getJobGroup())) {
                    return false;
                }
                date = scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            } else {
                if (StringUtils.isBlank((String)schedulingJob.getCronExpression())) {
                    return false;
                }
                CronTrigger trigger = (CronTrigger)scheduler.getTrigger(TriggerKey.triggerKey((String)triggerName, (String)jobGroupId));
                JobDetail jobDetail = null;
                if (null != trigger) {
                    if (schedulingJob.getCronExpression().equals(trigger.getCronExpression())) {
                        return true;
                    }
                    trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(triggerName, jobGroupId).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)schedulingJob.getCronExpression())).build();
                    date = scheduler.rescheduleJob(TriggerKey.triggerKey((String)triggerName, (String)jobGroupId), (Trigger)trigger);
                } else {
                    jobDetail = ScheduleManager.newJobDetail(jobId, jobGroupId, schedulingJob.isStateFull());
                    trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(triggerName, jobGroupId).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)schedulingJob.getCronExpression())).build();
                    if (ScheduleManager.getRun(schedulingJob.getJobId(), schedulingJob.getJobGroup())) {
                        return false;
                    }
                    date = scheduler.scheduleJob(jobDetail, (Trigger)trigger);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean checkExJob(ScheduleJobEntity scheduleJobEntity) {
        String[] exJobIds = scheduleJobEntity.getExJobIds();
        if (exJobIds != null && exJobIds.length > 0) {
            String exuuid = null;
            for (int i = 0; i < exJobIds.length; ++i) {
                exuuid = ScheduleExeSuccessCache.getInstance().getSuccessJobMap().get(exJobIds[i]);
                if (StringUtils.isBlank((String)exuuid) || exuuid.equals(scheduleJobEntity.getScheduleTappkeyUUID())) {
                    logger.error("job.JOB.ScheduleManager.error", (Object)(scheduleJobEntity.getJobName() + "==" + exJobIds[i] + "==" + exuuid + "==" + scheduleJobEntity.getScheduleTappkeyUUID()));
                    return false;
                }
                logger.error("job.JOB.ScheduleManager.success", (Object)(scheduleJobEntity.getJobName() + "==" + exJobIds[i] + "==" + exuuid + "==" + scheduleJobEntity.getScheduleTappkeyUUID()));
            }
        }
        return true;
    }

    private static JobDetail newJobDetail(String jobId, String jobGroupId, boolean isStateFull) {
        JobDetail jobDetail = null;
        jobDetail = isStateFull ? JobBuilder.newJob(SynchroExecuteJob.class).withIdentity(jobId, jobGroupId).build() : JobBuilder.newJob(AsynchroExecuteJob.class).withIdentity(jobId, jobGroupId).build();
        return jobDetail;
    }

    public static boolean disableSchedule(String jobId, String jobGroupId) {
        if (StringUtils.isBlank((String)jobId) || StringUtils.isBlank((String)jobGroupId)) {
            return false;
        }
        ScheduleExeCache.getInstance().getJobMap().remove(jobId);
        try {
            Trigger trigger = ScheduleManager.getJobTrigger(jobId, jobGroupId);
            if (null != trigger) {
                scheduler.pauseTrigger(trigger.getKey());
                scheduler.unscheduleJob(trigger.getKey());
                boolean flag = scheduler.deleteJob(JobKey.jobKey((String)jobId, (String)jobGroupId));
                return flag;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static JobDetail getJobDetail(String jobId, String jobGroupId) {
        if (StringUtils.isBlank((String)jobId)) {
            return null;
        }
        try {
            return scheduler.getJobDetail(JobKey.jobKey((String)jobId, (String)jobGroupId));
        }
        catch (SchedulerException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Trigger getJobTrigger(String jobId, String jobGroupId) {
        if (StringUtils.isBlank((String)jobId)) {
            return null;
        }
        try {
            return scheduler.getTrigger(TriggerKey.triggerKey((String)(jobId + "Trigger"), (String)jobGroupId));
        }
        catch (SchedulerException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void executePauseJob(String jobId, String jobGroupId) {
        try {
            scheduler.pauseJob(JobKey.jobKey((String)jobId, (String)jobGroupId));
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    public static void executeResumeJob(String jobId, String jobGroupId) {
        try {
            scheduler.resumeJob(JobKey.jobKey((String)jobId, (String)jobGroupId));
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    public static void executeTriggerJob(ScheduleJobEntity schedulingJob) {
        JobKey jobKey = JobKey.jobKey((String)schedulingJob.getJobId(), (String)schedulingJob.getJobGroup());
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("schedulingJob", (Object)schedulingJob);
        try {
            scheduler.triggerJob(jobKey, jobDataMap);
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    public static List<ScheduleJobEntity> query() {
        ArrayList<ScheduleJobEntity> jobList = new ArrayList<ScheduleJobEntity>();
        try {
            GroupMatcher matcher = GroupMatcher.anyJobGroup();
            Set jobKeys = scheduler.getJobKeys(matcher);
            for (JobKey jobKey : jobKeys) {
                List triggers = scheduler.getTriggersOfJob(jobKey);
                for (Trigger trigger : triggers) {
                    ScheduleJobEntity job = new ScheduleJobEntity();
                    job.setJobId(jobKey.getName().split("@")[0]);
                    job.setJobName(jobKey.getName().split("@").length > 1 ? jobKey.getName().split("@")[1] : "");
                    job.setJobGroup(jobKey.getGroup());
                    Trigger.TriggerState triggerState = scheduler.getTriggerState(trigger.getKey());
                    job.setJobStatus(triggerState.name());
                    if (trigger instanceof CronTrigger) {
                        CronTrigger cronTrigger = (CronTrigger)trigger;
                        String cronExpression = cronTrigger.getCronExpression();
                        job.setCronExpression(cronExpression);
                    }
                    jobList.add(job);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jobList;
    }

    public static List<ScheduleJobEntity> queryRun() {
        ArrayList<ScheduleJobEntity> jobList = new ArrayList<ScheduleJobEntity>();
        try {
            List executingJobs = scheduler.getCurrentlyExecutingJobs();
            for (JobExecutionContext executingJob : executingJobs) {
                JobDetail jobDetail = executingJob.getJobDetail();
                JobKey jobKey = jobDetail.getKey();
                Trigger trigger = executingJob.getTrigger();
                ScheduleJobEntity job = new ScheduleJobEntity();
                job.setJobId(jobKey.getName().split("@")[0]);
                job.setJobName(jobKey.getName().split("@").length > 1 ? jobKey.getName().split("@")[1] : "");
                job.setJobGroup(jobKey.getGroup());
                Trigger.TriggerState triggerState = scheduler.getTriggerState(trigger.getKey());
                job.setJobStatus(triggerState.name());
                if (trigger instanceof CronTrigger) {
                    CronTrigger cronTrigger = (CronTrigger)trigger;
                    String cronExpression = cronTrigger.getCronExpression();
                    job.setCronExpression(cronExpression);
                }
                jobList.add(job);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jobList;
    }

    public static boolean getRun(String jobId, String groupId) {
        boolean runflag = false;
        Trigger trigger = ScheduleManager.getJobTrigger(jobId, groupId);
        if (trigger != null) {
            runflag = true;
        }
        return runflag;
    }

    static {
        StdSchedulerFactory sf = new StdSchedulerFactory();
        try {
            scheduler = sf.getScheduler();
            scheduler.start();
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
    }
}

