/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.job.schedule;

import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.suppercore.point.RegeditBean;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashSet;
import java.util.Set;

public class PointUtil {
    public static final Long REGEDIT_OVER_TIME = 10000L;
    public static final String VFOAPPMANAGE_LINEINFO = "EcoreAppmanage-lineInfo";

    public static boolean isAppOnline(String appmanageAppkey) {
        if (StringUtils.isBlank((String)appmanageAppkey)) {
            return false;
        }
        RegeditBean regeditBean = null;
        if (null != ServletMain.regeditBean && appmanageAppkey.equals(ServletMain.regeditBean.getAppkey())) {
            regeditBean = ServletMain.regeditBean;
        }
        if (null == regeditBean) {
            regeditBean = PointUtil.getRegeditBean(appmanageAppkey);
        }
        if (regeditBean == null) {
            return false;
        }
        return System.currentTimeMillis() <= regeditBean.getLastDate().getTime() + REGEDIT_OVER_TIME;
    }

    public static RegeditBean getRegeditBean(String appmanageAppkey) {
        String js = DisUtil.getMap((String)VFOAPPMANAGE_LINEINFO, (String)appmanageAppkey);
        if (StringUtils.isBlank((String)js)) {
            return null;
        }
        RegeditBean regeditBean = (RegeditBean)JsonUtil.buildNormalBinder().getJsonToObject(js, RegeditBean.class);
        return regeditBean;
    }

    public static Set<String> getPointAppKeys(String appmanageIcode, String appmanageAppkey) {
        HashSet<String> pointAppKeys = DisUtil.smembers((String)appmanageIcode);
        if (pointAppKeys == null || pointAppKeys.isEmpty()) {
            pointAppKeys = new HashSet<String>();
            pointAppKeys.add(appmanageAppkey);
        }
        HashSet<String> newAppKey = new HashSet<String>();
        for (String appmanageKey : pointAppKeys) {
            RegeditBean regeditBean = PointUtil.getRegeditBean(appmanageKey);
            if (regeditBean == null || System.currentTimeMillis() > regeditBean.getLastDate().getTime() + REGEDIT_OVER_TIME) continue;
            newAppKey.add(appmanageKey);
        }
        if (newAppKey.isEmpty()) {
            newAppKey.add(appmanageAppkey);
        }
        return newAppKey;
    }
}

