/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.job.schedule;

import com.yqbsoft.laser.service.job.schedule.BaseExecuteServiceImpl;
import com.yqbsoft.laser.service.job.schedule.PointUtil;
import com.yqbsoft.laser.service.job.schedule.ScheduleExeErrorCache;
import com.yqbsoft.laser.service.job.schedule.ScheduleExeSuccessCache;
import com.yqbsoft.laser.service.job.schedule.ScheduleExecuteService;
import com.yqbsoft.laser.service.job.schedule.ScheduleJobEntity;
import com.yqbsoft.laser.service.job.schedule.ScheduleManager;
import com.yqbsoft.laser.service.suppercore.core.JsonReBean;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.TokenUtil;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DefaultScheduleExecuteServiceImpl
extends BaseExecuteServiceImpl
implements ScheduleExecuteService {
    public static final String SYS_CODE = "job.JOB.DefaultScheduleExecuteServiceImpl";
    public static final Long REGEDIT_OVER_TIME = 360000L;

    @Override
    public void execute(ScheduleJobEntity scheduleJobEntity) {
        String jobId = scheduleJobEntity.getJobId();
        String jobGroupId = scheduleJobEntity.getJobGroup();
        String scheduleTappkey = scheduleJobEntity.getScheduleTappkey();
        String url = "";
        if (StringUtils.isNotBlank((String)scheduleTappkey) && !PointUtil.isAppOnline(scheduleTappkey)) {
            this.logger.debug("job.JOB.DefaultScheduleExecuteServiceImpl.execute.nostart", (Object)(scheduleJobEntity.getJobName() + "\uff1a" + scheduleTappkey + "\u670d\u52a1\u672a\u542f\u52a8"));
            this.exceptionUpdateScheduleMsg(scheduleJobEntity, scheduleTappkey + "\u670d\u52a1\u672a\u542f\u52a8");
            return;
        }
        try {
            this.setScheduleService(scheduleJobEntity.getScheduleService());
            Map<String, Object> pmap = scheduleJobEntity.getParamMap();
            if (pmap == null || pmap.isEmpty() || StringUtils.isBlank((String)((String)pmap.get("url")))) {
                if (ScheduleManager.disableSchedule(jobId, jobGroupId)) {
                    this.updateScheduleMsg(jobId, "\u8c03\u7528\u53c2\u6570\u4e3a\u7a7a");
                }
                return;
            }
            url = (String)pmap.get("url");
            String param = (String)pmap.get("param");
            String type = (String)pmap.get("type");
            if (StringUtils.isBlank((String)type)) {
                type = "GET";
            }
            Map<String, String> params = this.getParams(param);
            String restr = "";
            this.logger.info("job.JOB.DefaultScheduleExecuteServiceImpl.execute.run", (Object)(scheduleJobEntity.getJobName() + "\uff1a" + url));
            restr = type.equals("GET") ? WebUtils.doGet((String)url, params) : WebUtils.doPost((String)url, params, (int)0, (int)0);
            this.logger.info("job.JOB.DefaultScheduleExecuteServiceImpl.execute.end", (Object)(scheduleJobEntity.getJobName() + "\uff1a" + restr));
            boolean flag = true;
            if (null != restr) {
                JsonReBean jrb = (JsonReBean)JsonUtil.buildNormalBinder().getJsonToObject(restr, JsonReBean.class);
                if (null == jrb || !jrb.isSuccess()) {
                    flag = false;
                    this.logger.error("DefaultScheduleExecuteServiceImpl.error", (Object)("(" + url + ")" + restr));
                    this.exceptionUpdateScheduleMsg(scheduleJobEntity, restr);
                } else {
                    flag = true;
                }
            }
            if (flag) {
                this.updateScheduleMsg(jobId, "");
                String successKey = TokenUtil.genToken((Object[])new Object[]{scheduleJobEntity.getJobName(), scheduleJobEntity.getScheduleTappkey()});
                ScheduleExeSuccessCache.getInstance().put(successKey, scheduleJobEntity.getScheduleTappkeyUUID());
                Set<String> pointAppKeys = PointUtil.getPointAppKeys(scheduleJobEntity.getScheduleTicode(), scheduleJobEntity.getScheduleTappkey());
                boolean allPointSuccess = true;
                for (String pointAppKey : pointAppKeys) {
                    String pointSuccessKey = TokenUtil.genToken((Object[])new Object[]{scheduleJobEntity.getJobName(), pointAppKey});
                    String uuid = ScheduleExeSuccessCache.getInstance().getSuccessJobMap().get(pointSuccessKey);
                    String nowUuid = this.getAppKeyCache().get(pointAppKey);
                    if (!StringUtils.isBlank((String)uuid) && uuid.equals(nowUuid)) continue;
                    allPointSuccess = false;
                    break;
                }
                if (allPointSuccess) {
                    this.logger.info("DefaultScheduleExecuteServiceImpl.allPointSuccess", (Object)("jobName=" + scheduleJobEntity.getJobName()));
                    ScheduleExeSuccessCache.getInstance().put(scheduleJobEntity.getJobName(), scheduleJobEntity.getJobName());
                }
                ScheduleExeErrorCache.getInstance().getErrorJobMap().remove(jobId);
                this.logger.info("DefaultScheduleExecuteServiceImpl", (Object)(successKey + "=" + scheduleJobEntity.getScheduleTappkeyUUID() + "\uff1a\u8c03\u5ea6\u4efb\u52a1\u6267\u884c\u6210\u529f..."));
            }
        }
        catch (Exception e) {
            this.logger.error("DefaultScheduleExecuteServiceImpl", (Object)url, (Throwable)e);
            this.exceptionUpdateScheduleMsg(scheduleJobEntity, e.getMessage());
        }
    }

    private Map<String, String> getParams(String param) {
        if (StringUtils.isBlank((String)param)) {
            return null;
        }
        HashMap<String, String> params = null;
        String[] paramStrs = param.split("&");
        if (paramStrs != null && paramStrs.length > 0) {
            params = new HashMap<String, String>();
            for (int i = 0; i < paramStrs.length; ++i) {
                params.put(paramStrs[i].split("=")[0], paramStrs[i].split("=")[1]);
            }
        }
        return params;
    }
}

