/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.log.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.log.dao.LogErrorLogMapper;
import com.yqbsoft.laser.service.log.domain.LogErrorLogDomain;
import com.yqbsoft.laser.service.log.model.LogErrorLog;
import com.yqbsoft.laser.service.log.service.LogErrorLogService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LogErrorLogServiceImpl
extends BaseServiceImpl
implements LogErrorLogService {
    public static final String SYS_CODE = "log.LOG.LogErrorLogServiceImpl";
    private LogErrorLogMapper logErrorLogMapper;

    public void setLogErrorLogMapper(LogErrorLogMapper logErrorLogMapper) {
        this.logErrorLogMapper = logErrorLogMapper;
    }

    private Date getSysDate() {
        try {
            return this.logErrorLogMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("log.LOG.LogErrorLogServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkErrorLog(LogErrorLogDomain logErrorLogDomain) {
        if (logErrorLogDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setErrorLogDefault(LogErrorLog logErrorLog) {
        if (logErrorLog == null) {
            return;
        }
        if (logErrorLog.getDataState() == null) {
            logErrorLog.setDataState(0);
        }
        if (logErrorLog.getGmtCreate() == null) {
            logErrorLog.setGmtCreate(this.getSysDate());
        }
        logErrorLog.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)logErrorLog.getLogErrorCode())) {
            logErrorLog.setLogErrorCode(this.createUUIDString());
        }
    }

    private int getErrorLogMaxCode() {
        int code = 0;
        try {
            return this.logErrorLogMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("log.LOG.LogErrorLogServiceImpl.getErrorLogMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setErrorLogUpdataDefault(LogErrorLog logErrorLog) {
        if (logErrorLog == null) {
            return;
        }
        logErrorLog.setGmtModified(this.getSysDate());
    }

    private void saveErrorLogModel(LogErrorLog logErrorLog) throws ApiException {
        if (logErrorLog == null) {
            return;
        }
        try {
            this.logErrorLogMapper.insert(logErrorLog);
        }
        catch (Exception e) {
            throw new ApiException("log.LOG.LogErrorLogServiceImpl.saveErrorLogModel.ex", (Throwable)e);
        }
    }

    private LogErrorLog getErrorLogModelById(Integer logErrorId) {
        if (logErrorId == null) {
            return null;
        }
        try {
            return this.logErrorLogMapper.selectByPrimaryKey(logErrorId);
        }
        catch (Exception e) {
            this.logger.error("log.LOG.LogErrorLogServiceImpl.getErrorLogModelById", (Throwable)e);
            return null;
        }
    }

    public LogErrorLog getErrorLogModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.logErrorLogMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("log.LOG.LogErrorLogServiceImpl.getErrorLogModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delErrorLogModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.logErrorLogMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("log.LOG.LogErrorLogServiceImpl.delErrorLogModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("log.LOG.LogErrorLogServiceImpl.delErrorLogModelByCode.num");
        }
    }

    private void deleteErrorLogModel(Integer logErrorId) throws ApiException {
        if (logErrorId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.logErrorLogMapper.deleteByPrimaryKey(logErrorId);
        }
        catch (Exception e) {
            throw new ApiException("log.LOG.LogErrorLogServiceImpl.deleteErrorLogModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("log.LOG.LogErrorLogServiceImpl.deleteErrorLogModel.num");
        }
    }

    private void updateErrorLogModel(LogErrorLog logErrorLog) throws ApiException {
        if (logErrorLog == null) {
            return;
        }
        try {
            this.logErrorLogMapper.updateByPrimaryKeySelective(logErrorLog);
        }
        catch (Exception e) {
            throw new ApiException("log.LOG.LogErrorLogServiceImpl.updateErrorLogModel.ex", (Throwable)e);
        }
    }

    private void updateStateErrorLogModel(Integer logErrorId, Integer dataState, Integer oldDataState) throws ApiException {
        if (logErrorId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("logErrorId", logErrorId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.logErrorLogMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("log.LOG.LogErrorLogServiceImpl.updateStateErrorLogModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("log.LOG.LogErrorLogServiceImpl.updateStateErrorLogModel.null");
        }
    }

    private LogErrorLog makeErrorLog(LogErrorLogDomain logErrorLogDomain, LogErrorLog logErrorLog) {
        if (logErrorLogDomain == null) {
            return null;
        }
        if (logErrorLog == null) {
            logErrorLog = new LogErrorLog();
        }
        try {
            BeanUtils.copyAllPropertys((Object)logErrorLog, (Object)logErrorLogDomain);
            return logErrorLog;
        }
        catch (Exception e) {
            this.logger.error("log.LOG.LogErrorLogServiceImpl.makeErrorLog", (Throwable)e);
            return null;
        }
    }

    private List<LogErrorLog> queryErrorLogModelPage(Map<String, Object> parammap) {
        try {
            return this.logErrorLogMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("log.LOG.LogErrorLogServiceImpl.queryErrorLogModel", (Throwable)e);
            return null;
        }
    }

    private int countErrorLog(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.logErrorLogMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("log.LOG.LogErrorLogServiceImpl.countErrorLog", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveErrorLog(LogErrorLogDomain logErrorLogDomain) throws ApiException {
        String msg = this.checkErrorLog(logErrorLogDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("log.LOG.LogErrorLogServiceImpl.saveErrorLog.checkErrorLog", msg);
        }
        LogErrorLog logErrorLog = this.makeErrorLog(logErrorLogDomain, null);
        this.setErrorLogDefault(logErrorLog);
        this.saveErrorLogModel(logErrorLog);
        return logErrorLog.getLogErrorCode();
    }

    @Override
    public void updateErrorLogState(Integer logErrorId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateErrorLogModel(logErrorId, dataState, oldDataState);
    }

    @Override
    public void updateErrorLog(LogErrorLogDomain logErrorLogDomain) throws ApiException {
        String msg = this.checkErrorLog(logErrorLogDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("log.LOG.LogErrorLogServiceImpl.updateErrorLog.checkErrorLog", msg);
        }
        LogErrorLog oldLogErrorLog = this.getErrorLogModelById(logErrorLogDomain.getLogErrorId());
        if (oldLogErrorLog == null) {
            throw new ApiException("log.LOG.LogErrorLogServiceImpl.updateErrorLog.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        LogErrorLog logErrorLog = this.makeErrorLog(logErrorLogDomain, oldLogErrorLog);
        this.setErrorLogUpdataDefault(logErrorLog);
        this.updateErrorLogModel(logErrorLog);
    }

    @Override
    public LogErrorLog getErrorLog(Integer logErrorId) {
        return this.getErrorLogModelById(logErrorId);
    }

    @Override
    public void deleteErrorLog(Integer logErrorId) throws ApiException {
        this.deleteErrorLogModel(logErrorId);
    }

    @Override
    public QueryResult<LogErrorLog> queryErrorLogPage(Map<String, Object> map) {
        List<LogErrorLog> logErrorLogList = this.queryErrorLogModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countErrorLog(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(logErrorLogList);
        return queryResult;
    }

    @Override
    public LogErrorLog getErrorLogByCode(Map<String, Object> map) {
        return this.getErrorLogModelByCode(map);
    }

    @Override
    public void delErrorLogByCode(Map<String, Object> map) throws ApiException {
        this.delErrorLogModelByCode(map);
    }
}

