/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.log.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.log.dao.LogLogMapper;
import com.yqbsoft.laser.service.log.domain.LogLogDomainBean;
import com.yqbsoft.laser.service.log.model.LogLog;
import com.yqbsoft.laser.service.log.service.LogService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LogServiceImpl
extends BaseServiceImpl
implements LogService {
    public static final String SYS_CODE = "log.LOG.LogServiceImpl";
    private LogLogMapper logLogMapper;

    public void setLogLogMapper(LogLogMapper logLogMapper) {
        this.logLogMapper = logLogMapper;
    }

    private Date getSysDate() {
        try {
            return this.logLogMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("log.LOG.LogServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkLog(LogLogDomainBean logLogDomainBean) {
        if (logLogDomainBean == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setLogDefault(LogLog logLog) {
        if (logLog == null) {
            return;
        }
        if (logLog.getDataState() == null) {
            logLog.setDataState(0);
        }
        if (logLog.getGmtCreate() == null) {
            logLog.setGmtCreate(this.getSysDate());
        }
        logLog.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)logLog.getLogCode())) {
            int code = this.getMaxCode();
            logLog.setLogCode(this.makeMaxCode8(++code));
        }
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.logLogMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("log.LOG.LogServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setLogUpdataDefault(LogLog logLog) {
        if (logLog == null) {
            return;
        }
        logLog.setGmtModified(this.getSysDate());
    }

    private void saveLogModel(LogLog logLog) throws ApiException {
        if (logLog == null) {
            return;
        }
        try {
            this.logLogMapper.insert(logLog);
        }
        catch (Exception e) {
            throw new ApiException("log.LOG.LogServiceImpl.saveFtpserverModel.ex", (Throwable)e);
        }
    }

    private LogLog getLogModelById(Integer logId) {
        if (logId == null) {
            return null;
        }
        try {
            return this.logLogMapper.selectByPrimaryKey(logId);
        }
        catch (Exception e) {
            this.logger.error("log.LOG.LogServiceImpl.getLogModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteLogModel(Integer logId) throws ApiException {
        if (logId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.logLogMapper.deleteByPrimaryKey(logId);
        }
        catch (Exception e) {
            throw new ApiException("log.LOG.LogServiceImpl.deleteLogModel.ex");
        }
        if (1 != i) {
            throw new ApiException("log.LOG.LogServiceImpl.deleteLogModel.num");
        }
    }

    private void updateLogModel(LogLog logLog) throws ApiException {
        if (logLog == null) {
            return;
        }
        try {
            this.logLogMapper.updateByPrimaryKeySelective(logLog);
        }
        catch (Exception e) {
            throw new ApiException("log.LOG.LogServiceImpl.updateLogModel.ex");
        }
    }

    private void updateStateLogModel(Integer logId, Integer dataState, Integer oldDataState) throws ApiException {
        if (logId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("logId", logId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.logLogMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("log.LOG.LogServiceImpl.updateStateLogModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("log.LOG.LogServiceImpl.updateStateLogModel.null");
        }
    }

    private LogLog makeLog(LogLogDomainBean logLogDomainBean, LogLog logLog) {
        if (logLogDomainBean == null) {
            return null;
        }
        if (logLog == null) {
            logLog = new LogLog();
        }
        try {
            BeanUtils.copyAllPropertys((Object)logLog, (Object)logLogDomainBean);
        }
        catch (Exception e) {
            this.logger.error("log.LOG.LogServiceImpl.makeLog", (Throwable)e);
        }
        return logLog;
    }

    private List<LogLog> queryLogModelPage(Map<String, Object> parammap) {
        try {
            return this.logLogMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("log.LOG.LogServiceImpl.queryLogModel", (Throwable)e);
            return null;
        }
    }

    private int countLog(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.logLogMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("log.LOG.LogServiceImpl.countLog", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveLog(LogLogDomainBean logLogDomainBean) throws ApiException {
        String msg = this.checkLog(logLogDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("log.LOG.LogServiceImpl.saveLog.checkLog", msg);
        }
        LogLog logLog = this.makeLog(logLogDomainBean, null);
        this.setLogDefault(logLog);
        this.saveLogModel(logLog);
    }

    @Override
    public void updateLogState(Integer logId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateLogModel(logId, dataState, oldDataState);
    }

    @Override
    public void updateLog(LogLogDomainBean logLogDomainBean) throws ApiException {
        String msg = this.checkLog(logLogDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("log.LOG.LogServiceImpl.updateLog.checkLog", msg);
        }
        LogLog oldLogLog = this.getLogModelById(logLogDomainBean.getLogId());
        if (oldLogLog == null) {
            throw new ApiException("log.LOG.LogServiceImpl.updateLog.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        LogLog logLog = this.makeLog(logLogDomainBean, oldLogLog);
        this.setLogUpdataDefault(logLog);
        this.updateLogModel(logLog);
    }

    @Override
    public LogLog getLog(Integer logId) {
        return this.getLogModelById(logId);
    }

    @Override
    public void deleteLog(Integer logId) throws ApiException {
        this.deleteLogModel(logId);
    }

    @Override
    public QueryResult<LogLog> queryLogPage(Map<String, Object> map) {
        List<LogLog> logLogList = this.queryLogModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countLog(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(logLogList);
        return queryResult;
    }
}

