/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.model.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.router.AppModel;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.model.dao.MrAppmodelMapper;
import com.yqbsoft.laser.service.model.domain.MrAppmodelDomain;
import com.yqbsoft.laser.service.model.domain.MrAppmodelReDomain;
import com.yqbsoft.laser.service.model.domain.MrPropertyReDomain;
import com.yqbsoft.laser.service.model.model.MrAppmodel;
import com.yqbsoft.laser.service.model.model.MrProperty;
import com.yqbsoft.laser.service.model.service.AppmodelService;
import com.yqbsoft.laser.service.model.service.PropertyService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AppmodelServiceImpl
extends BaseServiceImpl
implements AppmodelService {
    public static final String SYS_CODE = "mr.MODEL.AppmodelServiceImpl";
    private static final String CACHE_KEY = "EcoreAppModel-pro";
    private MrAppmodelMapper mrAppmodelMapper;
    private PropertyService propertyService;

    public void setPropertyService(PropertyService propertyService) {
        this.propertyService = propertyService;
    }

    public void setMrAppmodelMapper(MrAppmodelMapper mrAppmodelMapper) {
        this.mrAppmodelMapper = mrAppmodelMapper;
    }

    private Date getSysDate() {
        try {
            return this.mrAppmodelMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.AppmodelServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkAppmodel(MrAppmodelDomain mrAppmodelDomain) {
        if (null == mrAppmodelDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setAppmodelDefault(MrAppmodel mrAppmodel) {
        if (null == mrAppmodel) {
            return;
        }
        if (null == mrAppmodel.getDataState()) {
            mrAppmodel.setDataState(0);
        }
        if (null == mrAppmodel.getGmtCreate()) {
            mrAppmodel.setGmtCreate(this.getSysDate());
        }
        mrAppmodel.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)mrAppmodel.getAppmodelCode())) {
            int code = this.getMaxCode();
            mrAppmodel.setAppmodelCode(this.makeMaxCode8(++code));
        }
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.mrAppmodelMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.AppmodelServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setAppmodelUpdataDefault(MrAppmodel mrAppmodel) {
        if (null == mrAppmodel) {
            return;
        }
        mrAppmodel.setGmtModified(this.getSysDate());
    }

    private void saveAppmodelModel(MrAppmodel mrAppmodel) throws ApiException {
        if (null == mrAppmodel) {
            return;
        }
        try {
            this.mrAppmodelMapper.insert(mrAppmodel);
        }
        catch (Exception e) {
            throw new ApiException("mr.MODEL.AppmodelServiceImpl.saveAppmodelModel.ex", (Throwable)e);
        }
    }

    private MrAppmodel getAppmodelModelById(Integer appmodelId) {
        if (null == appmodelId) {
            return null;
        }
        try {
            return this.mrAppmodelMapper.selectByPrimaryKey(appmodelId);
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.AppmodelServiceImpl.getAppmodelModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteAppmodelModel(Integer appmodelId) throws ApiException {
        if (null == appmodelId) {
            return;
        }
        int i = 0;
        try {
            i = this.mrAppmodelMapper.deleteByPrimaryKey(appmodelId);
        }
        catch (Exception e) {
            throw new ApiException("mr.MODEL.AppmodelServiceImpl.deleteAppmodelModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mr.MODEL.AppmodelServiceImpl.deleteAppmodelModel.num");
        }
    }

    private void updateAppmodelModel(MrAppmodel mrAppmodel) throws ApiException {
        if (null == mrAppmodel) {
            return;
        }
        try {
            this.mrAppmodelMapper.updateByPrimaryKeySelective(mrAppmodel);
        }
        catch (Exception e) {
            throw new ApiException("mr.MODEL.AppmodelServiceImpl.updateAppmodelModel.ex", (Throwable)e);
        }
    }

    private void updateStateAppmodelModel(Integer appmodelId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == appmodelId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appmodelId", appmodelId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.mrAppmodelMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mr.MODEL.AppmodelServiceImpl.updateStateAppmodelModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mr.MODEL.AppmodelServiceImpl.updateStateAppmodelModel.null");
        }
    }

    private MrAppmodel makeAppmodel(MrAppmodelDomain mrAppmodelDomain, MrAppmodel mrAppmodel) {
        if (null == mrAppmodelDomain) {
            return null;
        }
        if (null == mrAppmodel) {
            mrAppmodel = new MrAppmodel();
        }
        try {
            BeanUtils.copyAllPropertys((Object)mrAppmodel, (Object)mrAppmodelDomain);
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.AppmodelServiceImpl.makeAppmodel", (Throwable)e);
        }
        return mrAppmodel;
    }

    private List<MrAppmodel> queryAppmodelModelPage(Map<String, Object> parammap) {
        try {
            return this.mrAppmodelMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.AppmodelServiceImpl.queryAppmodelModel", (Throwable)e);
            return null;
        }
    }

    private int countAppmodel(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.mrAppmodelMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.AppmodelServiceImpl.countAppmodel", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveAppmodel(MrAppmodelDomain mrAppmodelDomain) throws ApiException {
        String msg = this.checkAppmodel(mrAppmodelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mr.MODEL.AppmodelServiceImpl.saveAppmodel.checkAppmodel", msg);
        }
        MrAppmodel mrAppmodel = this.makeAppmodel(mrAppmodelDomain, null);
        this.setAppmodelDefault(mrAppmodel);
        this.saveAppmodelModel(mrAppmodel);
    }

    @Override
    public void updateAppmodelState(Integer appmodelId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateAppmodelModel(appmodelId, dataState, oldDataState);
        this.refreshCache(this.getAppmodel(appmodelId), dataState);
    }

    @Override
    public void updateAppmodel(MrAppmodelDomain mrAppmodelDomain) throws ApiException {
        String msg = this.checkAppmodel(mrAppmodelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mr.MODEL.AppmodelServiceImpl.updateAppmodel.checkAppmodel", msg);
        }
        MrAppmodel oldMrAppmodel = this.getAppmodelModelById(mrAppmodelDomain.getAppmodelId());
        if (null == oldMrAppmodel) {
            throw new ApiException("mr.MODEL.AppmodelServiceImpl.updateAppmodel.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        MrAppmodel mrAppmodel = this.makeAppmodel(mrAppmodelDomain, oldMrAppmodel);
        this.setAppmodelUpdataDefault(mrAppmodel);
        this.updateAppmodelModel(mrAppmodel);
    }

    @Override
    public MrAppmodel getAppmodel(Integer appmodelId) {
        return this.getAppmodelModelById(appmodelId);
    }

    @Override
    public void deleteAppmodel(Integer appmodelId) throws ApiException {
        this.deleteAppmodelModel(appmodelId);
    }

    @Override
    public QueryResult<MrAppmodel> queryAppmodelPage(Map<String, Object> map) {
        List<MrAppmodel> mrAppmodelList = this.queryAppmodelModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countAppmodel(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(mrAppmodelList);
        return queryResult;
    }

    @Override
    public void queryAppmodelCache() {
        this.info("mr.MODEL.AppmodelServiceImpl.queryAppmodelCache", "=======queryAppmodelCache\u8c03\u5ea6start=======");
        List<MrAppmodel> mrAppmodelList = this.queryAppmodelModelPage(this.getQueryParamMap("dataState", new Object[]{1}));
        if (mrAppmodelList == null || mrAppmodelList.isEmpty()) {
            DisUtil.delVer((String)CACHE_KEY);
            this.info("mr.MODEL.AppmodelServiceImpl.queryAppmodelCache", "=======queryAppmodelCache\u8c03\u5ea6end-del=======");
            return;
        }
        HashMap<String, List<AppModel>> smap = new HashMap<String, List<AppModel>>();
        for (MrAppmodel mrAppmodel : mrAppmodelList) {
            this.saveCache(mrAppmodel, smap);
        }
        DisUtil.setVer((String)CACHE_KEY, (String)JsonUtil.buildNormalBinder().toJson(smap));
        this.info("mr.MODEL.AppmodelServiceImpl.queryAppModelCache", "=======queryAppModelCache\u8c03\u5ea6end=======");
    }

    private AppModel makeAppModel(MrAppmodel mrAppmodel) {
        if (null == mrAppmodel) {
            return null;
        }
        AppModel appModel = new AppModel();
        try {
            BeanUtils.copyAllPropertys((Object)appModel, (Object)mrAppmodel);
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.AppmodelServiceImpl.makeAppModel", (Throwable)e);
        }
        return appModel;
    }

    private void refreshCache(MrAppmodel mrAppmodel, Integer dataState) {
        boolean addflag = dataState == 1;
        HashMap<String, List<AppModel>> map = DisUtil.getMapByListJson((String)CACHE_KEY, String.class, AppModel.class);
        if (map == null) {
            map = new HashMap<String, List<AppModel>>();
        }
        if (addflag) {
            this.saveCache(mrAppmodel, map);
        } else {
            this.deleteCache(mrAppmodel, map);
        }
        DisUtil.setVer((String)CACHE_KEY, (String)JsonUtil.buildNormalBinder().toJson(map));
    }

    private void deleteCache(MrAppmodel appModel, Map<String, List<AppModel>> map) {
        if (map == null) {
            return;
        }
        String key = appModel.getAppmanageApptype();
        List<AppModel> list = map.get(key);
        if (list == null || list.isEmpty()) {
            return;
        }
        Integer index = null;
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getAppmodelId().equals(appModel.getAppmodelId())) continue;
            index = i;
            break;
        }
        if (index != null) {
            list.remove(index);
        }
    }

    private void saveCache(MrAppmodel mrAppmodel, Map<String, List<AppModel>> map) {
        AppModel appModel = this.makeAppModel(mrAppmodel);
        String key = appModel.getAppmanageApptype();
        List<AppModel> list = map.get(key);
        if (list == null) {
            list = new ArrayList<AppModel>();
            map.put(key, list);
        }
        Integer index = null;
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getAppmodelId().equals(mrAppmodel.getAppmodelId())) continue;
            index = i;
            break;
        }
        if (index != null) {
            list.set(index, appModel);
        } else {
            list.add(appModel);
        }
    }

    @Override
    public MrAppmodel getAppmodelByName(String appmanageApptype, String paramName) {
        return this.getAppmodelModelByName(appmanageApptype, paramName);
    }

    private MrAppmodel getAppmodelModelByName(String appmanageApptype, String paramName) {
        MrAppmodel mrAppmodel = null;
        try {
            List<MrAppmodel> list = this.queryAppmodelModelPage(this.getQueryParamMap("appmanageApptype,paramName", new Object[]{appmanageApptype, paramName}));
            if (ListUtil.isNotEmpty(list)) {
                return list.get(0);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return mrAppmodel;
    }

    @Override
    public List<MrAppmodelReDomain> getAppmodelList(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            map = new HashMap<String, Object>();
        }
        map.put("order", true);
        List<MrAppmodel> mrAppmodelList = this.queryAppmodelModelPage(map);
        if (ListUtil.isEmpty(mrAppmodelList)) {
            return null;
        }
        ArrayList<MrAppmodelReDomain> mrAppmodelReDomainList = new ArrayList<MrAppmodelReDomain>();
        for (MrAppmodel mrAppmodel : mrAppmodelList) {
            MrProperty mrProperty = this.propertyService.getPropertyByCode(mrAppmodel.getPropertyCode());
            if (mrProperty == null) continue;
            mrAppmodel.setAppmodelExt1(mrProperty.getPropertyName());
            mrAppmodel.setAppmodelExt2(mrProperty.getPropertyInnum().toString());
            mrAppmodel.setAppmodelExt3(mrProperty.getPropertyDisplayType().toString());
            MrAppmodelReDomain mrAppmodelReDomain = this.makeAppmodel(mrAppmodel);
            mrAppmodelReDomain.setMrPropertyReDomain(this.makeProperty(mrProperty));
            mrAppmodelReDomainList.add(mrAppmodelReDomain);
        }
        return mrAppmodelReDomainList;
    }

    private MrAppmodelReDomain makeAppmodel(MrAppmodel mrAppmodel) {
        if (null == mrAppmodel) {
            return null;
        }
        MrAppmodelReDomain mrAppmodelReDomain = new MrAppmodelReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)mrAppmodelReDomain, (Object)mrAppmodel);
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.AppmodelServiceImpl.makeAppmodel", (Throwable)e);
        }
        return mrAppmodelReDomain;
    }

    private MrPropertyReDomain makeProperty(MrProperty mrProperty) {
        if (null == mrProperty) {
            return null;
        }
        MrPropertyReDomain mrPropertyReDomain = new MrPropertyReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)mrPropertyReDomain, (Object)mrProperty);
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.AppmodelServiceImpl.makeProperty", (Throwable)e);
        }
        return mrPropertyReDomain;
    }
}

