/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.model.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.model.dao.MrOptionMapper;
import com.yqbsoft.laser.service.model.domain.MrOptionDomain;
import com.yqbsoft.laser.service.model.domain.MrOptionReDomain;
import com.yqbsoft.laser.service.model.domain.MrPropertyReDomain;
import com.yqbsoft.laser.service.model.model.MrOption;
import com.yqbsoft.laser.service.model.model.MrProperty;
import com.yqbsoft.laser.service.model.service.OptionService;
import com.yqbsoft.laser.service.model.service.PropertyService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OptionServiceImpl
extends BaseServiceImpl
implements OptionService {
    public static final String SYS_CODE = "mr.MODEL.OptionServiceImpl";
    private MrOptionMapper mrOptionMapper;
    private PropertyService propertyService;

    public void setPropertyService(PropertyService propertyService) {
        this.propertyService = propertyService;
    }

    public void setMrOptionMapper(MrOptionMapper mrOptionMapper) {
        this.mrOptionMapper = mrOptionMapper;
    }

    private Date getSysDate() {
        try {
            return this.mrOptionMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.OptionServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkOption(MrOptionDomain mrOptionDomain) {
        if (null == mrOptionDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setOptionDefault(MrOption mrOption) {
        if (null == mrOption) {
            return;
        }
        if (null == mrOption.getDataState()) {
            mrOption.setDataState(0);
        }
        if (null == mrOption.getGmtCreate()) {
            mrOption.setGmtCreate(this.getSysDate());
        }
        mrOption.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)mrOption.getOptionCode())) {
            int code = this.getMaxCode();
            mrOption.setOptionCode(this.makeMaxCode8(++code));
        }
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.mrOptionMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.OptionServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOptionUpdataDefault(MrOption mrOption) {
        if (null == mrOption) {
            return;
        }
        mrOption.setGmtModified(this.getSysDate());
    }

    private void saveOptionModel(MrOption mrOption) throws ApiException {
        if (null == mrOption) {
            return;
        }
        try {
            this.mrOptionMapper.insert(mrOption);
        }
        catch (Exception e) {
            throw new ApiException("mr.MODEL.OptionServiceImpl.saveOptionModel.ex", (Throwable)e);
        }
    }

    private MrOption getOptionModelById(Integer optionId) {
        if (null == optionId) {
            return null;
        }
        try {
            return this.mrOptionMapper.selectByPrimaryKey(optionId);
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.OptionServiceImpl.getOptionModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteOptionModel(Integer optionId) throws ApiException {
        if (null == optionId) {
            return;
        }
        int i = 0;
        try {
            i = this.mrOptionMapper.deleteByPrimaryKey(optionId);
        }
        catch (Exception e) {
            throw new ApiException("mr.MODEL.OptionServiceImpl.deleteOptionModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mr.MODEL.OptionServiceImpl.deleteOptionModel.num");
        }
    }

    private void updateOptionModel(MrOption mrOption) throws ApiException {
        if (null == mrOption) {
            return;
        }
        try {
            this.mrOptionMapper.updateByPrimaryKeySelective(mrOption);
        }
        catch (Exception e) {
            throw new ApiException("mr.MODEL.OptionServiceImpl.updateOptionModel.ex", (Throwable)e);
        }
    }

    private void updateStateOptionModel(Integer optionId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == optionId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("optionId", optionId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.mrOptionMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mr.MODEL.OptionServiceImpl.updateStateOptionModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mr.MODEL.OptionServiceImpl.updateStateOptionModel.null");
        }
    }

    private MrOption makeOption(MrOptionDomain mrOptionDomain, MrOption mrOption) {
        if (null == mrOptionDomain) {
            return null;
        }
        if (null == mrOption) {
            mrOption = new MrOption();
        }
        try {
            BeanUtils.copyAllPropertys((Object)mrOption, (Object)mrOptionDomain);
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.OptionServiceImpl.makeOption", (Throwable)e);
        }
        return mrOption;
    }

    private List<MrOption> queryOptionModelPage(Map<String, Object> parammap) {
        try {
            return this.mrOptionMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.OptionServiceImpl.queryOptionModel", (Throwable)e);
            return null;
        }
    }

    private int countOption(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.mrOptionMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.OptionServiceImpl.countOption", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveOption(MrOptionDomain mrOptionDomain) throws ApiException {
        String msg = this.checkOption(mrOptionDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mr.MODEL.OptionServiceImpl.saveOption.checkOption", msg);
        }
        MrOption mrOption = this.makeOption(mrOptionDomain, null);
        this.setOptionDefault(mrOption);
        this.saveOptionModel(mrOption);
    }

    @Override
    public void updateOptionState(Integer optionId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateOptionModel(optionId, dataState, oldDataState);
    }

    @Override
    public void updateOption(MrOptionDomain mrOptionDomain) throws ApiException {
        String msg = this.checkOption(mrOptionDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mr.MODEL.OptionServiceImpl.updateOption.checkOption", msg);
        }
        MrOption oldMrOption = this.getOptionModelById(mrOptionDomain.getOptionId());
        if (null == oldMrOption) {
            throw new ApiException("mr.MODEL.OptionServiceImpl.updateOption.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        MrOption mrOption = this.makeOption(mrOptionDomain, oldMrOption);
        this.setOptionUpdataDefault(mrOption);
        this.updateOptionModel(mrOption);
    }

    @Override
    public MrOption getOption(Integer optionId) {
        return this.getOptionModelById(optionId);
    }

    @Override
    public void deleteOption(Integer optionId) throws ApiException {
        this.deleteOptionModel(optionId);
    }

    @Override
    public QueryResult<MrOption> queryOptionPage(Map<String, Object> map) {
        List<MrOption> mrOptionList = this.queryOptionModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOption(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(mrOptionList);
        return queryResult;
    }

    @Override
    public List<MrOptionReDomain> queryOptionList(Map<String, Object> map) {
        List<MrOption> mrOptionList = this.queryOptionModelPage(map);
        if (ListUtil.isEmpty(mrOptionList)) {
            return null;
        }
        ArrayList<MrOptionReDomain> mrOptionReDomainList = new ArrayList<MrOptionReDomain>();
        for (MrOption mrOption : mrOptionList) {
            MrProperty mrProperty = this.propertyService.getPropertyByCode(mrOption.getPropertyCode());
            if (mrProperty == null) continue;
            MrOptionReDomain mrOptionReDomain = this.makeOption(mrOption);
            mrOptionReDomain.setMrPropertyReDomain(this.makeProperty(mrProperty));
            mrOptionReDomainList.add(mrOptionReDomain);
        }
        return mrOptionReDomainList;
    }

    private MrOptionReDomain makeOption(MrOption mrOption) {
        if (null == mrOption) {
            return null;
        }
        MrOptionReDomain mrOptionReDomain = new MrOptionReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)mrOptionReDomain, (Object)mrOption);
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.OptionServiceImpl.makeOption", (Throwable)e);
        }
        return mrOptionReDomain;
    }

    private MrPropertyReDomain makeProperty(MrProperty mrProperty) {
        if (null == mrProperty) {
            return null;
        }
        MrPropertyReDomain mrPropertyReDomain = new MrPropertyReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)mrPropertyReDomain, (Object)mrProperty);
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.OptionServiceImpl.makeProperty", (Throwable)e);
        }
        return mrPropertyReDomain;
    }
}

