/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.model.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.model.dao.MrPropertyMapper;
import com.yqbsoft.laser.service.model.domain.MrPropertyDomain;
import com.yqbsoft.laser.service.model.model.MrProperty;
import com.yqbsoft.laser.service.model.service.PropertyService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PropertyServiceImpl
extends BaseServiceImpl
implements PropertyService {
    public static final String SYS_CODE = "mr.MODEL.PropertyServiceImpl";
    private MrPropertyMapper mrPropertyMapper;

    public void setMrPropertyMapper(MrPropertyMapper mrPropertyMapper) {
        this.mrPropertyMapper = mrPropertyMapper;
    }

    private Date getSysDate() {
        try {
            return this.mrPropertyMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.PropertyServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkProperty(MrPropertyDomain mrPropertyDomain) {
        if (null == mrPropertyDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setPropertyDefault(MrProperty mrProperty) {
        if (null == mrProperty) {
            return;
        }
        if (null == mrProperty.getDataState()) {
            mrProperty.setDataState(0);
        }
        if (null == mrProperty.getGmtCreate()) {
            mrProperty.setGmtCreate(this.getSysDate());
        }
        mrProperty.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)mrProperty.getPropertyCode())) {
            int code = this.getMaxCode();
            mrProperty.setPropertyCode(this.makeMaxCode8(++code));
        }
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.mrPropertyMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.PropertyServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPropertyUpdataDefault(MrProperty mrProperty) {
        if (null == mrProperty) {
            return;
        }
        mrProperty.setGmtModified(this.getSysDate());
    }

    private void savePropertyModel(MrProperty mrProperty) throws ApiException {
        if (null == mrProperty) {
            return;
        }
        try {
            this.mrPropertyMapper.insert(mrProperty);
        }
        catch (Exception e) {
            throw new ApiException("mr.MODEL.PropertyServiceImpl.savePropertyModel.ex", (Throwable)e);
        }
    }

    private MrProperty getPropertyModelById(Integer propertyId) {
        if (null == propertyId) {
            return null;
        }
        try {
            return this.mrPropertyMapper.selectByPrimaryKey(propertyId);
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.PropertyServiceImpl.getPropertyModelById", (Throwable)e);
            return null;
        }
    }

    private MrProperty getPropertyModelByCode(String propertyCode) {
        if (null == propertyCode) {
            return null;
        }
        try {
            return this.mrPropertyMapper.selectByCode(propertyCode);
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.PropertyServiceImpl.getPropertyModelByCode", (Throwable)e);
            return null;
        }
    }

    private void deletePropertyModel(Integer propertyId) throws ApiException {
        if (null == propertyId) {
            return;
        }
        int i = 0;
        try {
            i = this.mrPropertyMapper.deleteByPrimaryKey(propertyId);
        }
        catch (Exception e) {
            throw new ApiException("mr.MODEL.PropertyServiceImpl.deletePropertyModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mr.MODEL.PropertyServiceImpl.deletePropertyModel.num");
        }
    }

    private void updatePropertyModel(MrProperty mrProperty) throws ApiException {
        if (null == mrProperty) {
            return;
        }
        try {
            this.mrPropertyMapper.updateByPrimaryKeySelective(mrProperty);
        }
        catch (Exception e) {
            throw new ApiException("mr.MODEL.PropertyServiceImpl.updatePropertyModel.ex", (Throwable)e);
        }
    }

    private void updateStatePropertyModel(Integer propertyId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == propertyId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("propertyId", propertyId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.mrPropertyMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mr.MODEL.PropertyServiceImpl.updateStatePropertyModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mr.MODEL.PropertyServiceImpl.updateStatePropertyModel.null");
        }
    }

    private MrProperty makeProperty(MrPropertyDomain mrPropertyDomain, MrProperty mrProperty) {
        if (null == mrPropertyDomain) {
            return null;
        }
        if (null == mrProperty) {
            mrProperty = new MrProperty();
        }
        try {
            BeanUtils.copyAllPropertys((Object)mrProperty, (Object)mrPropertyDomain);
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.PropertyServiceImpl.makeProperty", (Throwable)e);
        }
        return mrProperty;
    }

    private List<MrProperty> queryPropertyModelPage(Map<String, Object> parammap) {
        try {
            return this.mrPropertyMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.PropertyServiceImpl.queryPropertyModel", (Throwable)e);
            return null;
        }
    }

    private int countProperty(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.mrPropertyMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.PropertyServiceImpl.countProperty", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveProperty(MrPropertyDomain mrPropertyDomain) throws ApiException {
        String msg = this.checkProperty(mrPropertyDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mr.MODEL.PropertyServiceImpl.saveProperty.checkProperty", msg);
        }
        MrProperty mrProperty = this.makeProperty(mrPropertyDomain, null);
        this.setPropertyDefault(mrProperty);
        this.savePropertyModel(mrProperty);
    }

    @Override
    public void updatePropertyState(Integer propertyId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePropertyModel(propertyId, dataState, oldDataState);
    }

    @Override
    public void updateProperty(MrPropertyDomain mrPropertyDomain) throws ApiException {
        String msg = this.checkProperty(mrPropertyDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mr.MODEL.PropertyServiceImpl.updateProperty.checkProperty", msg);
        }
        MrProperty oldMrProperty = this.getPropertyModelById(mrPropertyDomain.getPropertyId());
        if (null == oldMrProperty) {
            throw new ApiException("mr.MODEL.PropertyServiceImpl.updateProperty.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        MrProperty mrProperty = this.makeProperty(mrPropertyDomain, oldMrProperty);
        this.setPropertyUpdataDefault(mrProperty);
        this.updatePropertyModel(mrProperty);
    }

    @Override
    public MrProperty getProperty(Integer propertyId) {
        return this.getPropertyModelById(propertyId);
    }

    @Override
    public void deleteProperty(Integer propertyId) throws ApiException {
        this.deletePropertyModel(propertyId);
    }

    @Override
    public QueryResult<MrProperty> queryPropertyPage(Map<String, Object> map) {
        List<MrProperty> mrPropertyList = this.queryPropertyModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countProperty(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(mrPropertyList);
        return queryResult;
    }

    @Override
    public MrProperty getPropertyByCode(String propertyCode) {
        return this.getPropertyModelByCode(propertyCode);
    }
}

